/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.summaries;

import com.ibm.bi.predict.data.matrix.Matrix;
import com.ibm.bi.predict.data.matrix.MatrixVectorFactory;

public class Means {
    private Means() {
    }

    public static double mean(double[] values) {
        double mean = 0.0;
        int i = 0;
        int count = 1;
        while (i < values.length) {
            mean += (values[i] - mean) / (double)count;
            ++i;
            ++count;
        }
        return mean;
    }

    public static double weightedMean(double[] values, double[] weights) {
        return Means.weightedMean(MatrixVectorFactory.matrixFromData((double[][])new double[][]{values}), MatrixVectorFactory.matrixFromData((double[][])new double[][]{weights}));
    }

    public static double weightedMean(Matrix values, Matrix weights) {
        if (values.columnDimension() != weights.columnDimension() || values.rowDimension() != weights.rowDimension()) {
            throw new IllegalArgumentException("Input arrays must be of equal length");
        }
        double weightedTotal = weights.sumAll((r, c, weight) -> weight * values.getValue(r, c));
        double totalRecordCount = weights.sum();
        return weightedTotal / totalRecordCount;
    }
}

