/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree;

import com.ibm.bi.predict.algorithms.tree.summary.SummaryStats;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.fastpattern.util.IntList;
import com.ibm.bi.predict.fastpattern.util.IntListPool;
import java.util.Set;
import java.util.TreeSet;

public class NodeContent {
    private final IntList rows;
    private final boolean forMissing;
    private final SummaryStats stats;
    private final Set<Double> splitValues;
    private DataColumn splitField;

    protected NodeContent(IntList rows, SummaryStats stats, DataColumn splitField, Set<Double> splitValues, boolean forMissing) {
        this.rows = rows;
        this.forMissing = forMissing;
        this.splitField = splitField;
        this.stats = stats;
        this.splitValues = splitValues;
    }

    public boolean containsValue(Object val) {
        return this.splitValues.contains(val);
    }

    public boolean forMissingValues() {
        return this.forMissing;
    }

    public NodeContent mergeContent(NodeContent b, IntListPool pool) {
        if (this.splitField != b.splitField) {
            throw new IllegalStateException("Cannot merge content with two different splitting columns");
        }
        TreeSet<Double> mergedSplitValues = new TreeSet<Double>(this.splitValues);
        mergedSplitValues.addAll(b.splitValues);
        IntList combRows = pool.get(this.rows.len() + b.rows().len()).addAll(this.rows).addAll(b.rows);
        return new NodeContent(combRows, this.stats.merge(b.stats), this.splitField, mergedSplitValues, false);
    }

    public int rowCount() {
        return this.stats.n();
    }

    public IntList rows() {
        return this.rows;
    }

    public DataColumn splitBy() {
        return this.splitField;
    }

    public Set<Double> splitValues() {
        return this.splitValues;
    }

    public SummaryStats stats() {
        return this.stats;
    }

    public String toString() {
        return String.format("[v=%1.5f, #rows=%d]", this.stats.expectedValue(), this.rowCount());
    }

    public double totalImpurity() {
        return this.stats.totalImpurity();
    }

    public double expectedValue() {
        return this.stats.expectedValue();
    }
}

