/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree;

import com.ibm.bi.predict.algorithms.tree.NodeContent;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.fastpattern.util.IntListPool;
import com.ibm.bi.predict.graph.TreeNode;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

class NodePartition
implements Comparable<NodePartition> {
    final DataColumn field;
    final TreeNode<NodeContent>[] parts;
    final TreeNode<NodeContent> combined;
    final double informationGain;

    NodePartition(DataColumn field, TreeNode<NodeContent>[] parts, TreeNode<NodeContent> combined) {
        this.field = field;
        this.parts = parts;
        this.combined = combined;
        this.informationGain = NodePartition.calculateInformationGain(parts, combined);
    }

    @Override
    public int compareTo(NodePartition o) {
        Set<Double> ovals;
        if (this == o) {
            return 0;
        }
        int diff = Double.compare(this.informationGain, o.informationGain);
        if (diff != 0) {
            return diff;
        }
        Set<Double> vals = this.combined.content().splitValues();
        Integer diff1 = this.compareSplitValues(vals, ovals = o.combined.content().splitValues());
        if (diff1 != null) {
            return diff1;
        }
        if (this.field.getIndex() < o.field.getIndex()) {
            return 1;
        }
        if (this.field.getIndex() > o.field.getIndex()) {
            return -1;
        }
        return 0;
    }

    public void releaseListsToPool(IntListPool pool) {
        for (TreeNode<NodeContent> part : this.parts) {
            pool.releaseToPool(part.content().rows());
        }
    }

    private Integer compareSplitValues(Set<Double> vals, Set<Double> ovals) {
        if (ovals == null) {
            return vals == null ? 0 : -1;
        }
        int diff = Integer.compare(ovals.size(), vals.size());
        if (diff != 0) {
            return diff;
        }
        Iterator<Double> valIt = vals.iterator();
        Iterator<Double> oValIt = ovals.iterator();
        while (valIt.hasNext()) {
            diff = Double.compare(valIt.next(), oValIt.next());
            if (diff == 0) continue;
            return diff;
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof NodePartition && this.compareTo((NodePartition)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.combined.content().splitValues(), this.informationGain);
    }

    boolean sharesParts(NodePartition other) {
        for (TreeNode<NodeContent> a : this.parts) {
            for (TreeNode<NodeContent> b : other.parts) {
                if (a != b) continue;
                return true;
            }
        }
        return false;
    }

    private static double calculateInformationGain(TreeNode<NodeContent>[] parts, TreeNode<NodeContent> combined) {
        double partsImpurity = 0.0;
        for (TreeNode<NodeContent> part : parts) {
            partsImpurity += part.content().totalImpurity();
        }
        return combined.content().totalImpurity() - partsImpurity;
    }

    public String toString() {
        return String.format("{%s, splits=%d, gain=%1.5f}", this.field.toString(), this.parts.length, this.informationGain);
    }
}

