/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree;

import com.ibm.bi.predict.algorithms.tree.NodeContent;
import com.ibm.bi.predict.algorithms.tree.NodePartition;
import com.ibm.bi.predict.algorithms.tree.TreeNodeBuilder;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.util.IntListPool;
import com.ibm.bi.predict.graph.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PartitionNodesMerger {
    private final DataColumn target;
    private final int minNodeSize;
    private final double minimumInformationGain;
    private final IntListPool pool;

    PartitionNodesMerger(DataColumn target, int minNodeSize, double minimumInformationGain, IntListPool pool) {
        this.target = target;
        this.minNodeSize = minNodeSize;
        this.minimumInformationGain = minimumInformationGain;
        this.pool = pool;
    }

    NodePartition merge(NodePartition split) {
        boolean onlyMergeNeighbors = this.checkMergeNeighbors(split);
        TreeNode<NodeContent>[] splits = split.parts;
        int nSplits = splits.length;
        List<NodePartition> candidates = this.makeMergeCandidates(split.field, splits, onlyMergeNeighbors);
        while (!candidates.isEmpty()) {
            nSplits = this.mergeBestCandidate(candidates, splits, nSplits, onlyMergeNeighbors);
        }
        candidates = this.makeMissingMergeCandidates(split.field, splits, nSplits, onlyMergeNeighbors);
        if (!candidates.isEmpty()) {
            nSplits = this.mergeBestCandidate(candidates, splits, nSplits, onlyMergeNeighbors);
        }
        if (nSplits == 1) {
            return null;
        }
        if (nSplits == splits.length) {
            return split;
        }
        TreeNode[] splitArray = new TreeNode[nSplits];
        System.arraycopy(splits, 0, splitArray, 0, nSplits);
        return new NodePartition(split.field, splitArray, split.combined);
    }

    private int mergeBestCandidate(List<NodePartition> candidates, TreeNode<NodeContent>[] splits, int nSplits, boolean onlyMergeNeighbors) {
        int nSplitsNew = nSplits;
        NodePartition best = PartitionNodesMerger.getBestCandidate(candidates);
        int mergedNodeIndex = this.updateSplitArray(splits, nSplitsNew, best);
        TreeNode<NodeContent> mergedNode = best.combined;
        candidates.removeIf(m -> m.sharesParts(best));
        DataColumn field = best.field;
        this.updateCandidate(onlyMergeNeighbors, splits, --nSplitsNew, candidates, mergedNodeIndex, mergedNode, field);
        return nSplitsNew;
    }

    private void updateCandidate(boolean onlyMergeNeighbors, TreeNode<NodeContent>[] splits, int nSplits, List<NodePartition> candidates, int mergedNodeIndex, TreeNode<NodeContent> mergedNode, DataColumn field) {
        block4: {
            int i;
            block3: {
                if (!onlyMergeNeighbors) break block3;
                if (mergedNodeIndex > 0) {
                    this.addIfValid(field, candidates, splits[mergedNodeIndex - 1], mergedNode);
                }
                if (mergedNodeIndex >= nSplits - 1) break block4;
                boolean mergingWithLastNode = mergedNodeIndex == nSplits - 2;
                boolean lastNodeIsForMissingValues = splits[nSplits - 1].content().forMissingValues();
                if (mergingWithLastNode && lastNodeIsForMissingValues) break block4;
                this.addIfValid(field, candidates, mergedNode, splits[mergedNodeIndex + 1]);
                break block4;
            }
            for (i = 0; i < mergedNodeIndex; ++i) {
                this.addIfValid(field, candidates, splits[i], mergedNode);
            }
            for (i = mergedNodeIndex + 1; i < nSplits; ++i) {
                this.addIfValid(field, candidates, mergedNode, splits[i]);
            }
        }
    }

    private static NodePartition getBestCandidate(List<NodePartition> candidates) {
        NodePartition newBest = null;
        for (NodePartition candidate : candidates) {
            if (newBest != null && candidate.compareTo(newBest) >= 0) continue;
            newBest = candidate;
        }
        return newBest;
    }

    private boolean checkMergeNeighbors(NodePartition split) {
        return split.field.getType() != FieldType.CATEGORICAL || this.target.getType() != FieldType.CATEGORICAL;
    }

    List<NodePartition> makeMergeCandidates(DataColumn field, TreeNode<NodeContent>[] splits, boolean onlyMergeNeighbors) {
        ArrayList<NodePartition> result = new ArrayList<NodePartition>();
        int n = splits.length;
        if (onlyMergeNeighbors) {
            if (splits[n - 1].content().forMissingValues()) {
                --n;
            }
            for (int i = 0; i < n - 1; ++i) {
                this.addIfValid(field, result, splits[i], splits[i + 1]);
            }
        } else {
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    this.addIfValid(field, result, splits[i], splits[j]);
                }
            }
        }
        return result;
    }

    List<NodePartition> makeMissingMergeCandidates(DataColumn field, TreeNode<NodeContent>[] splits, int nSplits, boolean onlyMergeNeighbors) {
        if (!onlyMergeNeighbors || nSplits < 2) {
            return Collections.emptyList();
        }
        if (!splits[nSplits - 1].content().forMissingValues()) {
            return Collections.emptyList();
        }
        ArrayList<NodePartition> result = new ArrayList<NodePartition>();
        for (int i = 0; i < nSplits - 1; ++i) {
            this.addIfValid(field, result, splits[i], splits[nSplits - 1]);
        }
        return result;
    }

    private void addIfValid(DataColumn field, List<NodePartition> candidates, TreeNode<NodeContent> a, TreeNode<NodeContent> b) {
        NodePartition merge = this.getMergedPartition(field, a, b);
        if (this.isMergeCandidate(a, b, merge)) {
            candidates.add(merge);
        } else {
            this.pool.releaseToPool(merge.combined.content().rows());
        }
    }

    private boolean isMergeCandidate(TreeNode<NodeContent> a, TreeNode<NodeContent> b, NodePartition merge) {
        return a.content().rowCount() < this.minNodeSize || b.content().rowCount() < this.minNodeSize || merge.informationGain < this.minimumInformationGain;
    }

    int updateSplitArray(TreeNode<NodeContent>[] nodes, int nSplits, NodePartition partition) {
        assert (partition.parts.length == 2);
        TreeNode<NodeContent> a = partition.parts[0];
        TreeNode<NodeContent> b = partition.parts[1];
        int index = 0;
        while (nodes[index] != a) {
            assert (nodes[index] != b);
            ++index;
        }
        nodes[index] = partition.combined;
        int i = index + 1;
        while (nodes[i] != b) {
            ++i;
        }
        ++i;
        while (i < nSplits) {
            nodes[i - 1] = nodes[i];
            ++i;
        }
        this.pool.releaseToPool(a.content().rows());
        this.pool.releaseToPool(b.content().rows());
        return index;
    }

    private NodePartition getMergedPartition(DataColumn field, TreeNode<NodeContent> a, TreeNode<NodeContent> b) {
        return new NodePartition(field, new TreeNode[]{a, b}, this.mergeNodes(a, b));
    }

    TreeNode<NodeContent> mergeNodes(TreeNode<NodeContent> a, TreeNode<NodeContent> b) {
        return TreeNodeBuilder.mergeNodes(a, b, this.pool);
    }
}

