/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree;

import com.ibm.bi.predict.algorithms.tree.NodeContent;
import com.ibm.bi.predict.algorithms.tree.summary.SummaryStats;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.util.IntList;
import com.ibm.bi.predict.fastpattern.util.IntListPool;
import com.ibm.bi.predict.graph.TreeNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class TreeNodeBuilder {
    TreeNodeBuilder() {
    }

    private static TreeNode<NodeContent>[] makeSplits(TreeNode<NodeContent> node, Double[] keys, Map<Double, IntList> map, DataColumn splitter) {
        boolean hasMissingValues = splitter.getStatus().contains(DataColumn.Status.ADDED_MISSING);
        int lastCategory = splitter.getCategoryCount() - 1;
        DataColumn target = node.content().stats().target();
        TreeNode[] partition = new TreeNode[keys.length];
        for (int i = 0; i < partition.length; ++i) {
            Double key = keys[i];
            boolean missingValueRowsLocal = hasMissingValues && key == (double)lastCategory;
            IntList rows = map.get(key);
            SummaryStats stats = SummaryStats.of(target, rows);
            NodeContent content = new NodeContent(rows, stats, splitter, Collections.singleton(key), missingValueRowsLocal);
            partition[i] = new TreeNode<NodeContent>(key.toString(), content, node);
        }
        return partition;
    }

    static TreeNode<NodeContent>[] splitByColumnValues(TreeNode<NodeContent> node, DataColumn splitter, IntListPool pool) {
        IntList rows = node.content().rows();
        int sizeGuess = rows.len() / splitter.getCategoryCount() + 4;
        HashMap<Double, IntList> map = new HashMap<Double, IntList>(splitter.getCategoryCount());
        rows.forEach(row -> map.computeIfAbsent(splitter.getValue(row), r -> pool.get(sizeGuess)).add(row));
        int splitCount = map.size();
        if (splitCount == 1) {
            return null;
        }
        Object[] keys = map.keySet().toArray(new Double[splitCount]);
        if (splitter.getType() != FieldType.CATEGORICAL) {
            Arrays.sort(keys);
            return TreeNodeBuilder.makeSplits(node, (Double[])keys, map, splitter);
        }
        TreeNode<NodeContent>[] partition = TreeNodeBuilder.makeSplits(node, (Double[])keys, map, splitter);
        if (node.content().stats().target().getType() != FieldType.CATEGORICAL) {
            Arrays.sort(partition, Comparator.comparingDouble(node1 -> ((NodeContent)node1.content()).expectedValue()));
        }
        return partition;
    }

    static TreeNode<NodeContent> makeRoot(DataColumn target, IntList rows) {
        SummaryStats stats = SummaryStats.of(target, rows);
        NodeContent content = new NodeContent(rows, stats, null, null, false);
        return new TreeNode<NodeContent>("", content, null);
    }

    static TreeNode<NodeContent> mergeNodes(TreeNode<NodeContent> a, TreeNode<NodeContent> b, IntListPool pool) {
        NodeContent mergedContent = a.content().mergeContent(b.content(), pool);
        return new TreeNode<NodeContent>("", mergedContent, a.parent());
    }
}

