/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree.summary;

import com.ibm.bi.predict.algorithms.tree.summary.CategoricalSummaryStats;
import com.ibm.bi.predict.algorithms.tree.summary.ContinuousSummaryStats;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.util.IntList;

public abstract class SummaryStats {
    protected final DataColumn target;
    protected int n;

    public SummaryStats(DataColumn target, int n) {
        assert (n > 0);
        this.target = target;
        this.n = n;
    }

    public SummaryStats(int n) {
        this(null, n);
    }

    public static SummaryStats of(DataColumn target, IntList rows) {
        if (target.getType() == FieldType.CATEGORICAL) {
            return new CategoricalSummaryStats(target, rows);
        }
        return new ContinuousSummaryStats(target, rows);
    }

    public abstract int[] categoryFrequencies();

    public abstract double std();

    public abstract double expectedValue();

    protected abstract double impurity();

    public final int n() {
        return this.n;
    }

    public DataColumn target() {
        return this.target;
    }

    public double totalImpurity() {
        return (double)this.n * this.impurity();
    }

    public abstract SummaryStats merge(SummaryStats var1);
}

