/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.tree.util;

import com.ibm.bi.predict.data.Category;
import java.util.Comparator;
import java.util.Locale;
import java.util.Random;

public class TreeParameters {
    private double minimumInfoGainAsFractionOfTotalPossible;
    private double minimumInfoGainForMerge;
    private int minNodeSizeAbsolute;
    private double minNodeSizeAsFractionOfTotal;
    private int maxTreeSize;
    private boolean isPruningEnabled;
    private double testFraction;
    private double minAccuracy;
    private int randomSeed = 13;
    private double predictorImportanceCutoff = 0.005;
    private double predictorImportanceAdjustment = 0.045;
    private double predictorImportanceMultiplier = 0.8;

    public TreeParameters(double minimumInfoGainAsFractionOfTotalPossible, double minimumInfoGainForMerge, int minNodeSizeAbsolute, double minNodeSizeAsFractionOfTotal, int maxTreeSize, double minAccuracy, boolean isPruningEnabled) {
        this.minimumInfoGainAsFractionOfTotalPossible = minimumInfoGainAsFractionOfTotalPossible;
        this.minimumInfoGainForMerge = minimumInfoGainForMerge;
        this.minNodeSizeAbsolute = minNodeSizeAbsolute;
        this.minNodeSizeAsFractionOfTotal = minNodeSizeAsFractionOfTotal;
        this.maxTreeSize = maxTreeSize;
        this.minAccuracy = minAccuracy;
        this.isPruningEnabled = isPruningEnabled;
    }

    public static TreeParameters continuous() {
        TreeParameters param = new TreeParameters(0.001, 0.0045, 25, 0.0025, 36, 0.1, true);
        return param.setPredictorImportanceCutoff(0.0);
    }

    public static TreeParameters categorical() {
        return new TreeParameters(0.001, 0.0045, 25, 0.0025, 36, 0.1, true);
    }

    public double minimumInfoGainAsFractionOfTotalPossible() {
        return this.minimumInfoGainAsFractionOfTotalPossible;
    }

    public int minNodeSizeAbsolute() {
        return this.minNodeSizeAbsolute;
    }

    public double minNodeSizeAsFractionOfTotal() {
        return this.minNodeSizeAsFractionOfTotal;
    }

    public int maxTreeSize() {
        return this.maxTreeSize;
    }

    public boolean isPruningEnabled() {
        return this.isPruningEnabled;
    }

    public TreeParameters setMinimumInfoGainAsFractionOfTotalPossible(double minimumInfoGainAsFractionOfTotalPossible) {
        this.minimumInfoGainAsFractionOfTotalPossible = minimumInfoGainAsFractionOfTotalPossible;
        return this;
    }

    public TreeParameters setMinimumInfoGainForMerge(double minimumInfoGainForMerge) {
        this.minimumInfoGainForMerge = minimumInfoGainForMerge;
        return this;
    }

    public TreeParameters setMinNodeSizeAbsolute(int minNodeSizeAbsolute) {
        this.minNodeSizeAbsolute = minNodeSizeAbsolute;
        return this;
    }

    public TreeParameters setMinNodeSizeAsFractionOfTotal(double minNodeSizeAsFractionOfTotal) {
        this.minNodeSizeAsFractionOfTotal = minNodeSizeAsFractionOfTotal;
        return this;
    }

    public TreeParameters setMaxTreeSize(int maxTreeSize) {
        this.maxTreeSize = maxTreeSize;
        return this;
    }

    public TreeParameters isPruningEnabled(boolean isPruningEnabled) {
        this.isPruningEnabled = isPruningEnabled;
        return this;
    }

    public double minimumInformationGain(double totalTreeImpurity) {
        return totalTreeImpurity * this.minimumInfoGainAsFractionOfTotalPossible;
    }

    public double minimumInformationGainForMerge(double totalTreeImpurity) {
        return totalTreeImpurity * this.minimumInfoGainForMerge;
    }

    public int minNodeSize(int count) {
        return (int)Math.max((double)this.minNodeSizeAbsolute, (double)count * this.minNodeSizeAsFractionOfTotal);
    }

    public TreeParameters setRandom(int randomSeed) {
        this.randomSeed = randomSeed;
        return this;
    }

    public double getTestFraction() {
        return this.testFraction;
    }

    public TreeParameters setTestFraction(double testFraction) {
        this.testFraction = testFraction;
        return this;
    }

    public Random makeRandom() {
        return new Random(this.randomSeed);
    }

    public double minAccuracy() {
        return this.minAccuracy;
    }

    public TreeParameters setMinAccuracy(double minAccuracy) {
        this.minAccuracy = minAccuracy;
        return this;
    }

    public double getPredictorImportanceCutoff() {
        return this.predictorImportanceCutoff;
    }

    public TreeParameters setPredictorImportanceCutoff(double relativePredictorImportanceCutoff) {
        this.predictorImportanceCutoff = relativePredictorImportanceCutoff;
        return this;
    }

    public double getPredictorImportanceAdjustment() {
        return this.predictorImportanceAdjustment;
    }

    public TreeParameters setPredictorImportanceAdjustment(double adjustement) {
        this.predictorImportanceAdjustment = adjustement;
        return this;
    }

    public double getPredictorImportanceMultipler() {
        return this.predictorImportanceMultiplier;
    }

    public TreeParameters setPredictorImportanceMultipler(double multiplier) {
        this.predictorImportanceMultiplier = multiplier;
        return this;
    }

    public Comparator<Category> getTargetCategorySortingStrategy(Locale locale) {
        return (c1, c2) -> c1.asString(locale).compareTo(c2.asString(locale));
    }
}

