/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers.summary;

import com.ibm.bi.predict.algorithms.table.OneWayAnova;
import com.ibm.bi.predict.algorithms.table.results.AnovaResult;
import com.ibm.bi.predict.sa.execution.utils.TriFunction;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.math.MissingValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class OneWayAnovaAdapter
implements AccumStats4InteractTests {
    private static final long serialVersionUID = 1L;
    private final TriFunction<List<Double>, List<Double>, List<Double>, OneWayAnova> anovaFactory;
    private final int numFactorCats;
    private final int targetIdx;
    private final int factorIdx;
    private final double[] numRecordsPerCategory;
    private final double[] targetMeans;
    private final double[] sumOfSquares;
    private AnovaResult result;

    public OneWayAnovaAdapter(int numFactorCats, int targetIdx, int factorIdx) {
        this(numFactorCats, targetIdx, factorIdx, (TriFunction<List<Double>, List<Double>, List<Double>, OneWayAnova>)((TriFunction)OneWayAnova::new));
    }

    public OneWayAnovaAdapter(int numFactorCats, int targetIdx, int factorIdx, TriFunction<List<Double>, List<Double>, List<Double>, OneWayAnova> anovaFactory) {
        this.numFactorCats = numFactorCats;
        this.targetIdx = targetIdx;
        this.factorIdx = factorIdx;
        this.anovaFactory = anovaFactory;
        this.numRecordsPerCategory = new double[numFactorCats];
        this.targetMeans = new double[numFactorCats];
        this.sumOfSquares = new double[numFactorCats];
    }

    public boolean update(double[] values, boolean validate) {
        double newCount;
        double targetVal = values[this.targetIdx];
        int factorCat = (int)values[this.factorIdx];
        if (validate && (MissingValue.isMissing((double)values[this.factorIdx]) || factorCat < 0 || factorCat > this.numFactorCats)) {
            return false;
        }
        double oldCount = this.numRecordsPerCategory[factorCat];
        this.numRecordsPerCategory[factorCat] = newCount = oldCount + 1.0;
        double oldMean = this.targetMeans[factorCat];
        int n = factorCat;
        this.targetMeans[n] = this.targetMeans[n] + 1.0 / newCount * (targetVal - oldMean);
        double diff = targetVal - oldMean;
        int n2 = factorCat;
        this.sumOfSquares[n2] = this.sumOfSquares[n2] + oldCount / newCount * diff * diff;
        return true;
    }

    public double computeStatistics() {
        this.result = ((OneWayAnova)this.anovaFactory.apply(Arrays.asList(ArrayUtils.toObject((double[])this.targetMeans)), Arrays.asList(ArrayUtils.toObject((double[])this.numRecordsPerCategory)), Arrays.asList(ArrayUtils.toObject((double[])this.sumOfSquares)))).compute();
        return this.result.pValue;
    }

    public double getFitMeasure() {
        return this.result.adjustedRSquared;
    }

    public double getAccuracy() {
        return 0.0;
    }

    public Object readObject(DataInput arg0) throws IOException {
        return null;
    }

    public void writeObject(DataOutput arg0) throws IOException {
    }

    public void addMissingCounts(double arg0, double arg1) {
    }

    public int compareTo(AccumStats4InteractTests arg0) {
        return 0;
    }

    public int[] getCovariateIndices() {
        return null;
    }

    public double getEffectSize() {
        return 0.0;
    }

    public int[] getFactorIndices() {
        return new int[]{this.factorIdx};
    }

    public double getInterestingness() {
        return 0.0;
    }

    public int getInvalidUpdCnt() {
        return 0;
    }

    public double getPValue() {
        return this.result.pValue;
    }

    public int getTargetIndex() {
        return this.targetIdx;
    }

    public double getTotalNRecs() {
        return 0.0;
    }

    public double getValidNRecs() {
        return 0.0;
    }

    public int getValidUpdCnt() {
        return 0;
    }

    public int getWeightIndex() {
        return 0;
    }

    public boolean merge(AccumStats4InteractTests arg0) {
        return false;
    }

    public boolean merge(List<? extends AccumStats4InteractTests> arg0) {
        return false;
    }

    public void setInterestingness(double arg0) {
    }
}

