/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers.summary;

import com.ibm.bi.predict.algorithms.table.OnewayChiSquareTestForCategTarget;
import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.OneWayAnovaAdapter;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.SummaryStats;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;

public class OneWaySummarizer {
    private final AccumulatorFunction accumulator;

    public OneWaySummarizer(AccumulatorFunction accumulator) {
        this.accumulator = accumulator;
    }

    public static AccumStats4InteractTests makeAnovaAccumulator(int targetIndex, int factorIndex, int factorCategories, int notUsed, int nRows, double threshold, int minCategoryFrequency) {
        OneWayAnovaAdapter accumStats = new OneWayAnovaAdapter(factorCategories, targetIndex, factorIndex);
        return accumStats;
    }

    public static AccumStats4InteractTests makeChiSquareTestAccumulator(int targetIndex, int factorIndex, int factorCategories, int targetCategories, int nRows, double threshold, int minCategoryFrequency) {
        return new OnewayChiSquareTestForCategTarget(targetCategories, factorCategories, targetIndex, factorIndex, nRows, -1, threshold, minCategoryFrequency);
    }

    public SummaryStats getSummaryStats(int factorIndex, int factorCategories, DataFrame df, double threshold, int minCategoryFrequency) {
        int targetIndex = df.getTargetIndex();
        AccumStats4InteractTests a = this.accumulator.makerFunction(targetIndex, factorIndex, factorCategories, df.getFieldCategories(targetIndex), df.getNumRows(), threshold, minCategoryFrequency);
        this.accumulateRows(a, df);
        a.computeStatistics();
        return SummaryStats.construct(a, df);
    }

    private void accumulateRows(AccumStats4InteractTests accumStats, DataFrame df) {
        for (double[] row : df) {
            accumStats.update(row, true);
        }
    }

    @FunctionalInterface
    public static interface AccumulatorFunction {
        public AccumStats4InteractTests makerFunction(int var1, int var2, int var3, int var4, int var5, double var6, int var8);
    }
}

