/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers.summary;

import com.ibm.bi.predict.algorithms.EvaluationStatistic;
import com.ibm.bi.predict.algorithms.table.AbstractChiSquareTestForCategTarget;
import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.CategoricalSummaryStats;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.ContinuousSummaryStats;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import java.util.EnumMap;
import java.util.Map;

public abstract class SummaryStats {
    protected Map<EvaluationStatistic, Double> evaluation = new EnumMap<EvaluationStatistic, Double>(EvaluationStatistic.class);

    protected SummaryStats() {
    }

    public static SummaryStats construct(AccumStats4InteractTests accumStats, DataFrame dataFrame) {
        SummaryStats stats;
        if (dataFrame.getFieldType(dataFrame.getTargetIndex()) == FieldType.NUMERICAL) {
            stats = new ContinuousSummaryStats(accumStats.getPValue(), accumStats.getAccuracy(), accumStats.getFitMeasure());
        } else if (accumStats instanceof AbstractChiSquareTestForCategTarget) {
            AbstractChiSquareTestForCategTarget abstractAccumStats = (AbstractChiSquareTestForCategTarget)accumStats;
            stats = new CategoricalSummaryStats(accumStats.getPValue(), abstractAccumStats.getAccuracy(), abstractAccumStats.getAdjustedR2());
        } else {
            return null;
        }
        return stats;
    }

    public double getPValue() {
        return this.evaluation.get((Object)EvaluationStatistic.P_VALUE);
    }

    public abstract double getAdjustedRSquared();

    public abstract double getR2();

    public abstract double getClassificationAccuracy();

    public abstract double getSimpleClassificationAccuracy();

    public abstract double getAccuracy();
}

