/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.keydrivers.summary;

import com.ibm.bi.predict.algorithms.table.TwowayChiSquareTestForCategTarget;
import com.ibm.bi.predict.data.DataFrame;
import com.ibm.bi.predict.fastpattern.keydrivers.summary.SummaryStats;
import com.spss.ac.acmath.accumstats.AccumStats4InteractTests;
import com.spss.ac.acmath.accumstats.InteractTwoFactorsForContTarget;

public class TwoWaySummarizer {
    private final AccumulatorFunction accumulator;

    public TwoWaySummarizer(AccumulatorFunction accumulator) {
        this.accumulator = accumulator;
    }

    public static AccumStats4InteractTests makeAnovaAccumulator(int targetIndex, int factor1Index, int factor2Index, int factor1Categories, int factor2Categories, int notUsed, int nRows, double adjustValue, int minCategoryFrequency) {
        return new InteractTwoFactorsForContTarget(factor1Categories, factor2Categories, factor1Index, factor2Index, targetIndex, -1.7976931348623157E308, Double.MAX_VALUE, -1, false);
    }

    public static AccumStats4InteractTests makeChiSquareTestAccumulator(int targetIndex, int factor1Index, int factor2Index, int factor1Categories, int factor2Categories, int targetCategories, int nRows, double threshold, int minCategoryFrequency) {
        return new TwowayChiSquareTestForCategTarget(targetCategories, factor1Categories, factor2Categories, targetIndex, factor1Index, factor2Index, nRows, -1, threshold, minCategoryFrequency);
    }

    public SummaryStats getSummaryStats(int factor1Index, int factor2Index, int factor1Categories, int factor2Categories, DataFrame df, double threshold, int minCategoryFrequency) {
        int targetIndex = df.getTargetIndex();
        AccumStats4InteractTests accumStats = this.accumulator.makerFunction(targetIndex, factor1Index, factor2Index, factor1Categories, factor2Categories, df.getFieldCategories(targetIndex), df.getNumRows(), threshold, minCategoryFrequency);
        this.accumulateRows(accumStats, df);
        accumStats.computeStatistics();
        return SummaryStats.construct(accumStats, df);
    }

    private void accumulateRows(AccumStats4InteractTests accumStats, DataFrame df) {
        for (double[] row : df) {
            accumStats.update(row, true);
        }
    }

    @FunctionalInterface
    public static interface AccumulatorFunction {
        public AccumStats4InteractTests makerFunction(int var1, int var2, int var3, int var4, int var5, int var6, int var7, double var8, int var10);
    }
}

