/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.graph;

import com.ibm.bi.predict.graph.TreeNode;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Tree<T> {
    private final TreeNode<T> root;

    public static <T> Tree<T> build(Collection<String> nodes, Function<String, Collection<String>> childFunction, Function<String, T> contentFunction) {
        List<Tree<T>> trees = Tree.buildForest(nodes, childFunction, contentFunction);
        if (trees.size() > 1) {
            List rootIDs = trees.stream().map(t -> t.root.id()).collect(Collectors.toList());
            throw new IllegalArgumentException("This is not a tree. Multiple roots found: " + rootIDs);
        }
        return trees.get(0);
    }

    public static <T> List<Tree<T>> buildForest(Collection<String> nodes, Function<String, Collection<String>> childFunction, Function<String, T> contentFunction) {
        Function<String, Collection> childFunctionNew = childFunction.andThen(s -> s == null ? Collections.emptyList() : s);
        Set<String> roots = Tree.defineParents(nodes, childFunctionNew);
        return roots.stream().map(v -> Tree.defineChildren(new TreeNode((String)v, contentFunction.apply((String)v), null), contentFunction, childFunctionNew)).map(Tree::new).collect(Collectors.toList());
    }

    private static <T> TreeNode<T> defineChildren(TreeNode<T> node, Function<String, T> contentFunction, Function<String, Collection<String>> nodeToChildren) {
        TreeNode[] children = (TreeNode[])nodeToChildren.apply(node.id()).stream().map(s -> new TreeNode((String)s, contentFunction.apply((String)s), node)).toArray(TreeNode[]::new);
        node.setChildren(children);
        for (TreeNode child : children) {
            Tree.defineChildren(child, contentFunction, nodeToChildren);
        }
        return node;
    }

    private static <S> Set<S> defineParents(Collection<S> nodes, Function<S, Collection<S>> childFunction) {
        LinkedHashSet<S> noDefinedParent = new LinkedHashSet<S>(nodes);
        if (noDefinedParent.size() != nodes.size()) {
            throw new IllegalArgumentException("Duplicate Node appeared in nodes list");
        }
        LinkedHashMap<S, S> nodeToParent = new LinkedHashMap<S, S>();
        for (S node : nodes) {
            Collection<S> children = childFunction.apply(node);
            for (S child : children) {
                if (nodeToParent.put(child, node) != null) {
                    throw new IllegalArgumentException("Child has multiple parents defined: " + child);
                }
                noDefinedParent.remove(child);
            }
        }
        if (noDefinedParent.isEmpty()) {
            throw new IllegalArgumentException("This is not a tree. No root node could be identified");
        }
        return noDefinedParent;
    }

    private Tree(TreeNode<T> root) {
        this.root = root;
    }

    public TreeNode<T> find(String id) {
        return this.find(this.root, id);
    }

    private TreeNode<T> find(TreeNode<T> startNode, String targetID) {
        if (startNode.id().equals(targetID)) {
            return startNode;
        }
        for (TreeNode<T> child : startNode.children()) {
            TreeNode<T> result = this.find(child, targetID);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<TreeNode<T>> nodes() {
        return this.root.descendants();
    }

    public void print(PrintStream out, int tab) {
        int max = this.root.leaves().stream().mapToInt(stTree -> tab * stTree.depth() + stTree.id().length()).max().getAsInt();
        int abbrMax = 76 - max;
        this.walk(n -> {
            String head = StringUtils.repeat((char)' ', (int)(tab * n.depth())) + n.id();
            String lead = StringUtils.repeat((char)'.', (int)(max + 2 - head.length()));
            String content = StringUtils.abbreviate((String)n.content().toString(), (int)abbrMax);
            out.println(head + " " + lead + " " + content);
        }, false);
    }

    public TreeNode<T> root() {
        return this.root;
    }

    public void walk(Consumer<TreeNode<T>> consumer, boolean bottomUp) {
        this.root.walk(consumer, bottomUp);
    }
}

