/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class TreeNode<T> {
    private static final TreeNode[] NO_CHILDREN = new TreeNode[0];
    private final String id;
    private final int depth;
    private final TreeNode<T> parent;
    private TreeNode<T>[] children;
    private T content;

    public TreeNode(String id, T content, TreeNode<T> parent) {
        this.id = id;
        this.content = content;
        this.parent = parent;
        this.depth = parent == null ? 0 : parent.depth + 1;
        this.children = NO_CHILDREN;
    }

    public TreeNode<T> child(int n) {
        return this.children[n];
    }

    public int childCount() {
        return this.children.length;
    }

    public TreeNode<T>[] children() {
        return this.children;
    }

    public T content() {
        return this.content;
    }

    public TreeNode<T> content(T newContent) {
        this.content = newContent;
        return this;
    }

    public int depth() {
        return this.depth;
    }

    public List<TreeNode<T>> descendants() {
        ArrayList<TreeNode<T>> nodes = new ArrayList<TreeNode<T>>();
        this.walk(nodes::add, false);
        return nodes;
    }

    public boolean hasChildren() {
        return this.children.length > 0;
    }

    public String id() {
        return this.id;
    }

    public boolean isLeaf() {
        return this.children.length == 0;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public List<TreeNode<T>> leaves() {
        ArrayList nodes = new ArrayList();
        this.walk(n -> {
            if (n.isLeaf()) {
                nodes.add((TreeNode)n);
            }
        }, false);
        return nodes;
    }

    public TreeNode<T> parent() {
        return this.parent;
    }

    public TreeNode<T> setChildren(TreeNode<T>[] children) {
        this.children = children == null || children.length == 0 ? NO_CHILDREN : children;
        return this;
    }

    public String toString() {
        return this.id() + ": " + (this.content == null ? "null" : StringUtils.abbreviate((String)this.content.toString(), (int)20));
    }

    public void walk(Consumer<TreeNode<T>> consumer, boolean bottomUp) {
        if (!bottomUp) {
            consumer.accept(this);
        }
        for (TreeNode<TreeNode<TreeNode>> treeNode : this.children) {
            treeNode.walk(consumer, bottomUp);
        }
        if (bottomUp) {
            consumer.accept(this);
        }
    }
}

