/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.regex.Pattern;
import org.mariadb.jdbc.cognos.adaptor.MariaSubtype;
import org.mariadb.jdbc.cognos.adaptor.MariadbDatabaseMetadataAdaptor;

public class DriverMariadbAdaptorFactory
extends AdaptorFactory {
    MariaSubtype serverType;
    private static volatile AbstractPropertyLoader propertyLoader;

    protected void setPropertyLoader(AbstractPropertyLoader loader) {
        propertyLoader = loader;
    }

    public AbstractPropertyLoader getPropertyLoader() {
        return propertyLoader;
    }

    protected void registerWrappers() {
        super.registerWrappers();
        this.setDatabaseMetadataWrapper(new MariadbDatabaseMetadataAdaptor.Wrapper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection connect(Driver driver, String url, Properties driverProperties, Properties ibmCognosProperties) throws SQLException {
        Connection connection;
        block9: {
            connection = null;
            this.serverType = MariaSubtype.MARIADB;
            connection = driver.connect(url, driverProperties);
            try (Statement st = null;){
                st = connection.createStatement();
                st.execute("select @@version_comment");
                ResultSet rs = st.getResultSet();
                String version = null;
                if (rs != null) {
                    while (rs.next()) {
                        version = rs.getString(1);
                    }
                    rs.close();
                }
                if (version == null) break block9;
                for (MariaSubtype sqlType : MariaSubtype.values()) {
                    Pattern p = Pattern.compile(sqlType.name(), 2);
                    if (!p.matcher(version).find()) continue;
                    this.serverType = sqlType;
                    break;
                }
            }
        }
        return connection;
    }

    protected void determineSubType(Connection connection) throws SQLException {
        if (this.serverType != MariaSubtype.MARIADB) {
            this.setSubType(this.serverType.name().toLowerCase());
        } else {
            super.determineSubType(connection);
        }
    }
}

