/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.mariadb.jdbc.cognos.adaptor.MariaSubtype;

public class MariadbDatabaseMetadataAdaptor
extends BaseDatabaseMetadataAdaptor {
    private static final String MARIA_DB = "MariaDB";
    int serverMajor = 0;
    int serverMinor = 0;
    String version = null;

    public MariadbDatabaseMetadataAdaptor(Object obj, AdaptorFactory factory) {
        super((DatabaseMetaData)obj, factory);
        this.getVariantVersion();
    }

    protected int getDatabaseMajorVersionImpl() throws SQLException {
        int majorVersion = this.dmd.getDatabaseMajorVersion();
        if (this.factory.getSubType() != null) {
            switch (MariaSubtype.valueOf(this.factory.getSubType().toUpperCase())) {
                case MEMSQL: {
                    if (this.serverMajor <= 0) break;
                    majorVersion = this.serverMajor;
                }
            }
        }
        return majorVersion;
    }

    protected int getDatabaseMinorVersionImpl() throws SQLException {
        int minorVersion = this.dmd.getDatabaseMinorVersion();
        if (this.factory.getSubType() != null) {
            switch (MariaSubtype.valueOf(this.factory.getSubType().toUpperCase())) {
                case MEMSQL: {
                    if (this.serverMinor <= 0) break;
                    minorVersion = this.serverMinor;
                }
            }
        }
        return minorVersion;
    }

    protected String getDatabaseProductVersionImpl() throws SQLException {
        if (this.version != null) {
            return this.version;
        }
        return this.dmd.getDatabaseProductVersion();
    }

    private void getVariantVersion() {
        if (this.factory.getSubType() == null) {
            return;
        }
        switch (MariaSubtype.valueOf(this.factory.getSubType().toUpperCase())) {
            case MEMSQL: {
                this.setVersion(this.lookupServerVersion("select @@memsql_version"));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookupServerVersion(String query) {
        String serverVersion = null;
        if (query != null) {
            Statement st = null;
            try {
                st = this.dmd.getConnection().createStatement();
                st.execute(query);
                ResultSet rs = st.getResultSet();
                if (rs != null) {
                    while (rs.next()) {
                        serverVersion = rs.getString(1);
                    }
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return serverVersion;
    }

    private void setVersion(String version) {
        if (version != null) {
            String[] parts = version.split("\\.");
            try {
                if (parts.length > 0) {
                    this.serverMajor = Integer.parseInt(parts[0]);
                }
                if (parts.length > 1) {
                    this.serverMinor = Integer.parseInt(parts[1]);
                }
            }
            catch (NumberFormatException e) {
                this.serverMajor = 0;
                this.serverMinor = 0;
            }
        }
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new MariadbDatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

