/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.binding;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqebifw.cubingservices.DQServer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.model.marshal.V5JSONNodeDeserializer;
import com.ibm.bi.qs.model.marshal.V5XMLMapSerializer;
import com.ibm.bi.qs.rest.response.ServiceResponseBuilderFactory;
import com.ibm.bi.qs.rest.service.ExitCode;
import com.ibm.bi.qs.rest.service.MetadataCacheManager;
import com.ibm.bi.qs.rest.service.MonitoringThread;
import com.ibm.bi.qs.rest.service.ServiceState;
import com.ibm.bi.qs.rest.service.State;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.xqe.service.XQEServiceImpl;
import com.ibm.bi.qs.xqe.service.XqeDatasetService;
import com.ibm.bi.qs.xqe.service.actions.ActionFactory;
import com.ibm.bi.rest.RESTClientFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

@WebListener
public class QueryServiceServletContextListener
implements ServletContextListener {
    public static final String __OBJECT_MAPPER = "objectMapper";
    public static final String __XML_MAPPER = "xmlMapper";
    public static final String __MODEL_FACTORY = "modelFactory";
    public static final String __SERVICE_RESPONSE_BUILDER_FACTORY = "serviceResponseBuilderFactory";
    public static final String __QUERY_SERVICE = "queryService";

    public void contextDestroyed(ServletContextEvent arg0) {
        XQEServiceImpl.getInstance().terminate();
        RESTClientFactory.getInstance().shutdown();
        ServiceState.getInstance().goToShutdownState(ExitCode.NORMAL);
    }

    public void contextInitialized(ServletContextEvent arg0) {
        long begin = System.nanoTime();
        arg0.getServletContext().setAttribute(__OBJECT_MAPPER, (Object)new ObjectMapper());
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new V5XMLMapSerializer());
        simpleModule.addDeserializer(JsonNode.class, (JsonDeserializer)new V5JSONNodeDeserializer());
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.registerModule((Module)simpleModule);
        arg0.getServletContext().setAttribute(__XML_MAPPER, (Object)xmlMapper);
        ModelFactory modelFactory = ModelFactory.getInstance();
        arg0.getServletContext().setAttribute(__MODEL_FACTORY, (Object)modelFactory);
        XqeDatasetService xqeDatasetService = new XqeDatasetService();
        xqeDatasetService.setUp();
        arg0.getServletContext().setAttribute(__QUERY_SERVICE, (Object)xqeDatasetService);
        ServiceResponseBuilderFactory serviceResponseBuilderFactory = new ServiceResponseBuilderFactory(modelFactory, (QueryService)xqeDatasetService);
        arg0.getServletContext().setAttribute(__SERVICE_RESPONSE_BUILDER_FACTORY, (Object)serviceResponseBuilderFactory);
        ServiceState.getInstance();
        RESTClientFactory.getInstance().startup();
        DQServer.operatingSystemSpecifics();
        DQServer.initHomeDir();
        DQServer.initServerProperties();
        ActionFactory.getInstance();
        MetadataCacheManager.getMetadataCacheManager();
        if (!System.getProperties().containsKey("runstandalone")) {
            MonitoringThread t = new MonitoringThread();
            t.setDaemon(true);
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable t) {
                    XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQE, (String)"XQE", (String)"Exception", (LogLevel)LogLevel.ERROR).log(t);
                    ServiceState.getInstance().goToShutdownState(ExitCode.CRITICAL);
                }
            });
            t.start();
        }
        long end = System.nanoTime();
        double initTime = (double)(end - begin) / 1.0E9;
        ServiceState.getInstance().setStatus(State.RUNNING);
        XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQE, (String)"XQE", (String)"InitTerm", (LogLevel)LogLevel.INFO).log("InitTime: " + initTime + " secs");
    }
}

