/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.endpoints;

import com.ibm.ba.gemini.commons.trace.Trace;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.rest.endpoints.BaseEndPoint;
import com.ibm.bi.qs.rest.response.RequestType;
import com.ibm.bi.qs.rest.service.MetadataProviderFactory;
import com.ibm.bi.rs.ICapabilitiesFilter;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="queryservice admin", description="Administrative operations for queryservice")
@Path(value="/datasets/admin")
@ICapabilitiesFilter(capabilities={"canUseQueryServiceTool"})
public class AdminEndPoint
extends BaseEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminEndPoint.class);
    private static final String ENDPOINT_NAME = "AdminEndPoint-";
    private static final String DUMP_CACHE_NAME = "GET:dumpCache";
    private static final String DUMP_DMR_CACHE_NAME = "GET:dumpDMRCache";
    private static final String FLUSH_CACHE_NAME = "GET:flushCache";
    private static final String FLUSH_DMR_CACHE_NAME = "GET:flushDMRCache";

    public AdminEndPoint() {
        super(MetadataProviderFactory.ProviderType.BI);
    }

    @Trace(metricName="Dump queryservice cache", dispatcher=true)
    @GET
    @Path(value="dumpCache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Dump queryservice cache")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=204, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Response dumpCache(@QueryParam(value="dataSourceName") String dataSourceName, @QueryParam(value="catalogName") String catalogName, @QueryParam(value="cubeName") String cubeName) {
        if (dataSourceName == null && catalogName == null && cubeName == null) {
            return this.processSimpleAdminRequest(DUMP_CACHE_NAME, RequestType.DUMP_CACHE);
        }
        return this.processOLAPAdminRequest(DUMP_CACHE_NAME, RequestType.DUMP_CACHE, dataSourceName, catalogName, cubeName);
    }

    @Trace(metricName="Dump DMR queryservice cache", dispatcher=true)
    @GET
    @Path(value="dumpDMRCache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Dump DMR queryservice cache")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=204, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Response dumpDMRCache(@QueryParam(value="dataSourceName") String dataSourceName, @QueryParam(value="packageName") String packageName) {
        if (dataSourceName == null && packageName == null) {
            return this.processSimpleAdminRequest(DUMP_DMR_CACHE_NAME, RequestType.DUMP_DMR_CACHE);
        }
        return this.processDMRAdminRequest(DUMP_DMR_CACHE_NAME, RequestType.DUMP_DMR_CACHE, dataSourceName, packageName);
    }

    @Trace(metricName="Flush queryservice cache", dispatcher=true)
    @GET
    @Path(value="flushCache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Flush queryservice cache")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=204, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Response flushCache(@QueryParam(value="dataSourceName") String dataSourceName, @QueryParam(value="catalogName") String catalogName, @QueryParam(value="cubeName") String cubeName) {
        if (dataSourceName == null && catalogName == null && cubeName == null) {
            return this.processSimpleAdminRequest(FLUSH_CACHE_NAME, RequestType.FLUSH_CACHE);
        }
        return this.processOLAPAdminRequest(FLUSH_CACHE_NAME, RequestType.FLUSH_CACHE, dataSourceName, catalogName, cubeName);
    }

    @Trace(metricName="Flush DMR queryservice cache", dispatcher=true)
    @GET
    @Path(value="flushDMRCache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Flush DMR queryservice cache")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=204, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Response flushDMRCache(@QueryParam(value="dataSourceName") String dataSourceName, @QueryParam(value="packageName") String packageName) {
        if (dataSourceName == null && packageName == null) {
            return this.processSimpleAdminRequest(FLUSH_DMR_CACHE_NAME, RequestType.FLUSH_DMR_CACHE);
        }
        return this.processDMRAdminRequest(FLUSH_DMR_CACHE_NAME, RequestType.FLUSH_DMR_CACHE, dataSourceName, packageName);
    }

    private Response processSimpleAdminRequest(String methodName, RequestType requestType) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}{}", (Object)ENDPOINT_NAME, (Object)methodName);
            }
            return this.getResponseNoMetadata(requestType, null, null, null);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private Response processOLAPAdminRequest(String methodName, RequestType requestType, String dataSourceName, String catalogName, String cubeName) {
        try {
            if (LOGGER.isDebugEnabled()) {
                StringBuilder message = new StringBuilder();
                message.append(ENDPOINT_NAME).append(methodName);
                if (dataSourceName != null) {
                    message.append(", dataSourceName=").append(dataSourceName);
                }
                if (catalogName != null) {
                    message.append(", catalogName=").append(catalogName);
                }
                if (cubeName != null) {
                    message.append(", cubeName=").append(cubeName);
                }
                LOGGER.debug(message.toString());
            }
            List<String> filterIds = this.processOLAPParams(dataSourceName, catalogName, cubeName);
            return this.getResponseNoMetadata(requestType, null, null, filterIds);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private List<String> processOLAPParams(String dataSourceName, String catalogName, String cubeName) {
        if (dataSourceName == null || dataSourceName.isEmpty() || catalogName == null || catalogName.isEmpty() || cubeName == null || cubeName.isEmpty()) {
            throw new QueryServiceException(400, QueryServiceMessageKeys.INTERNAL_ERROR, "If parameters passed, they must include non-blank values for dataSourceName, catalogName and cubeName");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(dataSourceName);
        params.add(catalogName);
        params.add(cubeName);
        return params;
    }

    private Response processDMRAdminRequest(String methodName, RequestType requestType, String dataSourceName, String packageName) {
        try {
            if (LOGGER.isDebugEnabled()) {
                StringBuilder message = new StringBuilder();
                message.append(ENDPOINT_NAME).append(methodName);
                if (dataSourceName != null) {
                    message.append(", dataSourceName=").append(dataSourceName);
                }
                if (packageName != null) {
                    message.append(", packageName=").append(packageName);
                }
                LOGGER.debug(message.toString());
            }
            List<String> filterIds = this.processDMRParams(dataSourceName, packageName);
            return this.getResponseNoMetadata(requestType, null, null, filterIds);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private List<String> processDMRParams(String dataSourceName, String packageName) {
        boolean packageNameEmpty;
        boolean dataSourceEmpty = dataSourceName == null || dataSourceName.isEmpty();
        boolean bl = packageNameEmpty = packageName == null || packageName.isEmpty();
        if (!dataSourceEmpty && !packageNameEmpty) {
            throw new QueryServiceException(400, QueryServiceMessageKeys.INTERNAL_ERROR, "If parameters passed, must only provide non-blank value for dataSourceName or packageName");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(dataSourceName);
        params.add(packageName);
        return params;
    }
}

