/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.endpoints;

import com.cognos.xqe.exception.XQEExceptionUtils;
import com.cognos.xqe.metrics.MetricsManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.bi.platform.commons.shared.BIResource;
import com.ibm.bi.platform.commons.shared.UserPreferences;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.predict.generated.ExploreSpec;
import com.ibm.bi.qs.model.api.data.predict.generated.KeyDriverSpec;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.model.api.data.stats.generated.StatsSpec;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.rest.response.RequestType;
import com.ibm.bi.qs.rest.response.ServiceResponseBuilderFactory;
import com.ibm.bi.qs.rest.service.MetadataProviderFactory;
import com.ibm.bi.qs.service.DataSetMetadataProvider;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;

public abstract class BaseEndPoint
extends BIResource {
    private ObjectMapper plainObjectMapper;
    private ServiceResponseBuilderFactory responseBuilderFactory;
    private ModelFactory modelFactory;
    private DataSetMetadataProvider datasetMetadataProvider;
    private final MetadataProviderFactory.ProviderType providerType;
    private ServletRequestContext servletRequestContext = null;

    public BaseEndPoint(MetadataProviderFactory.ProviderType providerType) {
        this.providerType = providerType;
    }

    private synchronized ServiceResponseBuilderFactory getResponseBuilderFactory() {
        if (this.responseBuilderFactory == null) {
            this.responseBuilderFactory = (ServiceResponseBuilderFactory)this.httpServletRequest.getServletContext().getAttribute("serviceResponseBuilderFactory");
        }
        return this.responseBuilderFactory;
    }

    void setResponseBuilderFactory(ServiceResponseBuilderFactory responseBuilderFactory) {
        this.responseBuilderFactory = responseBuilderFactory;
    }

    void setPlainObjectMapper(ObjectMapper objectMapper) {
        this.plainObjectMapper = objectMapper;
    }

    protected ObjectMapper getPlainObjectMapper() {
        if (null != this.plainObjectMapper) {
            return this.plainObjectMapper;
        }
        return (ObjectMapper)this.httpServletRequest.getServletContext().getAttribute("objectMapper");
    }

    protected synchronized ModelFactory getModelFactory() {
        if (this.modelFactory == null) {
            this.modelFactory = (ModelFactory)this.httpServletRequest.getServletContext().getAttribute("modelFactory");
        }
        return this.modelFactory;
    }

    void setModelFactory(ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    protected synchronized QueryService getDatasetService() {
        return (QueryService)this.httpServletRequest.getServletContext().getAttribute("queryService");
    }

    private DataSetMetadataProvider getDataSetMetadataProvider() {
        if (this.datasetMetadataProvider == null) {
            this.datasetMetadataProvider = MetadataProviderFactory.get().create(this.providerType, this.httpServletRequest);
        }
        return this.datasetMetadataProvider;
    }

    void setDataSetMetadataProvider(DataSetMetadataProvider datasetMetadataProvider) {
        this.datasetMetadataProvider = datasetMetadataProvider;
    }

    protected ServletRequestContext getServletRequestContext() {
        if (this.servletRequestContext != null) {
            return this.servletRequestContext;
        }
        UserPreferences up = null;
        if (this.httpServletRequest != null) {
            up = this.getUserPreferences();
            this.servletRequestContext = new ServletRequestContext(this.httpServletRequest, up);
            return this.servletRequestContext;
        }
        return new ServletRequestContext(null, null);
    }

    protected Response getResponseNoMetadata(RequestType requestType) throws Exception {
        Response.ResponseBuilder responseBuilder = null;
        long beginTime = System.currentTimeMillis();
        Throwable error = null;
        try {
            responseBuilder = this.getResponseBuilderFactory().createSimpleResponseBuilder(requestType);
            Response response = responseBuilder.build();
            return response;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.updateMetrics(requestType, endTime - beginTime, error);
            if (responseBuilder instanceof Closeable) {
                ((Closeable)responseBuilder).close();
            }
        }
    }

    protected Response getResponseNoMetadata(RequestType requestType, Request request, String resourceId, List<String> filterIds) throws Exception {
        Response.ResponseBuilder responseBuilder = null;
        long beginTime = System.currentTimeMillis();
        Throwable error = null;
        try {
            responseBuilder = this.getResponseBuilderFactory().createResponseBuilder(requestType, request, resourceId, filterIds, this.getServletRequestContext());
            Response response = responseBuilder.build();
            return response;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.updateMetrics(requestType, endTime - beginTime, error);
            if (responseBuilder instanceof Closeable) {
                ((Closeable)responseBuilder).close();
            }
        }
    }

    protected Response getResponseNoMetadataWithSpec(RequestType requestType, Request request, String specString) throws Exception {
        Response.ResponseBuilder responseBuilder = null;
        long beginTime = System.currentTimeMillis();
        Throwable error = null;
        try {
            responseBuilder = this.getResponseBuilderFactory().createResponseBuilder(requestType, request, null, specString, this.getServletRequestContext());
            Response response = responseBuilder.build();
            return response;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.updateMetrics(requestType, endTime - beginTime, error);
            if (responseBuilder instanceof Closeable) {
                ((Closeable)responseBuilder).close();
            }
        }
    }

    protected Response getResponse(RequestType requestType, Request request, DataSet dsMeta) throws Exception {
        Response.ResponseBuilder responseBuilder = null;
        long beginTime = System.currentTimeMillis();
        Throwable error = null;
        try {
            responseBuilder = this.getResponseBuilderFactory().createDatasetMeta(request, dsMeta, this.getServletRequestContext());
            Response response = responseBuilder.build();
            return response;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.updateMetrics(requestType, endTime - beginTime, error);
            if (responseBuilder instanceof Closeable) {
                ((Closeable)responseBuilder).close();
            }
        }
    }

    protected Response getResponse(RequestType requestType, Request request, DataSet dsMeta, String specString) throws Exception {
        Response.ResponseBuilder responseBuilder = null;
        long beginTime = System.currentTimeMillis();
        Throwable error = null;
        try {
            responseBuilder = this.createResponseBuilder(requestType, request, dsMeta, specString);
            Response response = responseBuilder.build();
            return response;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.updateMetrics(requestType, endTime - beginTime, error);
            if (responseBuilder instanceof Closeable) {
                ((Closeable)responseBuilder).close();
            }
        }
    }

    private Response.ResponseBuilder createResponseBuilder(RequestType requestType, Request request, DataSet dsMeta, String specString) throws Exception {
        ServletRequestContext servletRequestCtx = this.getServletRequestContext();
        return this.getResponseBuilderFactory().createResponseBuilder(requestType, request, dsMeta, specString, servletRequestCtx);
    }

    protected DataSet getDatasetMetadata(MetadataProviderFactory.ProviderType providerType, RequestType requestType, String datasetId, boolean refreshmd, String specString, Logger logger) {
        UserPreferences up;
        long begin = System.nanoTime();
        String contentLocale = null;
        if (this.httpServletRequest != null && (up = this.getUserPreferences()) != null) {
            contentLocale = up.getContentLocale();
        }
        ModelFactory theModelFactory = this.getModelFactory();
        DataSet dsMeta = this.getDataSetMetadataProvider().get(datasetId, contentLocale, refreshmd, BaseEndPoint.extractConnectionSpec(providerType, requestType, specString, theModelFactory), BaseEndPoint.getMetadataSubsetIDs(providerType, requestType, specString, theModelFactory), BaseEndPoint.extractVersion(providerType, requestType, specString, theModelFactory));
        if (dsMeta == null) {
            throw new QueryServiceException(404, QueryServiceMessageKeys.REST_RESOURCE_NOT_FOUND, "data set", datasetId);
        }
        if (logger.isDebugEnabled()) {
            try {
                this.modelFactory = this.getModelFactory();
                logger.debug("refreshmd: {}, dataset metadata: {}", (Object)refreshmd, (Object)this.modelFactory.toJSON((Object)dsMeta));
            }
            catch (IOException e) {
                logger.error("unexpected error converting dataset metadata to JSON", (Throwable)e);
            }
        }
        if (dsMeta.getSignonErrorMessage() == null) {
            long end = System.nanoTime();
            ServletRequestContext servletRequestCtx = this.getServletRequestContext();
            if (servletRequestCtx != null) {
                servletRequestCtx.setMetadataRetrievalTime(end - begin);
            }
        }
        return dsMeta;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractVersion(MetadataProviderFactory.ProviderType providerType, RequestType requestType, String specString, ModelFactory modelFactory) {
        String result = null;
        if (null == specString) return result;
        if (null == modelFactory) return result;
        if (MetadataProviderFactory.ProviderType.DAAS.equals((Object)providerType)) {
            return result;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(specString.getBytes(StandardCharsets.UTF_8));){
            switch (requestType) {
                case QUERY: 
                case V5_QUERYSET: {
                    QuerySpec querySpec = (QuerySpec)modelFactory.create((InputStream)is, QuerySpec.class);
                    result = querySpec.getVersion();
                    return result;
                }
            }
            return result;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getMetadataSubsetIDs(MetadataProviderFactory.ProviderType providerType, RequestType requestType, String specString, ModelFactory modelFactory) {
        List result = null;
        if (null == specString) return result;
        if (null == modelFactory) return result;
        if (MetadataProviderFactory.ProviderType.DAAS.equals((Object)providerType)) {
            return result;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(specString.getBytes(StandardCharsets.UTF_8));){
            switch (requestType) {
                case QUERY: 
                case V5_QUERYSET: 
                case DAAS_QUERY: 
                case DAAS_V5_QUERYSET: {
                    QuerySpec querySpec = (QuerySpec)modelFactory.create((InputStream)is, QuerySpec.class);
                    if (null == querySpec.getQueryHints()) return result;
                    if (null == querySpec.getQueryHints().getAdditionalProperties()) return result;
                    result = (List)querySpec.getQueryHints().getAdditionalProperties().get("metadataSubsetIDs");
                    return result;
                }
            }
            return result;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractConnectionSpec(MetadataProviderFactory.ProviderType providerType, RequestType requestType, String specString, ModelFactory modelFactory) {
        String result = null;
        if (null == specString) return result;
        if (null == modelFactory) return result;
        if (MetadataProviderFactory.ProviderType.DAAS.equals((Object)providerType)) {
            return result;
        }
        StringBuilder sb = new StringBuilder("{\"connections\":");
        try (ByteArrayInputStream is = new ByteArrayInputStream(specString.getBytes(StandardCharsets.UTF_8));){
            switch (requestType) {
                case QUERY: 
                case V5_QUERYSET: 
                case DAAS_QUERY: 
                case DAAS_V5_QUERYSET: {
                    QuerySpec querySpec = (QuerySpec)modelFactory.create((InputStream)is, QuerySpec.class);
                    if (null == querySpec.getConnections()) return result;
                    if (querySpec.getConnections().isEmpty()) return result;
                    result = sb.append(modelFactory.toJSON((Object)querySpec.getConnections())).append("}").toString();
                    return result;
                }
                case KEYDRIVER: {
                    KeyDriverSpec keyDriverSpec = (KeyDriverSpec)modelFactory.create((InputStream)is, KeyDriverSpec.class);
                    if (null == keyDriverSpec.getConnections()) return result;
                    if (keyDriverSpec.getConnections().isEmpty()) return result;
                    result = sb.append(modelFactory.toJSON((Object)keyDriverSpec.getConnections())).append("}").toString();
                    return result;
                }
                case PREDICT_EXPLORE: {
                    ExploreSpec exploreSpec = (ExploreSpec)modelFactory.create((InputStream)is, ExploreSpec.class);
                    if (null == exploreSpec.getConnections()) return result;
                    if (exploreSpec.getConnections().isEmpty()) return result;
                    result = sb.append(modelFactory.toJSON((Object)exploreSpec.getConnections())).append("}").toString();
                    return result;
                }
                case STATS: {
                    StatsSpec statsSpec = (StatsSpec)modelFactory.create((InputStream)is, StatsSpec.class);
                    if (null == statsSpec.getConnections()) return result;
                    if (statsSpec.getConnections().isEmpty()) return result;
                    result = sb.append(modelFactory.toJSON((Object)statsSpec.getConnections())).append("}").toString();
                    return result;
                }
            }
            return result;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void updateMetrics(RequestType requestType, long elapsedTime, Throwable error) {
        long correctedElapsedTime = elapsedTime;
        if (elapsedTime < 0L) {
            correctedElapsedTime = 0L;
        }
        switch (requestType) {
            case QUERY: 
            case V5_QUERYSET: 
            case DAAS_QUERY: 
            case DAAS_V5_QUERYSET: 
            case KEYDRIVER: 
            case PREDICT_EXPLORE: 
            case STATS: {
                MetricsManager.incrementCounter((String)"NumberOfReceivedRequests");
                MetricsManager.incrementCounter((String)"ServiceTimeAllRequests", (long)correctedElapsedTime);
                if (null != error) {
                    MetricsManager.incrementCounter((String)"NumberOfFailedRequests");
                    MetricsManager.incrementCounter((String)"ServiceTimeFailedRequests", (long)correctedElapsedTime);
                    MetricsManager.incrementCounter((String)"XqeFailedQueriesExecuted");
                    MetricsManager.incrementCounter((String)"XqeFailedQueriesExecutedTime", (long)correctedElapsedTime);
                    if (!XQEExceptionUtils.isCriticalThrowable((Throwable)error) && !XQEExceptionUtils.isCriticalThrowable((Throwable)error.getCause())) break;
                    MetricsManager.incrementCounter((String)"NumberOfCriticalFailures");
                    break;
                }
                MetricsManager.incrementCounter((String)"NumberOfSuccessfulRequests");
                MetricsManager.incrementCounter((String)"ServiceTimeSuccessfulRequests", (long)correctedElapsedTime);
                MetricsManager.incrementCounter((String)"XqeQueriesExecuted");
                MetricsManager.incrementCounter((String)"XqeQueriesExecutedTime", (long)correctedElapsedTime);
                break;
            }
        }
    }
}

