/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.endpoints;

import com.ibm.ba.gemini.commons.trace.Trace;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.rest.endpoints.BaseEndPoint;
import com.ibm.bi.qs.rest.response.RequestType;
import com.ibm.bi.qs.rest.service.MetadataProviderFactory;
import com.ibm.bi.qs.utils.MultipartUtil;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.wink.common.model.multipart.BufferedInMultiPart;
import org.apache.wink.common.model.multipart.InPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="daasdataset", description="Operations to a dataset for DAAS")
@Path(value="")
public class DAASEndPoint
extends BaseEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(DAASEndPoint.class);

    public DAASEndPoint() {
        super(MetadataProviderFactory.ProviderType.DAAS);
    }

    @Trace(metricName="Run a query and get metadata from a giving URL", dispatcher=true)
    @GET
    @Path(value="/data")
    @Produces(value={"application/json"})
    @ApiOperation(value="Run a query and get metadata from a giving URL", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getDatasetData(@Context Request request, @ApiParam(value="Query String") @DefaultValue(value="{}") @QueryParam(value="querySpec") String queryString, @ApiParam(value="module URL") @DefaultValue(value="") @QueryParam(value="moduleUrl") String moduleURL) {
        LOGGER.debug("getDatasetData: queryString=\"{}\" metadata URL=\"{}\"", (Object)queryString, (Object)moduleURL);
        try {
            return this.getDatasetDataInternal(request, moduleURL, queryString);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    @Trace(metricName="Run a query and get metadata from a giving URL", dispatcher=true)
    @POST
    @Path(value="/data")
    @Produces(value={"application/json"})
    @ApiOperation(value="Run a query and get metadata from a giving URL using POST", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getDatasetData(@Context Request request, @ApiParam(value="Query String") @DefaultValue(value="{}") BufferedInMultiPart inMP) {
        try {
            String moduleURL = null;
            String queryString = null;
            List parts = inMP.getParts();
            for (InPart part : parts) {
                String name = MultipartUtil.getPartName(part);
                if (name == null) continue;
                switch (name) {
                    case "querySpec": {
                        queryString = (String)part.getBody(String.class, null);
                        break;
                    }
                    case "moduleUrl": {
                        moduleURL = (String)part.getBody(String.class, null);
                    }
                }
            }
            LOGGER.debug("getDatasetData: queryString=\"{}\" metadata URL=\"{}\"", queryString, moduleURL);
            return this.getDatasetDataInternal(request, moduleURL, queryString);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private Response getDatasetDataInternal(Request request, String moduleURL, String queryString) throws Exception {
        DataSet dsMeta = this.getDatasetMetadata(moduleURL, true);
        if (dsMeta.getSignonErrorMessage() != null) {
            return Response.status((int)403).entity((Object)dsMeta.getSignonErrorMessage()).build();
        }
        return this.getResponse(RequestType.DAAS_QUERY, request, dsMeta, queryString);
    }

    @Trace(metricName="Debug the given dataset", dispatcher=true)
    @GET
    @Path(value="/data/debug")
    @Produces(value={"application/xml", "application/json"})
    @ApiOperation(value="Debug the given dataset", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response debugDatasetData(@Context Request request, @ApiParam(value="Query String") @DefaultValue(value="{}") @QueryParam(value="querySpec") String queryString, @ApiParam(value="module URL") @DefaultValue(value="") @QueryParam(value="moduleUrl") String moduleURL) {
        LOGGER.debug("debugDatasetData: queryString=\"{}\"", (Object)queryString);
        try {
            return this.debugDatasetDataInternal(request, queryString, moduleURL);
        }
        catch (Exception e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            return dssError.buildResponse(this.getServletRequestContext(), headers);
        }
    }

    @Trace(metricName="Debug the given dataset using post", dispatcher=true)
    @POST
    @Path(value="/data/debug")
    @Produces(value={"application/xml", "application/json"})
    @ApiOperation(value="Debug the given dataset using post", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response debugDatasetData(@Context Request request, @ApiParam(value="Query String") @DefaultValue(value="{}") BufferedInMultiPart inMP) {
        try {
            String moduleURL = null;
            String queryString = null;
            List parts = inMP.getParts();
            for (InPart part : parts) {
                String name = MultipartUtil.getPartName(part);
                if (name == null) continue;
                switch (name) {
                    case "querySpec": {
                        queryString = (String)part.getBody(String.class, null);
                        break;
                    }
                    case "moduleUrl": {
                        moduleURL = (String)part.getBody(String.class, null);
                    }
                }
            }
            LOGGER.debug("debugDatasetData: queryString=\"{}\"", queryString);
            return this.debugDatasetDataInternal(request, queryString, moduleURL);
        }
        catch (Exception e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            return dssError.buildResponse(this.getServletRequestContext(), headers);
        }
    }

    private Response debugDatasetDataInternal(Request request, String queryString, String moduleURL) throws Exception {
        DataSet dsMeta = this.getDatasetMetadata(moduleURL, true);
        if (dsMeta.getSignonErrorMessage() != null) {
            return Response.status((int)403).entity((Object)dsMeta.getSignonErrorMessage()).build();
        }
        return this.getResponse(RequestType.DAAS_V5_QUERYSET, request, dsMeta, queryString);
    }

    private DataSet getDatasetMetadata(String datasetId, boolean refreshmd) {
        return this.getDatasetMetadata(MetadataProviderFactory.ProviderType.DAAS, null, datasetId, refreshmd, null, LOGGER);
    }
}

