/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.endpoints;

import com.ibm.ba.gemini.commons.trace.Trace;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.data.queryspec.generated.FunctionSpec;
import com.ibm.bi.qs.rest.endpoints.BaseEndPoint;
import com.ibm.bi.qs.rest.response.RequestType;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="mosercommand", description="Send a moser-command to QueryService")
@Path(value="/mosercommand")
public class MoserCommandEndPoint
extends BaseEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoserCommandEndPoint.class);

    public MoserCommandEndPoint() {
        super(null);
    }

    @Trace(metricName="Run a moser function and returns response using GET", dispatcher=true)
    @GET
    @Path(value="/get")
    @Produces(value={"application/json"})
    @ApiOperation(value="Run a moser command using GET", response=FunctionSpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response moserCommandGet(@Context Request request, @ApiParam(value="Function String", required=true) @DefaultValue(value="{}") @QueryParam(value="functionSpec") String functionSpec) {
        try {
            LOGGER.debug("mosercommand: functionSpec=\"{}\"", (Object)functionSpec);
            return this.getResponseNoMetadataWithSpec(RequestType.MOSER_COMMAND, request, functionSpec);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    @Trace(metricName="Run a moser function and returns response using POST", dispatcher=true)
    @POST
    @Path(value="/post")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Run a moser command using POST", response=FunctionSpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response moserCommand(@Context Request request, @ApiParam(value="Function String", required=false) @DefaultValue(value="{}") String functionSpec) {
        try {
            LOGGER.debug("mosercommand: functionSpec=\"{}\"", (Object)functionSpec);
            return this.getResponseNoMetadataWithSpec(RequestType.MOSER_COMMAND, request, functionSpec);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }
}

