/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.endpoints;

import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.bibushandler.SOAPFaultResponseAdapter;
import com.cognos.xqebifw.cubingservices.V5QueryHandler;
import com.cognos.xqebifw.cubingservices.messaging.SOAPMultipartHttpResponse;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.ibm.ba.gemini.commons.trace.Trace;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.rest.endpoints.BaseEndPoint;
import com.ibm.bi.qs.rest.response.RequestType;
import com.ibm.bi.qs.rest.service.MetadataProviderFactory;
import com.ibm.bi.qs.utils.MultipartUtil;
import com.ibm.cognos.pogo.zipi.RequestAdapter;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.HttpServletRequestAdapter;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.wink.common.model.multipart.BufferedInMultiPart;
import org.apache.wink.common.model.multipart.InPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="dataset", description="Operations to a dataset")
@Path(value="/datasets")
public class QueryServiceEndPoint
extends BaseEndPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServiceEndPoint.class);
    private static final String DQ_NOT_INITIALIZED = "Dynamic Query layer is not initialized.";
    private static final String ENDPOINT_NAME = "QueryServiceEndPoint-";

    public QueryServiceEndPoint() {
        super(MetadataProviderFactory.ProviderType.BI);
    }

    @Path(value="soap")
    @POST
    @Consumes(value={"text/xml"})
    @Produces(value={"text/xml"})
    @ApiOperation(value="Execute SOAP requests from legacy components.", response=DataSet.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response executeSOAPRequest(InputStream requestBody) {
        ResponseAdapter response;
        ZipiBridge.clearCurrentContext();
        ZipiTimer zipiTimer = null;
        HttpServletRequestAdapter zipiRequestAdaptor = new HttpServletRequestAdapter(this.httpServletRequest);
        if (zipiRequestAdaptor.getId() != null) {
            zipiTimer = ZipiBridge.startTimer((RequestAdapter)zipiRequestAdaptor);
        }
        Response.Status status = this.isFaulted(response = this.executeSOAPCommand(requestBody)) ? Response.Status.INTERNAL_SERVER_ERROR : Response.Status.OK;
        SOAPEnvelope envelope = response.getSOAPResponse();
        Iterator attachments = response.getAttachmentIterator();
        final SOAPMultipartHttpResponse mpr = new SOAPMultipartHttpResponse(envelope, attachments);
        if (zipiTimer != null) {
            zipiTimer.stopAndClear();
        }
        return Response.status((Response.Status)status).type(mpr.getContentType()).entity((Object)new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                mpr.writeResponseBody(os);
            }
        }).build();
    }

    @Trace(metricName="Run a query and get data from a given URL", dispatcher=true)
    @POST
    @Path(value="{dataset_id}/data")
    @Produces(value={"application/json"})
    @ApiOperation(value="Run a query and get data using POST", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDatasetData(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="Query String") @DefaultValue(value="{}") BufferedInMultiPart inMP, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd, @QueryParam(value="qfb") @DefaultValue(value="none") String qfb, @QueryParam(value="qfbLevel") String qfbLevel, @QueryParam(value="qfbMode") @DefaultValue(value="execute") String qfbMode) {
        String queryString;
        StringBuilder msg = new StringBuilder();
        try {
            queryString = this.multiPartToString(inMP, this.getSpecName(RequestType.QUERY));
            boolean validated = this.validateQuerySpec(queryString, msg);
            if (!validated) {
                return Response.status((int)400).entity((Object)msg).build();
            }
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
        return this.processDataRequest("POST:getDatasetData", RequestType.QUERY, request, datasetId, queryString, refreshmd);
    }

    @Trace(metricName="Dataset-Service Status", dispatcher=true)
    @GET
    @Path(value="service-status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve dataset-service status.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success")})
    public Response handleServiceStatusRequest() {
        return this.processSimpleRequest("GET:handleServiceStatusRequest", RequestType.SERVICE_STATUS);
    }

    @Trace(metricName="Get Dataset Metadata", dispatcher=true)
    @GET
    @Path(value="{dataset_id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve dataset's metadata", response=DataSet.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Dataset not modified"), @ApiResponse(code=404, message="Dataset not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getDatasetMetadata(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @QueryParam(value="type") String typeForSwagger, @QueryParam(value="module") String moduleForSwagger, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processMetadataRequest("GET:getDatasetMetadata", RequestType.DATASET_METADATA, request, datasetId, refreshmd);
    }

    public boolean validateQuerySpec(String queryString, StringBuilder res) throws Exception {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (configuration == null || configuration.getBooleanProperty("queryPlanning.jsonQueryValidation.[@enabled]", false)) {
            ObjectMapper mapper = this.getPlainObjectMapper();
            JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
            JsonSchema querySpecSchema = factory.getJsonSchema("resource:/schema/queryspec/querySpec.json");
            JsonNode query = mapper.readTree(queryString);
            ProcessingReport report = querySpecSchema.validate(query);
            for (ProcessingMessage message : report) {
                if (!"error".equals(message.getLogLevel().toString())) continue;
                res.append("Problem with " + message.asJson().get("schema").get("pointer").toString() + ": " + message.getMessage());
                return false;
            }
        }
        return true;
    }

    @Trace(metricName="Query the given dataset", dispatcher=true)
    @GET
    @Path(value="{dataset_id}/data")
    @Produces(value={"application/json"})
    @ApiOperation(value="Query the given dataset", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getDatasetData(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="Query String") @DefaultValue(value="{}") @QueryParam(value="querySpec") String queryString, @QueryParam(value="type") String typeForSwagger, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd, @QueryParam(value="qfb") @DefaultValue(value="none") String qfb, @QueryParam(value="qfbLevel") String qfbLevel, @QueryParam(value="qfbMode") @DefaultValue(value="execute") String qfbMode) {
        StringBuilder msg = new StringBuilder();
        try {
            boolean validated = this.validateQuerySpec(queryString, msg);
            if (!validated) {
                return Response.status((int)400).entity((Object)msg).build();
            }
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
        return this.processDataRequest("GET:getDatasetData", RequestType.QUERY, request, datasetId, queryString, refreshmd);
    }

    @Trace(metricName="Debug the given dataset", dispatcher=true)
    @GET
    @Path(value="{dataset_id}/debug")
    @Produces(value={"application/xml", "application/json"})
    @ApiOperation(value="Debug the given dataset", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response debugDatasetData(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="Query String") @DefaultValue(value="{}") @QueryParam(value="querySpec") String queryString, @QueryParam(value="type") String typeForSwagger, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processDataRequest("GET:debugDatasetData", RequestType.V5_QUERYSET, request, datasetId, queryString, refreshmd);
    }

    @Trace(metricName="Execute a key driver request and get key drivers for a given target and inputs", dispatcher=true)
    @GET
    @Path(value="{dataset_id}/fastpatternkeydrivers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Execute a key driver request and get key drivers for a given target and inputs using GET", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getDatasetKeyDrivers(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="KeyDriver String", required=true) @DefaultValue(value="{}") @QueryParam(value="keyDriverSpec") String keyDriverString, @QueryParam(value="type") String typeForSwagger, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processDataRequest("GET:getDatasetKeyDrivers", RequestType.KEYDRIVER, request, datasetId, keyDriverString, refreshmd);
    }

    @Trace(metricName="Execute a key driver request and get key drivers for a given target and inputs", dispatcher=true)
    @POST
    @Path(value="{dataset_id}/fastpatternkeydrivers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Execute a key driver request and get key drivers for a given target and inputs using POST", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDatasetKeyDrivers(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="KeyDriver String") @DefaultValue(value="{}") BufferedInMultiPart inMP, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processDataRequest("POST:getDatasetKeyDrivers", RequestType.KEYDRIVER, request, datasetId, inMP, refreshmd);
    }

    @Trace(metricName="Execute a predict explore request and get results for a given target and inputs", dispatcher=true)
    @GET
    @Path(value="{dataset_id}/predictexplore")
    @Produces(value={"application/json"})
    @ApiOperation(value="Execute a predict explore request and get results for a given target and inputs using GET", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=304, message="Data not modified"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getDatasetPredictExplore(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="Explore String", required=true) @DefaultValue(value="{}") @QueryParam(value="exploreSpec") String exploreString, @QueryParam(value="type") String typeForSwagger, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processDataRequest("GET:getDatasetPredictExplore", RequestType.PREDICT_EXPLORE, request, datasetId, exploreString, refreshmd);
    }

    @Trace(metricName="Execute a predict explore request and get results for a given target and inputs", dispatcher=true)
    @POST
    @Path(value="{dataset_id}/predictexplore")
    @Produces(value={"application/json"})
    @ApiOperation(value="Execute a predict explore request and get results for a given target and inputs using POST", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDatasetPredictExplore(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="Explore String") @DefaultValue(value="{}") BufferedInMultiPart inMP, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processDataRequest("POST:getDatasetPredictExplore", RequestType.PREDICT_EXPLORE, request, datasetId, inMP, refreshmd);
    }

    @Trace(metricName="Execute a statistics request", dispatcher=true)
    @GET
    @Path(value="{dataset_id}/stats")
    @Produces(value={"application/json"})
    @ApiOperation(value="Execute a statistics request using GET", response=OrderedJSONObject.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getDatasetStats(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="Stats String", required=true) @DefaultValue(value="{}") @QueryParam(value="statsSpec") String statsString, @QueryParam(value="type") String typeForSwagger, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processDataRequest("GET:getDatasetStats", RequestType.STATS, request, datasetId, statsString, refreshmd);
    }

    @Trace(metricName="Execute a statistics request", dispatcher=true)
    @POST
    @Path(value="{dataset_id}/stats")
    @Produces(value={"application/json"})
    @ApiOperation(value="Execute a statistics request using POST", response=OrderedJSONObject.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Data not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDatasetStats(@Context Request request, @ApiParam(value="Dataset Id", required=true) @PathParam(value="dataset_id") String datasetId, @ApiParam(value="Stats String") @DefaultValue(value="{}") BufferedInMultiPart inMP, @QueryParam(value="refreshmd") @DefaultValue(value="false") boolean refreshmd) {
        return this.processDataRequest("POST:getDatasetStats", RequestType.STATS, request, datasetId, inMP, refreshmd);
    }

    @Trace(metricName="Create a querycontext", dispatcher=true)
    @POST
    @Path(value="querycontext")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a querycontext", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=500, message="Internal error")})
    public Response createQueryContext(@Context Request request) {
        return this.processQueryContextRequest("createQueryContext", RequestType.CREATE_QUERYCONTEXT, request, null, null);
    }

    @Trace(metricName="Get the querycontext requests", dispatcher=true)
    @GET
    @Path(value="querycontext/{querycontext_id}/requests")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the querycontext requests", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="QueryContext not found"), @ApiResponse(code=500, message="Internal error")})
    public Response getQueryContextRequests(@Context Request request, @ApiParam(value="QueryContext Id", required=true) @PathParam(value="querycontext_id") String queryContextId) {
        return this.processQueryContextRequest("getQueryContextRequests", RequestType.GET_QUERYCONTEXTREQUESTS, request, queryContextId, null);
    }

    @Trace(metricName="Delete a querycontext", dispatcher=true)
    @DELETE
    @Path(value="querycontext/{querycontext_id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the given querycontext", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Success"), @ApiResponse(code=404, message="Querycontext not found"), @ApiResponse(code=500, message="Internal error")})
    public Response deleteQueryContext(@Context Request request, @ApiParam(value="QueryContext Id", required=true) @PathParam(value="querycontext_id") String queryContextId) {
        return this.processQueryContextRequest("deleteQueryContext", RequestType.DELETE_QUERYCONTEXT, request, queryContextId, null);
    }

    @Trace(metricName="Cancel one or more requests", dispatcher=true)
    @DELETE
    @Path(value="querycontext/{querycontext_id}/requests")
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancel one or more requests", response=QuerySpec.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="QueryContext not found"), @ApiResponse(code=500, message="Internal error")})
    public Response cancelRequests(@Context Request request, @ApiParam(value="QueryContext Id", required=true) @PathParam(value="querycontext_id") String queryContextId, @ApiParam(value="Request Ids", required=true, allowMultiple=true) @QueryParam(value="requestIds") List<String> requestIds) {
        return this.processQueryContextRequest("cancelRequests", RequestType.CANCEL_REQUEST, request, queryContextId, requestIds);
    }

    private ResponseAdapter executeSOAPCommand(InputStream requestBody) {
        ResponseAdapter response;
        try {
            V5QueryHandler v5QueryHandler = V5QueryHandler.getInstance();
            response = v5QueryHandler.execute(requestBody, this.httpServletRequest);
        }
        catch (XQERuntimeException e) {
            LOGGER.error(DQ_NOT_INITIALIZED);
            response = this.createSoapFault(DQ_NOT_INITIALIZED, e);
        }
        return response;
    }

    private ResponseAdapter createSoapFault(String faultString, Throwable t) {
        Fault fault = new Fault(faultString);
        fault.setDetailMessasge(faultString + "\r\n" + t.toString());
        return new SOAPFaultResponseAdapter(fault, false);
    }

    private boolean isFaulted(ResponseAdapter response) {
        String faultString;
        boolean isFaulted = false;
        SOAPEnvelope se = response.getSOAPResponse();
        if (se != null && StringUtils.isNotEmpty((String)(faultString = se.getFaultString()))) {
            LOGGER.debug("Error: {} - {}", (Object)se.getFaultCode(), (Object)faultString);
            isFaulted = true;
        }
        return isFaulted;
    }

    protected Response processSimpleRequest(String methodName, RequestType requestType) {
        try {
            LOGGER.debug(ENDPOINT_NAME + methodName);
            return this.getResponseNoMetadata(requestType);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private Response processMetadataRequest(String methodName, RequestType requestType, Request request, String datasetId, boolean refreshmd) {
        try {
            LOGGER.debug(ENDPOINT_NAME + methodName + ": datasetId=\"" + datasetId + "\"");
            DataSet dsMeta = this.getDatasetMetadata(requestType, datasetId, refreshmd, null);
            if (dsMeta.getSignonErrorMessage() != null) {
                return Response.status((int)403).entity((Object)dsMeta.getSignonErrorMessage()).build();
            }
            return this.getResponse(requestType, request, dsMeta);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private Response processDataRequest(String methodName, RequestType requestType, Request request, String datasetId, BufferedInMultiPart inMP, boolean refreshmd) {
        String specString;
        try {
            specString = this.multiPartToString(inMP, this.getSpecName(requestType));
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
        return this.processDataRequest(methodName, requestType, request, datasetId, specString, refreshmd);
    }

    private Response processDataRequest(String methodName, RequestType requestType, Request request, String datasetId, String specString, boolean refreshmd) {
        try {
            LOGGER.debug(ENDPOINT_NAME + methodName + ": " + this.getSpecName(requestType) + "=\"" + specString + "\"datasetId=\"" + datasetId + "\"");
            DataSet dsMeta = this.getDatasetMetadata(requestType, datasetId, refreshmd, specString);
            if (dsMeta.getSignonErrorMessage() != null) {
                return Response.status((int)403).entity((Object)dsMeta.getSignonErrorMessage()).build();
            }
            return this.getResponse(requestType, request, dsMeta, specString);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private Response processQueryContextRequest(String methodName, RequestType requestType, Request request, String queryContextId, List<String> requestIds) {
        try {
            if (LOGGER.isDebugEnabled()) {
                int numberOfArgs = 2;
                if (queryContextId != null) {
                    ++numberOfArgs;
                }
                if (requestIds != null) {
                    ++numberOfArgs;
                }
                switch (numberOfArgs) {
                    case 2: {
                        LOGGER.debug("{}{}", (Object)ENDPOINT_NAME, (Object)methodName);
                        break;
                    }
                    case 3: {
                        LOGGER.debug("{}{}: queryContextId={}", new Object[]{ENDPOINT_NAME, methodName, queryContextId});
                        break;
                    }
                    case 4: {
                        LOGGER.debug("{}{}: queryContextId={}, requestIds={}", new Object[]{ENDPOINT_NAME, methodName, queryContextId, requestIds});
                        break;
                    }
                }
            }
            return this.getResponseNoMetadata(requestType, request, queryContextId, requestIds);
        }
        catch (Throwable e) {
            QueryServiceException dssError = QueryServiceException.wrap((Throwable)e);
            return dssError.buildResponse(this.getServletRequestContext());
        }
    }

    private String getSpecName(RequestType requestType) {
        switch (requestType) {
            case KEYDRIVER: {
                return "keyDriverSpec";
            }
            case PREDICT_EXPLORE: {
                return "exploreSpec";
            }
            case QUERY: 
            case V5_QUERYSET: {
                return "querySpec";
            }
            case STATS: {
                return "statsSpec";
            }
        }
        throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Unsupported request type: " + requestType.name());
    }

    private String multiPartToString(BufferedInMultiPart inMP, String partName) throws IOException {
        List parts = inMP.getParts();
        for (InPart part : parts) {
            String name = MultipartUtil.getPartName(part);
            if (name == null || !name.equals(partName)) continue;
            return (String)part.getBody(String.class, null);
        }
        return null;
    }

    private DataSet getDatasetMetadata(RequestType requestType, String datasetId, boolean refreshmd, String specString) {
        return this.getDatasetMetadata(MetadataProviderFactory.ProviderType.BI, requestType, datasetId, refreshmd, specString, LOGGER);
    }
}

