/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.health;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metrics.MetricsManager;
import com.ibm.bi.qs.common.QueryServiceLogger;
import com.ibm.bi.qs.rest.service.ServiceState;
import com.ibm.bi.qs.rest.service.State;
import com.ibm.json.java.OrderedJSONObject;
import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.IntStream;
import javax.servlet.ServletContext;

@Async(period=60L, scheduleType=Async.ScheduleType.FIXED_DELAY, initialState=Async.InitialState.HEALTHY)
public class QueryServiceHealthCheck
extends HealthCheck {
    private static final String STATUS_STR = "status";
    private static final int CRITICAL_FAILURES_INDEX = 0;
    private static final int TOTAL_REQUESTS_INDEX = 2;
    public static final String[] COUNTER_NAMES = new String[]{"NumberOfCriticalFailures", "NumberOfSuccessfulRequests", "NumberOfReceivedRequests"};
    public static final boolean DEFAULT_ENABLED = true;
    public static final double DEFAULT_MIN_SUCCESS_RATE_THRES = 0.6;
    public static final int DEFAULT_MIN_RECEIVED_REQUESTS = 50;
    public static final double DEFAULT_MIN_SUCCESS_RATE_PER_MINUTE_THRES = 0.2;
    public static final int DEFAULT_MAX_CONSECUTIVE_FAILURES_FOR_SUCCESS_RATE_PER_MINUTE_THRES = 5;
    private final ServletContext context;
    private Long[] previousMetrics = new Long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
    private BitSet consecutiveFailures;
    private int consecutiveTrials;
    private final StringBuilder sb = new StringBuilder();

    public QueryServiceHealthCheck(ServletContext ctx) {
        this.context = ctx;
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.ResultBuilder result = HealthCheck.Result.builder();
        result.withDetail("service", (Object)this.context.getContextPath().substring(1));
        if (State.RUNNING.equals((Object)ServiceState.getInstance().getStatus())) {
            result.withDetail(STATUS_STR, (Object)State.RUNNING.getValue());
            Long[] metrics = this.getMetrics();
            OrderedJSONObject metricsJsonObj = new OrderedJSONObject();
            IntStream.range(0, metrics.length).forEach(i -> metricsJsonObj.put((Object)COUNTER_NAMES[i], (Object)metrics[i]));
            result.withDetail("metrics", (Object)metricsJsonObj);
            if (this.isQueryServiceHealthy(metrics, result)) {
                return result.healthy().build();
            }
            return result.unhealthy().build();
        }
        if (State.INIT.equals((Object)ServiceState.getInstance().getStatus())) {
            result.withDetail(STATUS_STR, (Object)State.INIT.getValue());
            return result.withMessage("Initializating.").unhealthy().build();
        }
        result.withDetail(STATUS_STR, (Object)State.SHUTDOWN.getValue());
        return result.withMessage("Shutting down.").unhealthy().build();
    }

    boolean isQueryServiceHealthy(Long[] currentMetrics, HealthCheck.ResultBuilder result) {
        this.sb.setLength(0);
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean isFeatureEnabled = configuration.getBooleanProperty("health[@enabled]", true);
        if (!isFeatureEnabled) {
            result.withMessage("HealthCheck Feature disabled. ");
            return true;
        }
        double minSuccessRateThreshold = this.getMinSuccessRateThreshold(configuration);
        int minReceivedRequestsThreshold = this.getMinOverallRequestsThreshold(configuration);
        double minSuccessRateMinuteThreshold = this.getMinSuccessRateMinuteThreshold(configuration);
        int maxConsecutiveTimes = this.getMaxConsecutiveTimesThreshold(configuration);
        this.reconstructConsecutiveFailuresBitSet(maxConsecutiveTimes);
        this.populateLastFailureInBitSet(this.passesSuccessfulRequestsThresholdLastMinute(currentMetrics[0] - this.previousMetrics[0], currentMetrics[2] - this.previousMetrics[2], minSuccessRateMinuteThreshold));
        boolean outcome = this.failsConsecutiveFailures() && this.passesSuccessfulRequestsThreshold(currentMetrics[0], currentMetrics[2], minReceivedRequestsThreshold, minSuccessRateThreshold);
        this.previousMetrics = currentMetrics;
        result.withMessage(this.sb.toString());
        return outcome;
    }

    double getMinSuccessRateThreshold(XQEConfiguration config) {
        double result;
        try {
            result = config.getDoubleProperty("health.minSuccessRate[@value]", 0.6);
            if (result < 0.0 || result > 1.0) {
                QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid 'minSuccessRate' config value detected: '%s'. Resetting it to: '%s'.", result, 0.6));
                result = 0.6;
            } else {
                QueryServiceLogger.info((Object)((Object)this), (String)String.format("'minSuccessRate' config value set to: '%s'.", result));
            }
        }
        catch (Exception e) {
            QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid non-numeric 'minSuccessRate' config value detected. Resetting it to: '%s'.", 0.6));
            result = 0.6;
        }
        return result;
    }

    int getMinOverallRequestsThreshold(XQEConfiguration config) {
        int result;
        try {
            String value = config.getPropertyValue("health.minOverallRequests[@value]", (Object)50).toString();
            result = Integer.parseInt(value);
            if (result <= 0) {
                QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid 'minOverallRequests' config value detected: '%s'. Resetting it to: '%s'.", result, 50));
                result = 50;
            } else {
                QueryServiceLogger.info((Object)((Object)this), (String)String.format("'minOverallRequests' config value set to: '%s'.", result));
            }
        }
        catch (Exception e) {
            QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid non-integer 'minOverallRequests' config value detected. Resetting it to: '%s'.", 50));
            result = 50;
        }
        return result;
    }

    double getMinSuccessRateMinuteThreshold(XQEConfiguration config) {
        double result;
        try {
            result = config.getDoubleProperty("health.minSuccessRateMinute[@value]", 0.2);
            if (result < 0.0 || result > 1.0) {
                QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid 'minSuccessRateMinute' config value detected: '%s'. Resetting it to: '%s'.", result, 0.2));
                result = 0.2;
            } else {
                QueryServiceLogger.info((Object)((Object)this), (String)String.format("'minSuccessRateMinute' config value set to: '%s'.", result));
            }
        }
        catch (Exception e) {
            QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid non-numeric 'minSuccessRateMinute' config value detected. Resetting it to: '%s'.", 0.2));
            result = 0.2;
        }
        return result;
    }

    int getMaxConsecutiveTimesThreshold(XQEConfiguration config) {
        int result;
        try {
            String value = config.getPropertyValue("health.maxConsecutiveTimesSuccessRateMinuteFailures[@value]", (Object)5).toString();
            result = Integer.parseInt(value);
            if (result <= 0) {
                QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid 'maxConsecutiveTimesSuccessRateMinuteFailures' config value detected: '%s'. Resetting it to: '%s'.", result, 5));
                result = 5;
            } else {
                QueryServiceLogger.info((Object)((Object)this), (String)String.format("'maxConsecutiveTimesSuccessRateMinuteFailures' config value set to: '%s'.", result));
            }
        }
        catch (Exception e) {
            QueryServiceLogger.warn((Object)((Object)this), (String)String.format("Invalid non-integer 'maxConsecutiveTimesSuccessRateMinuteFailures' config value detected. Resetting it to: '%s'.", 5));
            result = 5;
        }
        return result;
    }

    boolean passesSuccessfulRequestsThresholdLastMinute(long criticalFailuresDiff, long totalRequestsDiff, double successRateMinuteThreshold) {
        if (totalRequestsDiff <= 0L) {
            this.sb.append("Requests received last minute: 0 ");
            return true;
        }
        if (1.0 - (double)criticalFailuresDiff * 1.0 / (double)totalRequestsDiff >= successRateMinuteThreshold) {
            this.sb.append("Successful requests per minute ratio met. ");
            return true;
        }
        this.sb.append("Successful requests per minute ratio not met. ");
        return false;
    }

    boolean passesSuccessfulRequestsThreshold(long criticalFailures, long totalRequests, int requestsThreshold, double successRateThreshold) {
        if (totalRequests >= (long)requestsThreshold) {
            if (1.0 - (double)criticalFailures * 1.0 / (double)totalRequests >= successRateThreshold) {
                this.sb.append("Successful requests ratio met. ");
                return true;
            }
            this.sb.append("Successful requests ratio not met. ");
            return false;
        }
        this.sb.append("Min Received requests threshold not met. ");
        return true;
    }

    void reconstructConsecutiveFailuresBitSet(int nBits) {
        if (null == this.consecutiveFailures) {
            this.consecutiveFailures = new BitSet(nBits);
            this.consecutiveFailures.clear();
            this.consecutiveTrials = nBits;
        } else if (this.consecutiveTrials < nBits) {
            BitSet result = new BitSet(nBits);
            int diff = nBits - this.consecutiveTrials;
            for (int i = 0; i < this.consecutiveTrials; ++i) {
                result.set(i + diff, this.consecutiveFailures.get(i));
            }
            this.consecutiveFailures = result;
            this.consecutiveTrials = nBits;
        } else if (this.consecutiveTrials > nBits) {
            BitSet result = new BitSet(nBits);
            result.or(this.consecutiveFailures.get(this.consecutiveTrials - nBits, this.consecutiveTrials));
            this.consecutiveFailures = result;
            this.consecutiveTrials = nBits;
        }
    }

    void populateLastFailureInBitSet(boolean success) {
        BitSet leftShiftedBitset = this.consecutiveFailures.get(1, this.consecutiveTrials);
        this.consecutiveFailures = new BitSet(this.consecutiveTrials);
        this.consecutiveFailures.or(leftShiftedBitset);
        this.consecutiveFailures.set(this.consecutiveTrials - 1, !success);
    }

    boolean failsConsecutiveFailures() {
        if (this.consecutiveFailures.cardinality() == this.consecutiveTrials) {
            this.sb.append(String.format("Successful requests per minute ratio not met for %s consecutive times. ", this.consecutiveTrials));
            return false;
        }
        return true;
    }

    Long[] getMetrics() {
        Object[] values = MetricsManager.getSnapshot((String[])COUNTER_NAMES);
        return (Long[])Arrays.copyOf(values, values.length, Long[].class);
    }

    void setConsecutiveFailuresBitSet(BitSet aBitSet, int nBits) {
        this.consecutiveFailures = aBitSet;
        this.consecutiveTrials = nBits;
    }

    BitSet getConsecutiveFailures() {
        return this.consecutiveFailures;
    }

    int getConsecutiveTrials() {
        return this.consecutiveTrials;
    }
}

