/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.service.IQSExecutor;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.qs.utils.EtagUtils;
import com.ibm.bi.rs.GETEntityBuilder;
import java.io.Closeable;
import java.util.Date;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import org.apache.commons.json.OrderedJSONObject;

public abstract class AbstractResultBuilder
implements GETEntityBuilder,
Closeable {
    protected final QueryService datasetService;
    protected final ServletRequestContext servletRequestContext;
    protected final ModelFactory modelFactory;
    protected IQSExecutor executor;

    protected AbstractResultBuilder(QueryService datasetService, ServletRequestContext servletRequestContext, ModelFactory modelFactory) {
        this.datasetService = datasetService;
        this.servletRequestContext = servletRequestContext;
        this.modelFactory = modelFactory;
    }

    public Date getLastModifiedFromResource() throws Exception {
        assert (null != this.executor);
        return this.executor.getLastModified();
    }

    public CacheControl getCacheControl() {
        return null;
    }

    public Object build() throws Exception {
        assert (null != this.executor);
        try {
            OrderedJSONObject orderedJSONObject = this.datasetService.executeJSONResult(this.executor);
            return orderedJSONObject;
        }
        finally {
            this.executor.close();
        }
    }

    @Override
    public void close() {
        if (this.executor != null) {
            this.executor.close();
        }
    }

    public EntityTag getEtagFromResource() throws Exception {
        Date lastModified = this.getLastModifiedFromResource();
        if (lastModified == null) {
            return null;
        }
        return EntityTag.valueOf((String)EtagUtils.createRequestEtag(this.executor.getDataSet(), lastModified));
    }

    public IQSExecutor getExecutor() {
        return this.executor;
    }
}

