/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.cognos.xqebifw.management.XqeCacheOperations;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.rest.response.RequestType;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class AdminResponseBuilder
extends Response.ResponseBuilder {
    private static final String ASTERISK = "*";
    private final RequestType requestType;
    private final List<String> filterIds;

    public AdminResponseBuilder(RequestType requestType, List<String> filterIds) {
        this.requestType = requestType;
        this.filterIds = filterIds;
    }

    public Response build() {
        String dumpFilePath = null;
        switch (this.requestType) {
            case DUMP_CACHE: {
                if (this.filterIds == null) {
                    dumpFilePath = XqeCacheOperations.dump((String)ASTERISK, (String)ASTERISK, (String)ASTERISK);
                    break;
                }
                if (this.filterIds.size() != 3) {
                    throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Dump cache requires 3 parameters");
                }
                dumpFilePath = XqeCacheOperations.dump((String)this.filterIds.get(0), (String)this.filterIds.get(1), (String)this.filterIds.get(2));
                break;
            }
            case DUMP_DMR_CACHE: {
                if (this.filterIds == null) {
                    dumpFilePath = XqeCacheOperations.dumpDMRCache();
                    break;
                }
                if (this.filterIds.size() != 2) {
                    throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Dump DMR cache requires 2 parameters");
                }
                dumpFilePath = XqeCacheOperations.dumpDMRCache((String)this.filterIds.get(0), (String)this.filterIds.get(1));
                break;
            }
            case FLUSH_CACHE: {
                if (this.filterIds == null) {
                    XqeCacheOperations.flush((String)ASTERISK, (String)ASTERISK, (String)ASTERISK);
                    break;
                }
                if (this.filterIds.size() != 3) {
                    throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Flush cache requires 3 parameters");
                }
                XqeCacheOperations.flush((String)this.filterIds.get(0), (String)this.filterIds.get(1), (String)this.filterIds.get(2));
                break;
            }
            case FLUSH_DMR_CACHE: {
                if (this.filterIds == null) {
                    XqeCacheOperations.flushDMRCache();
                    break;
                }
                if (this.filterIds.size() != 2) {
                    throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, "Flush DMR cache requires 2 parameters");
                }
                XqeCacheOperations.flushDMRCache((String)this.filterIds.get(0), (String)this.filterIds.get(1));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (dumpFilePath == null) {
            return Response.noContent().build();
        }
        JSONObject queryContextJson = new JSONObject();
        try {
            queryContextJson.put("dumpFilePath", (Object)dumpFilePath);
        }
        catch (JSONException e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.INTERNAL_ERROR, "Unable to construct Admin response");
        }
        return Response.ok((Object)queryContextJson).type("application/json").build();
    }

    public Response.ResponseBuilder clone() {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder status(int status) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder entity(Object entity) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder type(MediaType type) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder type(String type) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder variant(Variant variant) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder language(String language) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder language(Locale language) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder location(URI location) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder tag(String tag) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder expires(Date expires) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder header(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder allow(String ... methods) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder allow(Set<String> methods) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder encoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder variants(Variant ... variants) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder links(Link ... links) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder link(URI uri, String rel) {
        throw new UnsupportedOperationException();
    }

    public Response.ResponseBuilder link(String uri, String rel) {
        throw new UnsupportedOperationException();
    }
}

