/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.predict.generated.KeyDriverSpec;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.rest.response.AbstractResultBuilder;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.Charsets;

class KeyDriverResultBuilder
extends AbstractResultBuilder {
    KeyDriverResultBuilder(ModelFactory modelFactory, DataSet dsMeta, String keyDriverString, QueryService datasetService, ServletRequestContext servletRequestContext) {
        super(datasetService, servletRequestContext, modelFactory);
        KeyDriverSpec keyDriverSpec = this.parseKeyDriver(keyDriverString);
        this.executor = datasetService.createKeyDriverExecutor(keyDriverSpec, dsMeta, servletRequestContext);
    }

    private KeyDriverSpec parseKeyDriver(String keyDriverString) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(keyDriverString.getBytes(Charsets.UTF_8));
            return (KeyDriverSpec)this.modelFactory.create((InputStream)is, KeyDriverSpec.class);
        }
        catch (IOException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.INTERNAL_ERROR, "Invalid keydriver spec");
        }
    }
}

