/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.data.queryspec.generated.FunctionSpec;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.rest.response.AbstractResultBuilder;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.Charsets;

public class MoserCommandResultBuilder
extends AbstractResultBuilder {
    public MoserCommandResultBuilder(ModelFactory modelFactory, String functionSpec, QueryService queryService, ServletRequestContext servletRequestContext) {
        super(queryService, servletRequestContext, modelFactory);
        FunctionSpec parsedSpec = this.parseFunctionSpecs(functionSpec);
        this.executor = this.datasetService.createFunctionExecutor(parsedSpec, servletRequestContext);
    }

    @Override
    public Object build() throws TimeoutException {
        assert (null != this.executor);
        try {
            String string = this.datasetService.executeStringResult(this.executor);
            return string;
        }
        finally {
            this.executor.close();
        }
    }

    private FunctionSpec parseFunctionSpecs(String functionSpec) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(functionSpec.getBytes(Charsets.UTF_8));
            return (FunctionSpec)this.modelFactory.create((InputStream)is, FunctionSpec.class);
        }
        catch (IOException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.INTERNAL_ERROR, "Invalid query");
        }
    }
}

