/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.predict.generated.ExploreSpec;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.rest.response.AbstractResultBuilder;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.Charsets;

class PredictExploreResultBuilder
extends AbstractResultBuilder {
    PredictExploreResultBuilder(ModelFactory modelFactory, DataSet dsMeta, String exploreString, QueryService datasetService, ServletRequestContext servletRequestContext) {
        super(datasetService, servletRequestContext, modelFactory);
        ExploreSpec exploreSpec = this.parseExploreSpec(exploreString);
        this.executor = datasetService.createPredictExploreExecutor(exploreSpec, dsMeta, servletRequestContext);
    }

    private ExploreSpec parseExploreSpec(String exploreString) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(exploreString.getBytes(Charsets.UTF_8));
            return (ExploreSpec)this.modelFactory.create((InputStream)is, ExploreSpec.class);
        }
        catch (IOException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.INTERNAL_ERROR, "Invalid explore spec");
        }
    }
}

