/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.data.queryspec.generated.QuerySpec;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.rest.response.AbstractResultBuilder;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.Charsets;

class QueryResultBuilder
extends AbstractResultBuilder {
    QueryResultBuilder(ModelFactory modelFactory, DataSet dsMeta, String queryString, QueryService datasetService, ServletRequestContext servletRequestContext) {
        super(datasetService, servletRequestContext, modelFactory);
        QuerySpec query = this.parseQuery(queryString);
        this.executor = datasetService.createQueryExecutor(query, dsMeta, servletRequestContext);
    }

    private QuerySpec parseQuery(String queryString) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(queryString.getBytes(Charsets.UTF_8));
            return (QuerySpec)this.modelFactory.create((InputStream)is, QuerySpec.class);
        }
        catch (IOException e) {
            throw new QueryServiceException((Throwable)e, 400, QueryServiceMessageKeys.INTERNAL_ERROR, "Invalid query");
        }
    }
}

