/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.rest.response.VisibleColumnsTransformer;
import com.ibm.bi.rs.GETEntityBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

class QueryServiceEntityBuilder
implements GETEntityBuilder {
    private static final String[] PUBLIC_PROPS = new String[]{"name", "description", "lastUpdated", "columnMetadata", "filters", "refreshRate", "readonly"};
    private static final JSONArray EMPTY_ARRAY = new JSONArray(0);
    private final DataSet dsMeta;
    private final ModelFactory modelFactory;
    private final Boolean returnModule;

    QueryServiceEntityBuilder(ModelFactory modelFactory, DataSet dsMeta, Boolean returnModule) {
        this.dsMeta = dsMeta;
        this.modelFactory = modelFactory;
        this.returnModule = returnModule;
    }

    public Date getLastModifiedFromResource() {
        return this.dsMeta.getLastUpdated();
    }

    public EntityTag getEtagFromResource() {
        return EntityTag.valueOf((String)this.dsMeta.getEtag());
    }

    public CacheControl getCacheControl() {
        return null;
    }

    public Object build() {
        if (this.returnModule.booleanValue()) {
            return this.dsMeta.getModule();
        }
        try {
            JSONObject jsonDsMeta = this.modelFactory.create((Object)this.dsMeta);
            JSONObject simpleDsMeta = this.filterDatasetProps(jsonDsMeta);
            this.filterColumns(simpleDsMeta);
            return simpleDsMeta;
        }
        catch (IOException | JSONException e) {
            throw new QueryServiceException(e, QueryServiceMessageKeys.REST_INTERNAL_ERROR);
        }
    }

    private JSONObject filterDatasetProps(JSONObject jsonDsMeta) throws JSONException {
        JSONObject simpleDsMeta = new JSONObject();
        for (String prop : PUBLIC_PROPS) {
            if (!jsonDsMeta.containsKey((Object)prop)) continue;
            simpleDsMeta.put(prop, jsonDsMeta.get(prop));
        }
        return simpleDsMeta;
    }

    private void filterColumns(JSONObject simpleDsMeta) throws JSONException {
        JSONArray srcColumns = simpleDsMeta.optJSONArray("columnMetadata", EMPTY_ARRAY);
        List filteredColumns = (List)CollectionUtils.collect((Collection)srcColumns, (Transformer)VisibleColumnsTransformer.INSTANCE, new ArrayList(srcColumns.size()));
        filteredColumns.removeAll(Collections.singleton(null));
        simpleDsMeta.put("columnMetadata", (Collection)filteredColumns);
    }
}

