/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.response;

import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.marshal.ModelFactory;
import com.ibm.bi.qs.rest.response.AbstractResultBuilder;
import com.ibm.bi.qs.rest.response.AdminResponseBuilder;
import com.ibm.bi.qs.rest.response.CancelRequestEntityBuilder;
import com.ibm.bi.qs.rest.response.CreateQueryContextEntityBuilder;
import com.ibm.bi.qs.rest.response.DeleteQueryContextResponseBuilder;
import com.ibm.bi.qs.rest.response.KeyDriverResultBuilder;
import com.ibm.bi.qs.rest.response.MoserCommandResultBuilder;
import com.ibm.bi.qs.rest.response.PredictExploreResultBuilder;
import com.ibm.bi.qs.rest.response.QueryContextRequestsEntityBuilder;
import com.ibm.bi.qs.rest.response.QueryResultBuilder;
import com.ibm.bi.qs.rest.response.QueryServiceEntityBuilder;
import com.ibm.bi.qs.rest.response.RequestType;
import com.ibm.bi.qs.rest.response.StatsResultBuilder;
import com.ibm.bi.qs.rest.response.StatusEntityBuilder;
import com.ibm.bi.qs.rest.response.V5QuerySetBuilder;
import com.ibm.bi.qs.service.QueryService;
import com.ibm.bi.qs.service.ServletRequestContext;
import com.ibm.bi.rs.GETEntityBuilder;
import com.ibm.bi.rs.POSTEntityBuilder;
import com.ibm.bi.rs.ResponseBuilderFactory;
import java.util.List;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

public class ServiceResponseBuilderFactory {
    private static final String X_MODEL_LAST_MODIFIED = "x-model-last-modified";
    private static final String X_QUERYUSERID = "x-queryuserid";
    private static final String VARY_VALUE1 = "x-queryuserid, x-model-last-modified";
    private ModelFactory modelFactory;
    private QueryService datasetService;
    private CacheControl cc;

    public ServiceResponseBuilderFactory(ModelFactory modelFactory, QueryService datasetService) {
        this.modelFactory = modelFactory;
        this.datasetService = datasetService;
        this.cc = new CacheControl();
        this.cc.setMustRevalidate(true);
    }

    public Response.ResponseBuilder createSimpleResponseBuilder(RequestType builderType) throws Exception {
        switch (builderType) {
            case SERVICE_STATUS: {
                return ResponseBuilderFactory.createGET(null, null, null, (CacheControl)this.cc, (GETEntityBuilder)new StatusEntityBuilder());
            }
        }
        throw new QueryServiceException(500, QueryServiceMessageKeys.INTERNAL_ERROR, "Unsupported RequestType: " + builderType.name());
    }

    public Response.ResponseBuilder createResponseBuilder(RequestType builderType, Request request, String resourceId, ServletRequestContext servletRequestContext) throws Exception {
        return this.createResponseBuilder(builderType, request, resourceId, null, servletRequestContext);
    }

    public Response.ResponseBuilder createResponseBuilder(RequestType builderType, Request request, String resourceId, List<String> filterIds, ServletRequestContext servletRequestContext) throws Exception {
        switch (builderType) {
            case CANCEL_REQUEST: {
                return ResponseBuilderFactory.createGET(null, null, null, null, (GETEntityBuilder)new CancelRequestEntityBuilder(resourceId, filterIds, this.datasetService, servletRequestContext));
            }
            case CREATE_QUERYCONTEXT: {
                return ResponseBuilderFactory.createPOST(null, null, (POSTEntityBuilder)new CreateQueryContextEntityBuilder(this.datasetService, servletRequestContext));
            }
            case DELETE_QUERYCONTEXT: {
                return new DeleteQueryContextResponseBuilder(resourceId, this.datasetService, servletRequestContext);
            }
            case DUMP_CACHE: 
            case DUMP_DMR_CACHE: 
            case FLUSH_CACHE: 
            case FLUSH_DMR_CACHE: {
                return new AdminResponseBuilder(builderType, filterIds);
            }
            case GET_QUERYCONTEXTREQUESTS: {
                return ResponseBuilderFactory.createGET(null, null, null, (CacheControl)this.cc, (GETEntityBuilder)new QueryContextRequestsEntityBuilder(resourceId, this.datasetService, servletRequestContext));
            }
        }
        throw new QueryServiceException(500, QueryServiceMessageKeys.INTERNAL_ERROR, "Unsupported RequestType: " + builderType.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response.ResponseBuilder createResponseBuilder(RequestType builderType, Request request, DataSet dsMeta, String specString, ServletRequestContext servletRequestContext) throws Exception {
        if (builderType == RequestType.DATASET_METADATA) {
            return this.createDatasetMeta(request, dsMeta, servletRequestContext);
        }
        AbstractResultBuilder resultBuilder = this.createResultBuilder(builderType, dsMeta, specString, servletRequestContext);
        Response.ResponseBuilder responseBuilder = null;
        try {
            responseBuilder = ResponseBuilderFactory.createGET((Request)request, null, null, (CacheControl)this.cc, (GETEntityBuilder)resultBuilder);
            if (RequestType.V5_QUERYSET == builderType || RequestType.DAAS_V5_QUERYSET == builderType) {
                responseBuilder = resultBuilder.getExecutor().convertsXMLToJSON() ? responseBuilder.header("Content-Type", (Object)"application/json") : responseBuilder.header("Content-Type", (Object)"application/xml");
            }
            Response.ResponseBuilder responseBuilder2 = responseBuilder = this.setCacheControlAndVary(servletRequestContext, resultBuilder, responseBuilder);
            return responseBuilder2;
        }
        finally {
            if (responseBuilder == null) {
                resultBuilder.close();
            }
        }
    }

    private Response.ResponseBuilder setCacheControlAndVary(ServletRequestContext servletRequestContext, AbstractResultBuilder resultBuilder, Response.ResponseBuilder responseBuilder) {
        long aDataCacheExpiry;
        String aXmodulelastmodified;
        boolean applies = false;
        String aXqueryuserid = servletRequestContext.getHttpServletRequest().getHeader(X_QUERYUSERID);
        if (aXqueryuserid != null && !aXqueryuserid.isEmpty() && (aXmodulelastmodified = servletRequestContext.getHttpServletRequest().getHeader(X_MODEL_LAST_MODIFIED)) != null && !aXmodulelastmodified.isEmpty() && (aDataCacheExpiry = resultBuilder.getExecutor().getDataCacheExpiry()) > 0L) {
            applies = true;
            this.cc.setMaxAge((int)aDataCacheExpiry);
            this.cc.setMustRevalidate(false);
            this.cc.setNoTransform(false);
            this.cc.setPrivate(true);
            responseBuilder = responseBuilder.header("Vary", (Object)VARY_VALUE1);
        }
        if (!applies) {
            this.cc.setMaxAge(-1);
            this.cc.setMustRevalidate(true);
            this.cc.setNoTransform(true);
        }
        return responseBuilder;
    }

    private AbstractResultBuilder createResultBuilder(RequestType builderType, DataSet dsMeta, String specString, ServletRequestContext servletRequestContext) {
        AbstractResultBuilder resultBuilder = null;
        switch (builderType) {
            case KEYDRIVER: {
                resultBuilder = new KeyDriverResultBuilder(this.modelFactory, dsMeta, specString, this.datasetService, servletRequestContext);
                break;
            }
            case MOSER_COMMAND: {
                resultBuilder = new MoserCommandResultBuilder(this.modelFactory, specString, this.datasetService, servletRequestContext);
                break;
            }
            case PREDICT_EXPLORE: {
                resultBuilder = new PredictExploreResultBuilder(this.modelFactory, dsMeta, specString, this.datasetService, servletRequestContext);
                break;
            }
            case QUERY: 
            case DAAS_QUERY: {
                resultBuilder = new QueryResultBuilder(this.modelFactory, dsMeta, specString, this.datasetService, servletRequestContext);
                break;
            }
            case STATS: {
                resultBuilder = new StatsResultBuilder(this.modelFactory, dsMeta, specString, this.datasetService, servletRequestContext);
                break;
            }
            case V5_QUERYSET: 
            case DAAS_V5_QUERYSET: {
                resultBuilder = new V5QuerySetBuilder(this.modelFactory, dsMeta, specString, this.datasetService, servletRequestContext);
                break;
            }
            default: {
                throw new QueryServiceException(500, QueryServiceMessageKeys.INTERNAL_ERROR, "Unsupported RequestType: " + builderType.name());
            }
        }
        return resultBuilder;
    }

    public Response.ResponseBuilder createDatasetMeta(Request request, DataSet dsMeta, ServletRequestContext servletRequestContext) throws Exception {
        Boolean returnModule = Boolean.FALSE;
        if (servletRequestContext.getHttpServletRequest() != null) {
            String module = servletRequestContext.getHttpServletRequest().getParameter("module");
            returnModule = Boolean.TRUE.toString().equals(module);
        }
        Response.ResponseBuilder rb = ResponseBuilderFactory.createGET((Request)request, null, null, (CacheControl)this.cc, (GETEntityBuilder)new QueryServiceEntityBuilder(this.modelFactory, dsMeta, returnModule));
        String routingKeyword = dsMeta.getRoutingKeyword();
        if (routingKeyword != null && routingKeyword.length() > 0) {
            rb.header("X-CA-Routing", (Object)routingKeyword);
        }
        return rb;
    }
}

