/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.service;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.rest.service.MetadataCacheManager;
import com.ibm.bi.qs.rest.service.MoserMetadata;
import com.ibm.bi.qs.service.DataSetMetadataProvider;
import com.ibm.bi.qs.utils.BIDatasetHttpClient;
import com.ibm.bi.qs.utils.BIToExpnMetadataConverter;
import com.ibm.bi.qs.utils.Pair;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;

public class BIDataSetMetadataProvider
implements DataSetMetadataProvider,
Serializable {
    private static final long serialVersionUID = 707449149495555334L;
    private static final String MODULE_METADATA_ENDPOINT_POSTFIX = "/metadata";
    private static final String QUERY_SERVICE_PREFIX = "/bi/v1";
    private static final String BASEMODULE_METADATA_ENDPOINT_PREFIX = "/metadata/base_modules/";
    private static final String MODULE_METADATA_ENDPOINT_PREFIX = "/metadata/modules/";
    protected static final String SHORT_ID_EXPRESSION_PARAM = "?shortIdForExpression=true";
    private static final String TYPE = "&type=";
    private static final String ITEM = "&item=on";
    private static final String QUERYSUBJECT = "querySubject";
    private static final String QUERYITEM = "queryItem";
    private static final String FORMAT = "format";
    private static final String CONNECTION_SPEC = "&connectionSpec=";
    private static final String SPEC_VERSION = "2";
    private static final String OBJECTS_SEARCH_PATH_RELATIVE_URL = "/objects/%s?fields=searchPath&schemaInfo=false";
    @Context
    protected transient HttpServletRequest servletRequest;
    private transient BIDatasetHttpClient httpClient;

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void setHttpClient(BIDatasetHttpClient client) {
        this.httpClient = client;
    }

    public BIDatasetHttpClient getHttpClient(HttpServletRequest servletRequest) {
        return new BIDatasetHttpClient(servletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet get(String datasetID, String contentLocale, boolean refresh, String connectionSpec, List<String> metadataSubsetIDs, String specVersion) {
        DataSetType dsType = null;
        if (null != this.servletRequest) {
            dsType = DataSetType.fromValue((String)this.servletRequest.getParameter("type"));
        }
        MetadataCacheManager cacheManager = MetadataCacheManager.getMetadataCacheManager();
        Pair urlAndUser = this.getUrlUserPair(datasetID, contentLocale, connectionSpec, metadataSubsetIDs, dsType);
        String searchPathURL = this.getSearchPathURL(datasetID);
        ReentrantLock lock = cacheManager.lockUser(urlAndUser);
        try {
            DataSet dataSet = null;
            if (!refresh && !SPEC_VERSION.equals(specVersion)) {
                dataSet = (DataSet)cacheManager.getDataSetCache().getIfPresent((Object)urlAndUser);
            }
            if (dataSet == null) {
                dataSet = this.getDatasetMetadata(urlAndUser, datasetID, contentLocale, refresh, specVersion, dsType, searchPathURL);
                if (dataSet.getSignonErrorMessage() != null) {
                    DataSet dataSet2 = dataSet;
                    return dataSet2;
                }
                if (!SPEC_VERSION.equals(specVersion)) {
                    cacheManager.getDataSetCache().put((Object)urlAndUser, (Object)dataSet);
                }
            }
            DataSet dataSet3 = dataSet;
            return dataSet3;
        }
        finally {
            lock.unlock();
        }
    }

    protected Pair getUrlUserPair(String datasetID, String contentLocale, String connectionSpec, List<String> metadataSubsetIDs, DataSetType dsType) {
        String url = this.getMetadataRequestURL(datasetID, dsType.toString(), connectionSpec, metadataSubsetIDs);
        return new Pair(url, this.getPassportID() + contentLocale);
    }

    protected String getPassportID() {
        Object[] cookies;
        if (this.servletRequest != null && ArrayUtils.isNotEmpty((Object[])(cookies = this.servletRequest.getCookies()))) {
            for (Object cookie : cookies) {
                if (!"cam_passport".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    DataSet getDatasetMetadata(Pair urlAndUser, String datasetID, String contentLocale, boolean refresh, String specVersion, DataSetType dsType, String searchPathURL) {
        try {
            BIDatasetHttpClient client = this.httpClient == null ? this.getHttpClient(this.servletRequest) : this.httpClient;
            String url = (String)urlAndUser.getFirst();
            MoserMetadata cachedMoserMetadata = null;
            Pair cachedSearchPath = null;
            if (!refresh && !SPEC_VERSION.equals(specVersion)) {
                cachedMoserMetadata = (MoserMetadata)MetadataCacheManager.getMetadataCacheManager().getMoserMetadataCache().getIfPresent((Object)urlAndUser);
            }
            if (SPEC_VERSION.equals(specVersion) && DataSetType.PACKAGE.equals((Object)dsType)) {
                cachedSearchPath = MetadataCacheManager.getMetadataCacheManager().getModuleId2SearchPathCache().get(datasetID);
            }
            if (SPEC_VERSION.equals(specVersion)) {
                DataSet dataSet = new DataSet();
                if (DataSetType.PACKAGE.equals((Object)dsType)) {
                    Pair actualSearchPath = client.getSearchPathForModuleId(searchPathURL, cachedSearchPath, datasetID);
                    MetadataCacheManager.getMetadataCacheManager().getModuleId2SearchPathCache().put(datasetID, actualSearchPath);
                    dataSet.setModuleConnectionPath(actualSearchPath.getFirst().toString());
                } else {
                    dataSet.setModuleConnectionPath(datasetID);
                }
                dataSet.setContentLocale(contentLocale);
                dataSet.setType(dsType);
                return dataSet;
            }
            MoserMetadata metadata = client.getMoserMetadataFromUrl(url, cachedMoserMetadata, datasetID);
            if (metadata.getSignonErrorMessage() != null) {
                DataSet dataSet = new DataSet();
                dataSet.setSignonErrorMessage(metadata.getSignonErrorMessage());
                return dataSet;
            }
            if (Boolean.TRUE.equals(metadata.isInitialized())) {
                return metadata.getDataSet();
            }
            JsonObject module = metadata.getModule();
            DataSet dataSet = BIToExpnMetadataConverter.getInstance().getDashboardMetadata(module.toString(), dsType, datasetID);
            dataSet.setETag(metadata.getETag());
            dataSet.setRoutingKeyword(metadata.getRoutingKeyword());
            dataSet.setModule(this.buildJSONModule(module));
            dataSet.setContentLocale(contentLocale);
            metadata.setDataSet(dataSet);
            metadata.setInitialized();
            MetadataCacheManager.getMetadataCacheManager().getMoserMetadataCache().put((Object)urlAndUser, (Object)metadata);
            return dataSet;
        }
        catch (QueryServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.INTERNAL_ERROR, datasetID);
        }
    }

    private JSONObject buildJSONModule(JsonObject moduleFromMoser) {
        try {
            JSONObject module = new JSONObject(moduleFromMoser.toString());
            module = BIDataSetMetadataProvider.transformXMLFormatToJSON(module);
            return module;
        }
        catch (JSONException e) {
            throw new QueryServiceException((Throwable)e, QueryServiceMessageKeys.REST_INTERNAL_ERROR);
        }
    }

    public static JSONObject transformXMLFormatToJSON(JSONObject module) throws JSONException {
        if (!module.containsKey((Object)QUERYSUBJECT)) {
            return module;
        }
        JSONArray querySubjects = module.getJSONArray(QUERYSUBJECT);
        for (int i = 0; i < querySubjects.size(); ++i) {
            ArrayList<JSONObject> queryItems = new ArrayList<JSONObject>();
            BIDataSetMetadataProvider.findFormatQueryItems(querySubjects.getJSONObject(i), queryItems);
            for (int j = 0; j < queryItems.size(); ++j) {
                JSONObject queryItem = (JSONObject)queryItems.get(j);
                String xmlFormat = (String)queryItem.get(FORMAT);
                String jsonFormat = BIToExpnMetadataConverter.getJSONFormatFromXML(xmlFormat);
                queryItem.remove((Object)FORMAT);
                queryItem.put(FORMAT, (Object)jsonFormat);
            }
        }
        return module;
    }

    private static void findFormatQueryItems(JSONObject object, List<JSONObject> queryItems) throws JSONException {
        Iterator it = object.keys();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = object.get(key);
            if (value instanceof JSONObject) {
                JSONObject jsonValue = (JSONObject)value;
                if (key.equals(QUERYITEM) && jsonValue.containsKey((Object)FORMAT)) {
                    queryItems.add(object.getJSONObject((String)key));
                }
                BIDataSetMetadataProvider.findFormatQueryItems(jsonValue, queryItems);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            for (int j = 0; j < ((JSONArray)value).size(); ++j) {
                Object arrayValue = ((JSONArray)value).get(j);
                if (!(arrayValue instanceof JSONObject)) continue;
                BIDataSetMetadataProvider.findFormatQueryItems((JSONObject)arrayValue, queryItems);
            }
        }
    }

    public String getMetadataRequestURL(String datasetID, String datasetType, String connectionSpec, List<String> metadataSubsetIDs) {
        String servicePrefix = QUERY_SERVICE_PREFIX;
        if (System.getProperties().containsKey("SERVICE_PREFIX")) {
            servicePrefix = (String)System.getProperties().get("SERVICE_PREFIX");
        }
        String endpointPrefix = "module".equals(datasetType) || "social_media".equals(datasetType) ? MODULE_METADATA_ENDPOINT_PREFIX : BASEMODULE_METADATA_ENDPOINT_PREFIX;
        return servicePrefix + endpointPrefix + datasetID + MODULE_METADATA_ENDPOINT_POSTFIX + SHORT_ID_EXPRESSION_PARAM + ITEM + TYPE + datasetType + this.composeConnectionSpecURL(connectionSpec) + this.composeRequiredMetadataURL(metadataSubsetIDs);
    }

    private String composeConnectionSpecURL(String connectionSpec) {
        try {
            return connectionSpec != null ? CONNECTION_SPEC + URLEncoder.encode(connectionSpec, "UTF-8") : "";
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private String composeRequiredMetadataURL(List<String> requiredMetadata) {
        if (requiredMetadata == null || requiredMetadata.isEmpty()) {
            return "";
        }
        StringBuilder mdURL = new StringBuilder();
        for (String mdItem : requiredMetadata) {
            mdURL.append("&i=");
            try {
                mdURL.append(URLEncoder.encode(mdItem, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return mdURL.toString();
    }

    public String getSearchPathURL(String datasetID) {
        String servicePrefix = QUERY_SERVICE_PREFIX;
        if (System.getProperties().containsKey("SERVICE_PREFIX")) {
            servicePrefix = (String)System.getProperties().get("SERVICE_PREFIX");
        }
        return servicePrefix + String.format(OBJECTS_SEARCH_PATH_RELATIVE_URL, datasetID);
    }

    public void injectServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }
}

