/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.qs.rest.service.JaxbAnnotationInspector;

public class JSONCodec {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public String encode(Object o) throws MoserException {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    public Object decode(Class<?> c, String json) throws MoserException {
        try {
            return MAPPER.readValue(json, c);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    public static String writeValueAsString(Object o) throws MoserException {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationInspector(MAPPER.getTypeFactory()));
    }
}

