/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.rest.service.MoserMetadata;
import com.ibm.bi.qs.utils.Pair;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.map.LRUMap;

public class MetadataCacheManager {
    private static final long MAX_SIZE = 500L;
    private static final long MAX_MINUTES_IN_MOSER_METADATA_CACHE = 10L;
    private static final long MAX_SECONDS_IN_DATASET_CACHE = 3L;
    private Cache<Pair, ReentrantLock> cachePool;
    private Cache<Pair, MoserMetadata> moserMetadataCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private Cache<Pair, DataSet> dataSetCache;
    private Map<String, Pair> moduleId2SearchPathCache;
    private static MetadataCacheManager cacheManager;

    public MetadataCacheManager() {
        this.cachePool = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        this.dataSetCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(3L, TimeUnit.SECONDS).build();
        this.moduleId2SearchPathCache = Collections.synchronizedMap(new LRUMap(100));
    }

    public static synchronized MetadataCacheManager getMetadataCacheManager() {
        if (cacheManager == null) {
            cacheManager = new MetadataCacheManager();
        }
        return cacheManager;
    }

    public Cache<Pair, MoserMetadata> getMoserMetadataCache() {
        return this.moserMetadataCache;
    }

    public void setMoserMetadataCache(Cache<Pair, MoserMetadata> moserMetadataCache) {
        this.moserMetadataCache = moserMetadataCache;
    }

    public Cache<Pair, DataSet> getDataSetCache() {
        return this.dataSetCache;
    }

    public void setDataSetCache(Cache<Pair, DataSet> dataSetCache) {
        this.dataSetCache = dataSetCache;
    }

    public Map<String, Pair> getModuleId2SearchPathCache() {
        return this.moduleId2SearchPathCache;
    }

    public ReentrantLock lockUser(Pair urlAndUser) {
        ReentrantLock lock = this.cachePool.asMap().computeIfAbsent(urlAndUser, k -> new ReentrantLock());
        lock.lock();
        return lock;
    }
}

