/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.service;

import com.ibm.bi.qs.rest.service.ExitCode;
import com.ibm.bi.qs.rest.service.ServiceState;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

public class ServiceOperations {
    private static final int WAIT_TILL_EXTERNALL_SHUTDOWN = 60;
    private static final String JAVA_EXE = System.getProperty("java.home") + new StringJoiner(File.separator, File.separator, "").add("bin").add("java").toString();
    private static final String JAR_OPTION = "-jar";
    private static final String WS_SERVER_OPTION = System.getProperty("COG_ROOT") + new StringJoiner(File.separator, File.separator, "").add("wlp").add("bin").add("tools").add("ws-server.jar").toString();
    private static final String DSS_NAME = "dataset-service";
    private static final String ACTION = "--stop";
    private static final List<String> ARGS_FOR_STOP_ACTION = new ArrayList<String>();

    private ServiceOperations() {
    }

    public static void init() {
    }

    public static void stopCurrentDatasetService(ExitCode exitCode) {
        boolean systemExit;
        boolean bl = systemExit = exitCode == ExitCode.OUT_OF_MEMORY || exitCode == ExitCode.CRITICAL;
        if (exitCode == ExitCode.ORPHAN) {
            try {
                boolean err;
                ProcessBuilder processBuilder = new ProcessBuilder(ARGS_FOR_STOP_ACTION);
                Process ps = processBuilder.start();
                boolean bl2 = err = !ps.waitFor(60L, TimeUnit.SECONDS);
                if (err || ps.isAlive()) {
                    systemExit = true;
                }
            }
            catch (Throwable e) {
                systemExit = true;
                ServiceState.logException(e);
            }
        }
        try {
            ServiceState.logResource(exitCode.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (systemExit) {
            System.exit(exitCode.getCode());
        }
    }

    static {
        String javaExe = JAVA_EXE;
        String osName = System.getProperty("os.name");
        if (osName == null || osName.indexOf("indows") != -1) {
            javaExe = javaExe + ".exe";
        }
        ARGS_FOR_STOP_ACTION.addAll(Arrays.asList(javaExe, JAR_OPTION, WS_SERVER_OPTION, DSS_NAME, ACTION));
    }
}

