/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.rest.service;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqebifw.cubingservices.DQServer;
import com.ibm.bi.qs.rest.service.ExitCode;
import com.ibm.bi.qs.rest.service.ServiceOperations;
import com.ibm.bi.qs.rest.service.State;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;

public final class ServiceState {
    private static final SingletonHelper<ServiceState> SINGLETON_HELPER = new SingletonHelper<ServiceState>(){

        protected ServiceState newInstance() {
            return new ServiceState();
        }

        protected void initializeImpl(ServiceState theInstance) {
            theInstance.initialize();
        }

        protected void releaseImpl(ServiceState theInstance) {
            theInstance.terminate();
        }
    };
    public static final String PROP_CUBESERVER_DATA = "cubingservices_data";
    public static final String XQE_RUNNING_INDICATOR_FILENAME = ".xqe_running.";
    public static final String XQE_STAMP_FILENAME = ".xqe.";
    private volatile State status = null;
    private long pid = -1L;
    private long parentProcessID = -1L;
    private File xqeStampFile = null;
    private File xqeRunningIndicatorFile = null;
    private boolean pingErrorLogged = false;
    private String installDir;
    private XQELogger exceptionLogger = null;
    private XQELogger resourceLogger = null;

    public static ServiceState getInstance() {
        return (ServiceState)SINGLETON_HELPER.getInstance();
    }

    public static ServiceState getInstanceNoInit() {
        return (ServiceState)SINGLETON_HELPER.getInstance(true);
    }

    public static void releaseInstance() {
        SINGLETON_HELPER.releaseInstance();
    }

    ServiceState() {
    }

    private void terminate() {
    }

    private void initialize() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        this.pid = Long.parseLong(processName.split("@")[0]);
        this.status = State.INIT;
        this.parentProcessID = ServiceState.getParentProcessID();
        this.xqeStampFile = this.createStampFile();
        this.xqeRunningIndicatorFile = this.initRunningIndicatorFile();
        this.installDir = System.getProperty("COG_ROOT");
        this.exceptionLogger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQE, (String)"XQE", (String)"Exception", (LogLevel)LogLevel.ERROR);
        this.resourceLogger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQE, (String)"XQE", (String)"Resources", (LogLevel)LogLevel.ERROR);
        ServiceOperations.init();
    }

    public XQELogger getExceptionLogger() {
        return this.exceptionLogger;
    }

    public XQELogger getResourceLogger() {
        return this.resourceLogger;
    }

    public long getPid() {
        return this.pid;
    }

    public long getParentPid() {
        return this.parentProcessID;
    }

    public State getStatus() {
        return this.status;
    }

    public void setStatus(State aStatus) {
        this.status = aStatus;
    }

    public String getInstallDir() {
        return this.installDir;
    }

    public File getXqeStampFile() {
        return this.xqeStampFile;
    }

    public boolean isPingErrorLogged() {
        return this.pingErrorLogged;
    }

    public void setPingErrorLogged(boolean value) {
        this.pingErrorLogged = value;
    }

    private static int getParentProcessID() {
        String parentProcessIDString = System.getProperty("ParentProcessID");
        int processID = -1;
        if (parentProcessIDString != null) {
            processID = Integer.valueOf(parentProcessIDString);
        }
        return processID;
    }

    private File createStampFile() {
        String dataDir = System.getProperty(PROP_CUBESERVER_DATA);
        ServiceState.removeStampFiles(dataDir);
        String xqeStampFilename = dataDir + File.separator + XQE_STAMP_FILENAME + String.valueOf(this.pid);
        File timestampFile = new File(xqeStampFilename);
        try {
            timestampFile.createNewFile();
            timestampFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Can not create xqe stamp file: " + xqeStampFilename);
        }
        return timestampFile;
    }

    private static void removeStampFiles(String xqeStampDirectoryName) {
        File xqeStampDirectory = new File(xqeStampDirectoryName);
        File[] xqeFilestamps = xqeStampDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(ServiceState.XQE_STAMP_FILENAME);
            }
        });
        if (xqeFilestamps == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid or inaccessible directory: " + xqeStampDirectoryName);
        }
        for (File xqeFilestamp : xqeFilestamps) {
            xqeFilestamp.delete();
        }
    }

    private File initRunningIndicatorFile() {
        String dataDir = System.getProperty(PROP_CUBESERVER_DATA);
        File xqeRunningIndicatorDirectory = new File(dataDir);
        File[] xqeRunningIndicators = xqeRunningIndicatorDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(ServiceState.XQE_RUNNING_INDICATOR_FILENAME);
            }
        });
        if (xqeRunningIndicators == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid or inaccessible directory: " + dataDir);
        }
        for (File xqeRunningIndicator : xqeRunningIndicators) {
            DQServer.setRecoveringFromCrash((boolean)true);
            xqeRunningIndicator.delete();
        }
        String xqeRunningIndicatorFilename = dataDir + File.separator + XQE_RUNNING_INDICATOR_FILENAME + String.valueOf(this.pid);
        File runningIndicatorFile = new File(xqeRunningIndicatorFilename);
        try {
            runningIndicatorFile.createNewFile();
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Can not create xqe running indicator file: " + xqeRunningIndicatorFilename);
        }
        return runningIndicatorFile;
    }

    public void goToShutdownState(ExitCode exitCode) {
        if (this.status == State.SHUTDOWN) {
            return;
        }
        this.status = State.SHUTDOWN;
        try {
            if (this.xqeStampFile != null) {
                this.xqeStampFile.delete();
            }
            this.xqeStampFile = null;
            if (exitCode == ExitCode.NORMAL) {
                if (this.xqeRunningIndicatorFile != null) {
                    this.xqeRunningIndicatorFile.delete();
                }
                this.xqeRunningIndicatorFile = null;
            }
        }
        catch (Throwable t) {
            ServiceState.logException(t);
        }
        ServiceOperations.stopCurrentDatasetService(exitCode);
    }

    public static void logException(Throwable t) {
        try {
            ServiceState.getInstance().getExceptionLogger().log(t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logResource(String message) {
        try {
            ServiceState.getInstance().getResourceLogger().log(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

