/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.utils;

import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.qs.common.QueryServiceMessageKeys;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.rest.service.MoserMetadata;
import com.ibm.bi.qs.utils.Pair;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class BIDatasetHttpClient {
    public static final String CA_ROUTING = "X-CA-Routing";
    private HttpServletRequest request;

    public BIDatasetHttpClient(HttpServletRequest request) {
        this.request = request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MoserMetadata getMoserMetadataFromUrl(String url, MoserMetadata cachedMetadata, String datasetID) {
        MoserMetadata metadata = null;
        try (RESTClient client = RESTClientFactory.getInstance().getClient(this.request);){
            if (cachedMetadata != null) {
                client.setRequestHeader("If-None-Match", cachedMetadata.getETag());
            } else {
                client.setRequestHeader("If-None-Match", null);
            }
            int statusCode = client.getResource(url);
            if (statusCode == 304) {
                MoserMetadata moserMetadata = cachedMetadata;
                return moserMetadata;
            }
            if (200 == statusCode) {
                String eTag = client.getResponseHeader("ETag");
                String routingKeyword = client.getResponseHeader(CA_ROUTING);
                JsonObject result = client.getResponseAsJsonObject();
                metadata = new MoserMetadata(result, eTag, routingKeyword);
                return metadata;
            }
            if (403 == statusCode) {
                metadata = new MoserMetadata(null, null, null);
                metadata.setSignonErrorMessage(client.getErrorResponseString());
                return metadata;
            }
            if (404 == statusCode) {
                throw new QueryServiceException(404, QueryServiceMessageKeys.REST_RESOURCE_NOT_FOUND, "data set", datasetID);
            }
            if (statusCode < 400) return metadata;
            throw new RuntimeException(String.format("[%d] %s", statusCode, client.getErrorResponseString()));
        }
        catch (IOException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair getSearchPathForModuleId(String url, Pair cachedSearchPath, String datasetID) {
        Pair searchPath = null;
        try (RESTClient client = RESTClientFactory.getInstance().getClient(this.request);){
            if (cachedSearchPath != null) {
                client.setRequestHeader("If-None-Match", cachedSearchPath.getSecond().toString());
            } else {
                client.setRequestHeader("If-None-Match", null);
            }
            int statusCode = client.getResource(url);
            if (statusCode == 304) {
                Pair pair = cachedSearchPath;
                return pair;
            }
            if (200 == statusCode) {
                String eTag = client.getResponseHeader("ETag");
                JsonObject result = client.getResponseAsJsonObject();
                JsonArray data = result.getArray("data");
                if (null == data || data.isEmpty()) {
                    throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, String.format("Malformed CM response extracting 'data' array for data set with id: '%s'", datasetID));
                }
                Object searchPathValue = ((JsonObject)data.get(0)).get("searchPath");
                if (null == searchPathValue) {
                    throw new QueryServiceException(QueryServiceMessageKeys.INTERNAL_ERROR, String.format("Malformed CM response extracting 'searchPath' value for data set with id: '%s'", datasetID));
                }
                searchPath = new Pair(searchPathValue.toString(), eTag);
                return searchPath;
            }
            if (403 == statusCode) {
                throw new QueryServiceException(403, QueryServiceMessageKeys.REST_RESOURCE_FORBIDDEN, "data set from CM", datasetID);
            }
            if (404 == statusCode) {
                throw new QueryServiceException(404, QueryServiceMessageKeys.REST_RESOURCE_NOT_FOUND, "data set", datasetID);
            }
            if (statusCode < 400) return searchPath;
            throw new RuntimeException(String.format("[%d] %s", statusCode, client.getErrorResponseString()));
        }
        catch (IOException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
    }
}

