/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.utils;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.DefLinkType;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetTypeEnabled;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.LocalRefType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.SortListType;
import com.ibm.bi.platform.moser.common.generated.metadata.SortOrderNullPlacement;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.qs.common.exceptions.QueryServiceException;
import com.ibm.bi.qs.model.api.AggregateType;
import com.ibm.bi.qs.model.api.ColumnMetadata;
import com.ibm.bi.qs.model.api.DataSet;
import com.ibm.bi.qs.model.api.DataSetType;
import com.ibm.bi.qs.model.api.FieldOrdering;
import com.ibm.bi.qs.model.api.Meta;
import com.ibm.bi.qs.model.api.NullPlacement;
import com.ibm.bi.qs.model.api.SortOrder;
import com.ibm.bi.qs.rest.service.JSONCodec;
import com.ibm.bi.qs.utils.Adapter;
import com.ibm.bi.qs.utils.XMLToJSON;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class BIToExpnMetadataConverter
implements Adapter {
    private static final String DOT = ".";
    private static final String OPEN_SQUARE_BRACKET = "[";
    private static volatile BIToExpnMetadataConverter instance;

    private BIToExpnMetadataConverter() {
    }

    public static synchronized BIToExpnMetadataConverter getInstance() {
        if (instance == null) {
            instance = new BIToExpnMetadataConverter();
        }
        return instance;
    }

    public DataSet getDashboardMetadata(String c10Metadata, DataSetType dsType, String moduleId) {
        try {
            JSONCodec codec = new JSONCodec();
            Module module = (Module)codec.decode(Module.class, c10Metadata);
            DataSet dataSet = new DataSet();
            String identifier = module.getIdentifier();
            dataSet.setDescription(module.getDescription() == null ? "" : module.getDescription());
            dataSet.setName(module.getLabel());
            dataSet.setTable(BIToExpnMetadataConverter.getTableName(module));
            dataSet.setConnectionPath(module.getFmModel());
            dataSet.setContainer(module.getContainer() == null ? "null" : module.getContainer());
            dataSet.setType(dsType);
            if (dsType.equals((Object)DataSetType.PACKAGE)) {
                dataSet.setModuleConnectionPath((String)module.getUse().get(0));
            } else {
                dataSet.setModuleConnectionPath(moduleId);
            }
            dataSet.setContainsPackage(this.checkContainsPackage(module, dsType));
            BIToExpnMetadataConverter.setMeta(dataSet, identifier);
            BIToExpnMetadataConverter.setColumnMetadataFromMDTV(dataSet, module, dsType.toString(), Boolean.FALSE);
            if (dataSet.getColumnMetadata().isEmpty()) {
                BIToExpnMetadataConverter.setModuleColumnMetadata(dataSet, module, dsType.toString(), Boolean.FALSE);
            }
            return dataSet;
        }
        catch (MoserException e) {
            throw QueryServiceException.wrap((Throwable)e);
        }
    }

    private boolean checkContainsPackage(Module module, DataSetType type) {
        boolean containsPackage = false;
        if (type.equals((Object)DataSetType.PACKAGE)) {
            containsPackage = true;
        } else if (type.equals((Object)DataSetType.MODULE)) {
            List useSpecs = module.getUseSpec();
            Iterator it = useSpecs.iterator();
            while (it.hasNext()) {
                if (!((Module.UseSpec)it.next()).getType().equals((Object)"package")) continue;
                containsPackage = true;
                break;
            }
        }
        return containsPackage;
    }

    private static String getTableName(Module module) {
        List list;
        if (module != null && (list = module.getQuerySubject()) != null && !list.isEmpty()) {
            return ((QuerySubject)list.get(0)).getIdentifier();
        }
        return null;
    }

    private static void setColumnMetadataFromMDTV(DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        ArrayList<ColumnMetadata> metadataList = new ArrayList<ColumnMetadata>();
        List mdtv = module.getMetadataTreeView();
        for (FolderType folderType : mdtv) {
            BIToExpnMetadataConverter.setMetadataFromFolderType(null, folderType, metadataList, dataSet, module, datasetType, hidden);
        }
        dataSet.setColumnMetadata(metadataList);
    }

    private static void setMetadataFromFolderType(String ancestorFolderTypeId, FolderType folderType, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        String folderTypeId;
        if (folderType.isHidden() != null && folderType.isHidden().booleanValue()) {
            hidden = Boolean.TRUE;
        }
        if ((folderTypeId = folderType.getIdentifier()) == null) {
            folderTypeId = ancestorFolderTypeId;
        }
        List folderItemTypes = folderType.getFolderItem();
        for (FolderItemType folderItemType : folderItemTypes) {
            DefLinkType defLinkType;
            FolderType nestedFolder;
            String ref = folderItemType.getRef();
            if (ref != null) {
                BIToExpnMetadataConverter.setMetadataFromMDTVReference(null, ref, metadataList, dataSet, module, datasetType, hidden);
            }
            if ((nestedFolder = folderItemType.getFolder()) != null) {
                BIToExpnMetadataConverter.setMetadataFromFolderType(folderTypeId, nestedFolder, metadataList, dataSet, module, datasetType, hidden);
            }
            if ((defLinkType = folderItemType.getDefLink()) == null) continue;
            String idToPrepend = null;
            if (defLinkType.getIdentifier() != null) {
                idToPrepend = defLinkType.getIdentifier();
                if (folderTypeId != null) {
                    idToPrepend = folderTypeId + DOT + idToPrepend;
                }
            }
            BIToExpnMetadataConverter.setMetadataFromMDTVReference(idToPrepend, defLinkType.getRef(), metadataList, dataSet, module, datasetType, hidden);
        }
    }

    private static void setMetadataFromMDTVReference(String idToPrepend, String ref, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        List querySubectList = module.getQuerySubject();
        for (Object querySubject : querySubectList) {
            if (!querySubject.getIdentifier().equals(ref)) continue;
            BIToExpnMetadataConverter.setQuerySubjectMetadata((QuerySubject)querySubject, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
            return;
        }
        List calculations = module.getCalculation();
        for (Calculation calc : calculations) {
            if (!calc.getIdentifier().equals(ref)) continue;
            BIToExpnMetadataConverter.setCalculationMetadata(calc, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
            return;
        }
        List namedSets = module.getNamedSet();
        for (NamedSet namedSet : namedSets) {
            if (!namedSet.getIdentifier().equals(ref)) continue;
            String alias = BIToExpnMetadataConverter.extractAlias(idToPrepend);
            if (alias != null) {
                namedSet.setRefToHierarchy(alias + DOT + namedSet.getRefToHierarchy());
            }
            BIToExpnMetadataConverter.setNamedSetMetadata(namedSet, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
            return;
        }
    }

    private static void setQuerySubjectMetadata(QuerySubject querySubject, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        List queryItemTypeList = querySubject.getItem();
        for (ItemType queryItemType : queryItemTypeList) {
            ItemHierarchy itemHierarchy;
            ItemType.Folder folder;
            QueryItem queryItem = queryItemType.getQueryItem();
            if (queryItem != null) {
                BIToExpnMetadataConverter.setQueryItemColumnMetadata(querySubject, null, queryItem, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
            }
            if ((folder = queryItemType.getFolder()) != null) {
                BIToExpnMetadataConverter.setFolderMetadata(querySubject, folder, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
            }
            if ((itemHierarchy = queryItemType.getItemHierarchy()) == null) continue;
            BIToExpnMetadataConverter.setItemHierarchyMetadata(querySubject, null, itemHierarchy, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
        }
        BIToExpnMetadataConverter.setColumnMetadata(querySubject, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
    }

    private static void setFolderMetadata(QuerySubject querySubject, ItemType.Folder folder, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        List queryItemTypeList = folder.getItem();
        for (ItemType queryItemType : queryItemTypeList) {
            ItemType.Folder nestedFolder;
            QueryItem queryItem = queryItemType.getQueryItem();
            if (queryItem != null) {
                BIToExpnMetadataConverter.setQueryItemColumnMetadata(querySubject, null, queryItem, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
            }
            if ((nestedFolder = queryItemType.getFolder()) == null) continue;
            BIToExpnMetadataConverter.setFolderMetadata(querySubject, nestedFolder, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
        }
    }

    private static void setCalculationMetadata(Calculation calc, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        ColumnMetadata.Type type = BIToExpnMetadataConverter.getColumnType(calc.getUsage());
        ColumnMetadata metadata = new ColumnMetadata();
        metadata.setCategory(null);
        metadata.setDataType(BIToExpnMetadataConverter.getColumnMetadataType(calc.getDatatype(), ColumnMetadata.Type.FACT.equals((Object)type)));
        metadata.setXQEDataType(BIToExpnMetadataConverter.getXQEDataType(calc.getDatatype()));
        metadata.setColumnName(calc.getIdentifier());
        ColumnMetadata.SourceCategory sourceCategory = null;
        if (calc.getSourceCategory() != null) {
            sourceCategory = ColumnMetadata.SourceCategory.fromValue((String)calc.getSourceCategory().toString());
        }
        if (sourceCategory == null) {
            sourceCategory = ColumnMetadata.SourceCategory.CALCULATION;
        }
        metadata.setSourceCategory(sourceCategory);
        metadata.setLabel(calc.getLabel());
        if (idToPrepend != null) {
            metadata.setColumnId(idToPrepend);
        } else {
            metadata.setColumnId(calc.getIdForExpression());
        }
        metadata.setType(type);
        metadata.setDefaultSort(BIToExpnMetadataConverter.getDefaultSorting(calc.getIdentifier(), calc.getFacetDefinition()));
        metadata.setQuerySubjectID(null);
        metadata.setQuerySubjectLabel(null);
        metadata.setCalculation(Boolean.TRUE);
        if (hidden.booleanValue() || calc.isHidden() != null && calc.isHidden().booleanValue()) {
            metadata.setHidden(Boolean.TRUE);
        }
        BIToExpnMetadataConverter.setAggregate(metadata, calc.getRegularAggregate());
        metadataList.add(metadata);
    }

    private static void setNamedSetMetadata(NamedSet namedSet, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        ColumnMetadata.Type type = BIToExpnMetadataConverter.getColumnType(namedSet.getUsage());
        ColumnMetadata metadata = new ColumnMetadata();
        metadata.setCategory(null);
        metadata.setDataType(BIToExpnMetadataConverter.getColumnMetadataType(namedSet.getDatatype(), ColumnMetadata.Type.FACT.equals((Object)type)));
        metadata.setXQEDataType(BIToExpnMetadataConverter.getXQEDataType(namedSet.getDatatype()));
        metadata.setLabel(namedSet.getLabel());
        if (idToPrepend == null) {
            throw new IllegalStateException(" namedSet ID == null");
        }
        metadata.setColumnId(idToPrepend);
        metadata.setSourceCategory(ColumnMetadata.SourceCategory.NAMED_SET);
        metadata.setType(type);
        metadata.setDefaultSort(BIToExpnMetadataConverter.getDefaultSorting(namedSet.getIdentifier(), namedSet.getFacetDefinition()));
        metadata.setQuerySubjectID(null);
        metadata.setQuerySubjectLabel(null);
        metadata.setCalculation(Boolean.FALSE);
        if (hidden.booleanValue() || namedSet.isHidden() != null && namedSet.isHidden().booleanValue()) {
            metadata.setHidden(Boolean.TRUE);
        }
        BIToExpnMetadataConverter.setAggregate(metadata, namedSet.getRegularAggregate());
        String hun = namedSet.getRefToHierarchy();
        for (ColumnMetadata currMetadata : metadataList) {
            String columnId = currMetadata.getColumnId();
            if (!columnId.equals(hun)) continue;
            metadata.setHierarchy(currMetadata);
            break;
        }
        metadataList.add(metadata);
    }

    private static void setModuleColumnMetadata(DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        ArrayList<ColumnMetadata> metadataList = new ArrayList<ColumnMetadata>();
        List querySubectList = module.getQuerySubject();
        for (QuerySubject querySubject : querySubectList) {
            BIToExpnMetadataConverter.setColumnMetadata(querySubject, null, metadataList, dataSet, module, datasetType, hidden);
        }
        dataSet.setColumnMetadata(metadataList);
    }

    private static void setColumnMetadata(QuerySubject querySubject, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        List queryItemList = querySubject.getQueryItem();
        for (QueryItem item : queryItemList) {
            BIToExpnMetadataConverter.setQueryItemColumnMetadata(querySubject, null, item, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
        }
    }

    private static void setQueryItemColumnMetadata(QuerySubject querySubject, ColumnMetadata parentColumn, QueryItem item, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        List queryItems = item.getItem();
        ColumnMetadata.SourceCategory sourceCategory = null;
        sourceCategory = item.getSourceCategory() != null ? ColumnMetadata.SourceCategory.fromValue((String)item.getSourceCategory().toString()) : ColumnMetadata.SourceCategory.COLUMN;
        if (idToPrepend != null) {
            idToPrepend = idToPrepend + DOT + item.getIdentifier();
        }
        ColumnMetadata metadata = new ColumnMetadata();
        if (!sourceCategory.equals((Object)ColumnMetadata.SourceCategory.DIMENSION_MEASURE) && !sourceCategory.equals((Object)ColumnMetadata.SourceCategory.DIMENSION_REGULAR)) {
            ColumnMetadata.Type type = BIToExpnMetadataConverter.getColumnType(item.getUsage());
            metadata.setCategory(null);
            if (sourceCategory.equals((Object)ColumnMetadata.SourceCategory.LEVEL) || sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_LEVEL) || sourceCategory.equals((Object)ColumnMetadata.SourceCategory.HIERARCHY_PARENT_CHILD)) {
                if (item.isHierarchyHasMultipleRoots() != null) {
                    metadata.setHierarchyHasMultipleRoots(item.isHierarchyHasMultipleRoots().booleanValue());
                }
                metadata.setDataType(ColumnMetadata.DataType.STRING);
                metadata.setXQEDataType(BIToExpnMetadataConverter.getXQEDataType(ColumnMetadata.DataType.STRING.toString()));
                BIToExpnMetadataConverter.setAggregate(metadata, RegularAggregateType.COUNT);
                FieldOrdering ordering = new FieldOrdering();
                ordering.setOrder(SortOrder.HIERARCHIZE);
                metadata.setDefaultSort(ordering);
            } else {
                metadata.setDataType(BIToExpnMetadataConverter.getColumnMetadataType(item.getDatatype(), ColumnMetadata.Type.FACT.equals((Object)type)));
                metadata.setXQEDataType(BIToExpnMetadataConverter.getXQEDataType(item.getDatatype()));
                BIToExpnMetadataConverter.setAggregate(metadata, item.getRegularAggregate());
                metadata.setDefaultSort(BIToExpnMetadataConverter.getDefaultSorting(item.getIdentifier(), item.getFacetDefinition()));
            }
            metadata.setColumnName(item.getIdentifier());
            metadata.setLabel(item.getLabel());
            if (idToPrepend != null) {
                metadata.setColumnId(idToPrepend);
            } else {
                String colId = item.getIdForExpression();
                if (colId == null || colId.isEmpty()) {
                    colId = querySubject.getIdentifier() + DOT + item.getIdentifier();
                }
                metadata.setColumnId(colId);
            }
            metadata.setType(type);
            metadata.setFormat(BIToExpnMetadataConverter.getJSONFormatFromXML(item.getFormat()));
            metadata.setQuerySubjectID(querySubject.getIdentifier());
            metadata.setQuerySubjectLabel(querySubject.getLabel());
            if (hidden.booleanValue() || Boolean.TRUE.equals(item.isHidden())) {
                metadata.setHidden(Boolean.TRUE);
            }
            if (parentColumn != null) {
                metadata.setParentColumn(parentColumn);
                parentColumn.addChildColumn(metadata);
            }
            if (item.getFacetDefinition() != null) {
                metadata.setFacetEnabled(ColumnMetadata.FacetEnabled.fromValue((String)item.getFacetDefinition().getEnabled().value()));
            }
            if (null != item.isNullable()) {
                metadata.setIsNullable(item.isNullable().booleanValue());
            }
            metadata.setSuggestedStats(BIToExpnMetadataConverter.inferSupportedStats(item, metadata.getXQEDataType()));
            metadata.setSourceCategory(sourceCategory);
            metadataList.add(metadata);
        }
        if (queryItems != null) {
            for (ItemType queryItemType : queryItems) {
                NamedSet namedSet;
                ItemType.Folder nestedFolder;
                QueryItem queryItem = queryItemType.getQueryItem();
                if (queryItem != null) {
                    BIToExpnMetadataConverter.setQueryItemColumnMetadata(querySubject, metadata, queryItem, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
                }
                if ((nestedFolder = queryItemType.getFolder()) != null) {
                    BIToExpnMetadataConverter.setFolderMetadata(querySubject, nestedFolder, idToPrepend, metadataList, dataSet, module, datasetType, hidden);
                }
                if ((namedSet = queryItemType.getNamedSet()) == null) continue;
                String namedSetID = namedSet.getRefToHierarchy() + DOT + namedSet.getIdentifier();
                BIToExpnMetadataConverter.setNamedSetMetadata(namedSet, namedSetID, metadataList, dataSet, module, datasetType, hidden);
            }
        }
    }

    private static String extractAlias(String ref) {
        if (null == ref) {
            return null;
        }
        String alias = null;
        int idxSQ = ref.indexOf(OPEN_SQUARE_BRACKET);
        if (idxSQ > 0) {
            alias = ref.substring(0, idxSQ - 1);
        }
        return alias;
    }

    private static void setItemHierarchyMetadata(QuerySubject querySubject, ColumnMetadata parentColumn, ItemHierarchy item, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        if (idToPrepend != null) {
            idToPrepend = idToPrepend + DOT + item.getIdentifier();
        }
        ColumnMetadata metadata = new ColumnMetadata();
        metadata.setCategory(null);
        metadata.setSourceCategory(ColumnMetadata.SourceCategory.HIERARCHY_LEVEL);
        metadata.setHierarchyHasMultipleRoots(false);
        metadata.setDataType(ColumnMetadata.DataType.STRING);
        metadata.setXQEDataType(BIToExpnMetadataConverter.getXQEDataType(ColumnMetadata.DataType.STRING.toString()));
        BIToExpnMetadataConverter.setAggregate(metadata, RegularAggregateType.COUNT);
        FieldOrdering ordering = new FieldOrdering();
        ordering.setOrder(SortOrder.HIERARCHIZE);
        metadata.setDefaultSort(ordering);
        metadata.setColumnName(item.getIdentifier());
        metadata.setLabel(item.getLabel());
        if (idToPrepend != null) {
            metadata.setColumnId(idToPrepend);
        } else {
            String colId = querySubject.getIdentifier() + DOT + item.getIdentifier();
            metadata.setColumnId(colId);
        }
        metadata.setType(ColumnMetadata.Type.ATTRIBUTE);
        metadata.setQuerySubjectID(querySubject.getIdentifier());
        metadata.setQuerySubjectLabel(querySubject.getLabel());
        if (hidden.booleanValue() || Boolean.TRUE.equals(item.isHidden())) {
            metadata.setHidden(Boolean.TRUE);
        }
        if (parentColumn != null) {
            metadata.setParentColumn(parentColumn);
            parentColumn.addChildColumn(metadata);
        }
        metadataList.add(metadata);
        List levels = item.getLocalRef();
        for (LocalRefType level : levels) {
            BIToExpnMetadataConverter.setLevelMetadata(querySubject, metadata, level.getRef(), metadata.getColumnId(), metadataList, dataSet, module, datasetType, hidden);
        }
    }

    private static void setLevelMetadata(QuerySubject querySubject, ColumnMetadata parentColumn, String item, String idToPrepend, List<ColumnMetadata> metadataList, DataSet dataSet, Module module, String datasetType, Boolean hidden) {
        if (idToPrepend != null) {
            idToPrepend = idToPrepend + DOT + item;
        }
        ColumnMetadata metadata = new ColumnMetadata();
        metadata.setCategory(null);
        metadata.setSourceCategory(ColumnMetadata.SourceCategory.LEVEL);
        metadata.setHierarchyHasMultipleRoots(false);
        metadata.setDataType(ColumnMetadata.DataType.STRING);
        metadata.setXQEDataType(BIToExpnMetadataConverter.getXQEDataType(ColumnMetadata.DataType.STRING.toString()));
        BIToExpnMetadataConverter.setAggregate(metadata, RegularAggregateType.COUNT);
        FieldOrdering ordering = new FieldOrdering();
        ordering.setOrder(SortOrder.HIERARCHIZE);
        metadata.setDefaultSort(ordering);
        metadata.setColumnName(item);
        if (idToPrepend != null) {
            metadata.setColumnId(idToPrepend);
        } else {
            String colId = querySubject.getIdentifier() + DOT + item;
            metadata.setColumnId(colId);
        }
        metadata.setType(ColumnMetadata.Type.ATTRIBUTE);
        metadata.setQuerySubjectID(querySubject.getIdentifier());
        metadata.setQuerySubjectLabel(querySubject.getLabel());
        if (hidden.booleanValue()) {
            metadata.setHidden(Boolean.TRUE);
        }
        if (parentColumn != null) {
            metadata.setParentColumn(parentColumn);
            parentColumn.addChildColumn(metadata);
        }
        metadataList.add(metadata);
    }

    public static String getJSONFormatFromXML(String xmlFormat) {
        if (xmlFormat == null || xmlFormat.trim().length() == 0) {
            return "";
        }
        if (xmlFormat.contains("&amp;")) {
            String result = StringEscapeUtils.unescapeXml((String)xmlFormat);
            result = StringEscapeUtils.unescapeXml((String)result);
            result = XMLToJSON.convertXMLToJSON(result, "UTF-8");
            return result;
        }
        return xmlFormat;
    }

    private static FieldOrdering getDefaultSorting(String identifier, FacetType facet) {
        if (facet == null || FacetTypeEnabled.FALSE.equals((Object)facet.getEnabled())) {
            return null;
        }
        FieldOrdering ordering = null;
        if (FacetTypeEnabled.AUTOMATIC.equals((Object)facet.getEnabled())) {
            ordering = new FieldOrdering();
            ordering.setOrder(SortOrder.ASC);
        } else {
            List sorting;
            SortListType sort = facet.getSortList();
            if (sort != null && !(sorting = sort.getSortItem()).isEmpty()) {
                ordering = new FieldOrdering();
                SortListType.SortItem sortItem = (SortListType.SortItem)sorting.get(0);
                String ref = sortItem.getRef();
                if (!ref.equals(identifier)) {
                    ordering.setReferencedIdentifier(ref);
                }
                if (com.ibm.bi.platform.moser.common.generated.metadata.SortOrder.ASCENDING.equals((Object)sortItem.getOrder())) {
                    ordering.setOrder(SortOrder.ASC);
                } else {
                    ordering.setOrder(SortOrder.DESC);
                }
                SortOrderNullPlacement nullPlacement = sortItem.getNullPlacement();
                if (nullPlacement != null) {
                    if (SortOrderNullPlacement.FIRST.equals((Object)nullPlacement)) {
                        ordering.setNullPlacement(NullPlacement.FIRST);
                    } else {
                        ordering.setNullPlacement(NullPlacement.LAST);
                    }
                }
            }
        }
        return ordering;
    }

    private static ColumnMetadata.DataType getColumnMetadataType(String key, boolean isFact) {
        if (key != null) {
            String datatypeKey = key.toUpperCase();
            if (datatypeKey.startsWith("BIGINT")) {
                return ColumnMetadata.DataType.INTEGER;
            }
            if (datatypeKey.startsWith("CHAR(")) {
                return ColumnMetadata.DataType.STRING;
            }
            if (datatypeKey.startsWith("DATE")) {
                return ColumnMetadata.DataType.DATE;
            }
            if (datatypeKey.startsWith("DECIMAL") || datatypeKey.startsWith("NUMERIC")) {
                return ColumnMetadata.DataType.DECIMAL;
            }
            if (datatypeKey.startsWith("DOUBLE")) {
                return ColumnMetadata.DataType.DOUBLE;
            }
            if (datatypeKey.startsWith("FLOAT")) {
                return ColumnMetadata.DataType.FLOAT;
            }
            if (datatypeKey.startsWith("INTEGER")) {
                return ColumnMetadata.DataType.INTEGER;
            }
            if (datatypeKey.startsWith("NCHAR")) {
                return ColumnMetadata.DataType.STRING;
            }
            if (datatypeKey.startsWith("NVARCHAR(")) {
                return ColumnMetadata.DataType.STRING;
            }
            if (datatypeKey.startsWith("SMALLINT")) {
                return ColumnMetadata.DataType.INTEGER;
            }
            if ("TIMESTAMP".equals(datatypeKey)) {
                return ColumnMetadata.DataType.DATETIME;
            }
            if ("TIME".equals(datatypeKey)) {
                return ColumnMetadata.DataType.TIME;
            }
            if ("DATE".equals(datatypeKey)) {
                return ColumnMetadata.DataType.DATE;
            }
            if (datatypeKey.startsWith("TINYINT")) {
                return ColumnMetadata.DataType.INTEGER;
            }
            if (datatypeKey.startsWith("VARCHAR(")) {
                return ColumnMetadata.DataType.STRING;
            }
            if (datatypeKey.startsWith("STRING")) {
                return ColumnMetadata.DataType.STRING;
            }
        }
        return isFact ? ColumnMetadata.DataType.DECIMAL : ColumnMetadata.DataType.STRING;
    }

    private static IDataType getXQEDataType(String key) {
        if (key != null) {
            String datatypeKey = key.toUpperCase();
            if ("BIGINT".equals(datatypeKey)) {
                return DataTypeFactory.getLongType();
            }
            if ("DATE".equals(datatypeKey)) {
                return DataTypeFactory.getDateType();
            }
            if ("DECIMAL".equals(datatypeKey) || "NUMERIC".equals(datatypeKey)) {
                return DataTypeFactory.getDecimalType();
            }
            if ("DOUBLE".equals(datatypeKey)) {
                return DataTypeFactory.getDoubleType();
            }
            if ("FLOAT".equals(datatypeKey)) {
                return DataTypeFactory.getFloatType();
            }
            if ("INTEGER".equals(datatypeKey)) {
                return DataTypeFactory.getIntegerType();
            }
            if ("SMALLINT".equals(datatypeKey)) {
                return DataTypeFactory.getSmallintType();
            }
            if ("TIMESTAMP".equals(datatypeKey)) {
                return DataTypeFactory.getTimestampType();
            }
            if ("TIMESTAMP_TZ".equals(datatypeKey)) {
                return DataTypeFactory.getTimestampWithTZType();
            }
            if ("TIME".equals(datatypeKey)) {
                return DataTypeFactory.getTimeType();
            }
            if ("TIME_TZ".equals(datatypeKey)) {
                return DataTypeFactory.getTimeWithTZType();
            }
            if ("TINYINT".equals(datatypeKey)) {
                return DataTypeFactory.getTinyintType();
            }
            if ("STRING".equals(datatypeKey)) {
                return DataTypeFactory.getStringType();
            }
            String dtTxt = key.toLowerCase();
            return DataTypeFactory.getType((String)dtTxt);
        }
        return null;
    }

    private static ColumnMetadata.Type getColumnType(UsageType key) {
        if (UsageType.FACT.equals((Object)key)) {
            return ColumnMetadata.Type.FACT;
        }
        return ColumnMetadata.Type.ATTRIBUTE;
    }

    private static void setAggregate(ColumnMetadata metadata, RegularAggregateType key) {
        if (key == RegularAggregateType.NONE) {
            metadata.setDefaultAggregation(AggregateType.NONE);
        } else if (key == RegularAggregateType.AVERAGE) {
            metadata.setDefaultAggregation(AggregateType.AVG);
        } else if (key == RegularAggregateType.AUTOMATIC) {
            metadata.setDefaultAggregation(AggregateType.AUTOMATIC);
        } else if (key == RegularAggregateType.CALCULATED) {
            metadata.setDefaultAggregation(AggregateType.CALCULATED);
        } else if (key == RegularAggregateType.COUNT) {
            metadata.setDefaultAggregation(AggregateType.COUNT);
        } else if (key == RegularAggregateType.COUNT_DISTINCT) {
            metadata.setDefaultAggregation(AggregateType.COUNTDISTINCT);
        } else if (key == RegularAggregateType.COUNT_NON_ZERO) {
            metadata.setDefaultAggregation(AggregateType.UNKNOWN);
        } else if (key == RegularAggregateType.MAXIMUM) {
            metadata.setDefaultAggregation(AggregateType.MAX);
        } else if (key == RegularAggregateType.MEDIAN) {
            metadata.setDefaultAggregation(AggregateType.MEDIAN);
        } else if (key == RegularAggregateType.MINIMUM) {
            metadata.setDefaultAggregation(AggregateType.MIN);
        } else if (key == RegularAggregateType.STANDARD_DEVIATION) {
            metadata.setDefaultAggregation(AggregateType.STDDEV);
        } else if (key == RegularAggregateType.TOTAL) {
            metadata.setDefaultAggregation(AggregateType.SUM);
        } else if (key == RegularAggregateType.VARIANCE) {
            metadata.setDefaultAggregation(AggregateType.VARIANCE);
        } else {
            metadata.setDefaultAggregation(AggregateType.UNKNOWN);
        }
    }

    private static void setMeta(DataSet dataSet, String queryId) {
        Meta meta = new Meta();
        meta.setBundleID(queryId);
        meta.setCreator("CognosXQE");
        meta.setVersion(Integer.valueOf(1));
        dataSet.setMeta(meta);
    }

    private static String[] inferSupportedStats(QueryItem item, IDataType xqeDataType) {
        ArrayList<String> supportedStats = new ArrayList<String>();
        if (null == item.getSourceCategory() && (null == item.getExpression() || item.getExpression().startsWith("'<unsupported:"))) {
            return new String[0];
        }
        if (null == item.getDatatype() || item.getDatatype().startsWith("CLOB") || item.getDatatype().startsWith("BINARY")) {
            return new String[0];
        }
        supportedStats.add("min");
        supportedStats.add("max");
        supportedStats.add("count");
        supportedStats.add("countNull");
        if (null != xqeDataType && !xqeDataType.isApproximateNumeric()) {
            if (null != item.getDatatype() && (item.getDatatype().startsWith("INTERVAL") || item.getDatatype().startsWith("NUMERIC") || item.getDatatype().startsWith("DECIMAL"))) {
                String dataType = item.getDatatype().trim();
                int commaIdx = dataType.lastIndexOf(44);
                if (commaIdx != -1 && dataType.endsWith(")")) {
                    try {
                        int scale = Integer.parseInt(dataType.substring(commaIdx + 1, dataType.length() - 1));
                        if (scale == 0 && !UsageType.FACT.equals((Object)item.getUsage())) {
                            supportedStats.add("countDistinct");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (UsageType.IDENTIFIER.equals((Object)item.getUsage()) || UsageType.ATTRIBUTE.equals((Object)item.getUsage())) {
                supportedStats.add("countDistinct");
            }
        }
        return supportedStats.toArray(new String[supportedStats.size()]);
    }
}

