/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds;

import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import org.apache.commons.configuration.ConversionException;

public final class MDDSConfig
implements XQEConfigurationListener {
    private static final String CONFIG_ERROR_PREFIX = "Error converting value of configuration parameter: ";
    private static final String LOAD_ERR_MSG = "Error loading XQEODP configuration: ";
    private boolean isRegistered = false;
    private final String providerName;
    private final XQELogger configLogger;
    private boolean isNamespaceFilteringEnabled;
    private static final boolean DEFAULT_IS_NAMESPACE_FILTERING_ENABLED = false;

    public MDDSConfig(String theProviderType) {
        this.providerName = this.getConfigProviderName(theProviderType);
        this.configLogger = MDDSLogger.getLogger("Configuration", LogLevel.TRACE);
        if (this.configLogger.isOn()) {
            this.configLogger.log("Constructing MDDSConfig for " + this.providerName);
        }
    }

    public boolean isNamespaceFilteringEnabled() {
        return this.isNamespaceFilteringEnabled;
    }

    public void configurationChanged(XQEConfigurationEvent e) {
        if (e.isBeforeUpdate()) {
            return;
        }
        this.reload();
    }

    private String getConfigProviderName(String theProviderType) {
        if (theProviderType.equals("PC")) {
            return "PowerCubeODPXQE";
        }
        throw new IllegalArgumentException("Provider type code is invalid for MDDS provider: " + theProviderType);
    }

    public void reload() {
        XQEConfiguration config;
        if (this.configLogger.isOn()) {
            this.configLogger.log("Loading MDDSConfig");
        }
        if ((config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP)) == null) {
            if (this.configLogger.isOn()) {
                this.configLogger.log("Constructing new XQEConfiguration instance for XQEODP");
            }
            try {
                config = XQECCLConfigurationAdapter.createDefaultConfigurationForService((ServiceEnumeration)ServiceEnumeration.XQEODP);
                XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQEODP, config);
                config.registerConfigurationListener((XQEConfigurationListener)this);
                this.isRegistered = true;
            }
            catch (ConfigException ce) {
                if (XQEMessageKeys.CFG_FileExistError == ce.getMessageKey()) {
                    if (this.configLogger.isOn(LogLevel.WARN)) {
                        this.configLogger.log(LogLevel.WARN, LOAD_ERR_MSG, (Throwable)ce);
                    }
                } else if (this.configLogger.isOn(LogLevel.ERROR)) {
                    this.configLogger.log(LogLevel.ERROR, LOAD_ERR_MSG, (Throwable)ce);
                }
                return;
            }
        } else if (!this.isRegistered) {
            config.registerConfigurationListener((XQEConfigurationListener)this);
            this.isRegistered = true;
        }
        XQESubConfiguration configMDDS = config.getConfigForXQEODPComponent(this.providerName);
        if (configMDDS != null) {
            configMDDS.next();
            try {
                this.isNamespaceFilteringEnabled = configMDDS.getBoolean("enableNamespaceFiltering[@value]", Boolean.valueOf(false));
            }
            catch (ConversionException ce) {
                if (this.configLogger.isOn(LogLevel.ERROR)) {
                    this.configLogger.log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": enableNamespaceFiltering : ", (Throwable)ce);
                }
            }
        } else if (this.configLogger.isOn(LogLevel.WARN)) {
            this.configLogger.log(LogLevel.WARN, "Configuration for " + this.providerName + " provider not found");
        }
        this.writeToLog();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void writeToLog() {
        if (this.configLogger.isOn(LogLevel.WARN)) {
            this.configLogger.log(LogLevel.WARN, "Dumping MDDS Configuration.");
        }
    }
}

