/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryTimeoutDecorator;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.mdds.MDDSCancelListener;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMetadataProvider;
import com.cognos.xqe.data.providers.olap.mdds.connection.ConnectionParameterHelper;
import com.cognos.xqe.data.providers.olap.mdds.connection.MDDSConnectionExpirationPolicy;
import com.cognos.xqe.data.providers.olap.mdds.connection.PCConnectionSelector;
import com.cognos.xqe.data.providers.olap.mdds.resultset.MDDSDimensionalResult;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.qfwbridge.QFWBridge;
import com.cognos.xqe.data.providers.qfwbridge.QFWConnection;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.dom4j.Element;

public class MDDSDataProvider
extends OLAPDataProviderBase {
    private final MDDSConnectionFactory mMDDSConnectionFactory;
    private final IConnectionFactory mConnectionFactory;
    private final IConnectionSelector mPCConnectionSelector;
    private static final String INITIAL_CONNECTION_EXPIRATION_THRESHOLD = "initialConnectionExpirationThreshold";
    private static final long DEFAULT_INITIAL_CONNECTION_EXPIRATION_THRESHOLD = 10000L;
    public static final int DEFAULT_MDDS_CONNECTION_EXPIRATION_CHECK_PERIOD = 10000;
    private static final Properties DEFAULT_MDDS_PROPERTIES = MDDSDataProvider.makeDefaultMDDSProperties();
    private static final String INCLUDE_CALCULATED_MEMBERS = "<includeCalculatedMembers value=\"true\"/>";
    private static final String ALIAS_TABLE_MAP = "aliasTableMap";
    private static final String ALIAS_TABLE = "aliasTable";
    private static final String LANG = " lang=";
    private static final String NAME = " name=";
    private static final String VALUE = " value=";
    private static final String GT_OPERATOR = ">";
    private static final String LT_OPERATOR = "<";
    private static final String QUOTE = "\"";
    private static final String SLASH = "/";
    private static final String BRACKET_DOT = "].";
    private static final String BRACKET_COMMA = "], ";
    private static final String REQUEST_ID_STR = "RequestID[";
    private static final String QFW_EXECUTE_BEGIN = "<execute>";
    private static final String QFW_EXECUTE_END = "</execute>";
    private static final String DEFAULT_HIERARCHY_BRACKETS = "[]";
    private static final String MEMBER = "[@MEMBER]";
    private static final String USE_PXJ_THRESHOLD = "UseProviderCrossJoinThreshold";
    private static final String USE_PXJ_THRESHOLD_VALUE = "10000";
    private static final String USE_PXJ_THRESHOLD_KEY = "queryExecution.useProviderCrossJoinThreshold[@value]";
    private static final boolean IS_OS_WINDOWS = SystemUtils.IS_OS_WINDOWS;

    public MDDSDataProvider(String instanceName, Properties properties) {
        super(instanceName, properties, null);
        try {
            QFWBridge.initialize();
        }
        catch (Throwable e) {
            throw new MDDSException(MDDSMessageKeys.INI_BRIDGE_INIT_ERROR, e);
        }
        this.mMDDSConnectionFactory = new MDDSConnectionFactory();
        this.mConnectionFactory = ConnectionFactoryTimeoutDecorator.decorateIfNecessary((IConnectionFactory)new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mMDDSConnectionFactory, instanceName), (Properties)this.getProperties());
        this.mPCConnectionSelector = new PCConnectionSelector();
    }

    protected Properties getDefaultProperties(Properties properties) {
        Properties defaultProperties = super.getDefaultProperties(properties);
        defaultProperties.putAll((Map<?, ?>)DEFAULT_MDDS_PROPERTIES);
        return properties;
    }

    protected static Properties makeDefaultMDDSProperties() {
        Properties properties = new Properties();
        properties.setProperty("connectionExpirationCheckPeriod", Integer.toString(10000));
        properties.setProperty(INITIAL_CONNECTION_EXPIRATION_THRESHOLD, Long.toString(10000L));
        return properties;
    }

    public long getConnectionSelectionTimeout() {
        long connectionSelectionTimeout = Long.valueOf(this.getProperty("connectionSelectionTimeout"));
        return connectionSelectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArgument) {
        ExecutionEnvironment env = (ExecutionEnvironment)xDataContext.getEnvironment();
        ConnectionParameters params = this.createConnectionParameters((IExecutionEnvironment)env, theQueryArgument);
        MDXQuery mdxQuery = theQueryArgument.getMDXQuery();
        String mdQuerySpec = MDDSDataProvider.getMDXQueryString(env, params, mdxQuery, false);
        if (MDDSLogger.DATA_MDX.isOn(LogLevel.TRACE)) {
            MDDSLogger.DATA_MDX.log(LogLevel.TRACE, MDDSDataProvider.getMDXQueryString(env, params, mdxQuery, true));
        }
        MDDSConnection connection = (MDDSConnection)((Object)this.borrowConnection(params, (IExecutionEnvironment)env).getConnection());
        connection.setConnectionParameter(params);
        MetricsService.startCollectingMetric((RequestEnvironment)((RequestEnvironment)env.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
        try {
            QFWConnection qfwconn = connection.getConnection();
            QFWQuery query = qfwconn.createQuery(((RequestEnvironment)env.getRequestEnvironment()).getProductLocale());
            try {
                MDDSCancelListener cancelListener = new MDDSCancelListener(qfwconn, env, (QueryArguments)theQueryArgument, params);
                env.getCancelManager().addCancelHandler((ICancelable)cancelListener);
                try {
                    query.execute(mdQuerySpec);
                }
                finally {
                    env.getCancelManager().removeCancelHandler((ICancelable)cancelListener);
                    if (!qfwconn.isReusable()) {
                        connection.invalidate();
                    }
                }
                int numDatasets = query.getDatasetCount();
                if (numDatasets < 1) {
                    query.release();
                    MDDSDimensionalResult mDDSDimensionalResult = new MDDSDimensionalResult(this, connection, null, xDataContext, theQueryArgument);
                    return mDDSDimensionalResult;
                }
                MDDSDimensionalResult mDDSDimensionalResult = new MDDSDimensionalResult(this, connection, query, xDataContext, theQueryArgument);
                return mDDSDimensionalResult;
            }
            catch (OperationCanceledException ex) {
                query.release();
                throw ex;
            }
            catch (QFWException ex) {
                query.release();
                if (ex.getDetailMessage().contains("RSA-ERR-0007")) {
                    throw new OperationCanceledException();
                }
                throw new MDDSException(MDDSMessageKeys.ERR_EXECUTE_ERROR, ex.getLocalizedMessage());
            }
            catch (Throwable ex) {
                query.release();
                throw new MDDSException(MDDSMessageKeys.ERR_EXECUTE_ERROR, ex, ex.getLocalizedMessage());
            }
            {
                catch (RuntimeException ex) {
                    connection.returnToPool();
                    throw ex;
                }
            }
        }
        finally {
            connection.setCubeLoaded(true);
            MetricsService.endCollectingMetric((RequestEnvironment)((RequestEnvironment)env.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
        }
    }

    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        MDDSConnection connection = (MDDSConnection)((Object)this.mMDDSConnectionFactory.createConnection(MDDSDataProvider.createConnectionParams(theQueryArguments)));
        this.mMDDSConnectionFactory.destroyConnection(connection);
        return null;
    }

    protected static String getMDXQueryString(ExecutionEnvironment env, ConnectionParameters params, MDXQuery mdxQuery, boolean forLogging) {
        List aliasTable;
        StringBuilder buffer = new StringBuilder();
        buffer.append(QFW_EXECUTE_BEGIN);
        String executeQuery = mdxQuery.getMDQuery();
        buffer.append(executeQuery);
        if (mdxQuery.getIncludeCalculatedMembers()) {
            buffer.append(INCLUDE_CALCULATED_MEMBERS);
        }
        if ((aliasTable = mdxQuery.getAliasTable()) != null) {
            buffer.append(LT_OPERATOR);
            buffer.append(ALIAS_TABLE_MAP);
            buffer.append(GT_OPERATOR);
            for (IAliasEntry entry : aliasTable) {
                buffer.append(LT_OPERATOR);
                buffer.append(ALIAS_TABLE);
                buffer.append(LANG);
                buffer.append(QUOTE);
                buffer.append(entry.getKey());
                buffer.append(QUOTE);
                buffer.append(NAME);
                buffer.append(QUOTE);
                buffer.append(XMLEscCharacter.escapeString((String)entry.getValue()));
                buffer.append(QUOTE);
                buffer.append(SLASH);
                buffer.append(GT_OPERATOR);
            }
            buffer.append(LT_OPERATOR);
            buffer.append(SLASH);
            buffer.append(ALIAS_TABLE_MAP);
            buffer.append(GT_OPERATOR);
        }
        if (mdxQuery.getNullExpressionBehavior() != null) {
            buffer.append(LT_OPERATOR);
            buffer.append("nullExpressionBehavior");
            buffer.append(VALUE);
            buffer.append(QUOTE);
            buffer.append(mdxQuery.getNullExpressionBehavior().toString());
            buffer.append(QUOTE);
            buffer.append(SLASH);
            buffer.append(GT_OPERATOR);
        }
        if (mdxQuery.getNullSuppressionQueryHint() != null) {
            buffer.append(LT_OPERATOR);
            buffer.append("nullSuppressionAcrossEdges");
            buffer.append(VALUE);
            buffer.append(QUOTE);
            buffer.append(mdxQuery.getNullSuppressionQueryHint().toString());
            buffer.append(QUOTE);
            buffer.append(SLASH);
            buffer.append(GT_OPERATOR);
        }
        if (Boolean.TRUE.equals(mdxQuery.getBooleanPropertyValue("PXJEnabled"))) {
            buffer.append(LT_OPERATOR);
            buffer.append(USE_PXJ_THRESHOLD);
            buffer.append(VALUE);
            buffer.append(QUOTE);
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            buffer.append(config.getStringProperty(USE_PXJ_THRESHOLD_KEY, USE_PXJ_THRESHOLD_VALUE));
            buffer.append(QUOTE);
            buffer.append(SLASH);
            buffer.append(GT_OPERATOR);
        }
        buffer.append(QFW_EXECUTE_END);
        if (null != env.getRequestID()) {
            return MDDSDataProvider.generateMDQuerySpec(env, params, env.getRequestID(), buffer, forLogging);
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_RequestIdMissing);
    }

    protected static ConnectionParameters createConnectionParams(ConnectionTestQueryArguments args) {
        IExecutionEnvironment env = args.getExecutionEnvironment();
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters(env, connectionElement, args.getDataSource(), args.getRunLocale(), true);
    }

    protected static ConnectionParameters createConnectionParams(IExecutionEnvironment env, MDXQueryArguments args) {
        Element connectionElement = env.getConnectionElement();
        ConnectionParameters params = ConnectionParameterHelper.constructConnectionParameters(env, connectionElement, args.getDataSource(), args.getRunLocale(), true);
        String cubeName = args.getCube().getName();
        params.put((IConnectionParameter)new CubeParameter(cubeName, true));
        return params;
    }

    protected static ConnectionParameters createConnectionParams(MetadataQueryArguments args) {
        IExecutionEnvironment env = args.getExecutionEnvironment();
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters(env, connectionElement, args.getDataSource(), args.getDesignLocale(), true);
    }

    public static String generateMDQuerySpec(ExecutionEnvironment env, ConnectionParameters params, String requestID, String content, boolean forLogging) {
        StringBuilder buffer = new StringBuilder(content);
        return MDDSDataProvider.generateMDQuerySpec(env, params, requestID, buffer, forLogging);
    }

    public static String generateMDQuerySpec(ExecutionEnvironment env, ConnectionParameters params, String requestID, StringBuilder content, boolean forLogging) {
        MetricsService.startCollectingMetric((RequestEnvironment)((RequestEnvironment)env.getRequestEnvironment()), (String)"generateXMLMDQuerySpec");
        StringBuilder strBuf = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><qs:command xmlns:qs=\"http://developer.cognos.com/schemas/qsapi/2/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        try {
            ConnectionParameterHelper.writeXML(params, strBuf, forLogging);
        }
        catch (Exception e) {
            throw new MDDSException(MDDSMessageKeys.MET_UNEXPECTED_ERROR, e);
        }
        strBuf.append((CharSequence)content);
        QFWQuery.appendRequestID((StringBuilder)strBuf, (String)requestID);
        strBuf.append("</qs:command>");
        MetricsService.endCollectingMetric((RequestEnvironment)((RequestEnvironment)env.getRequestEnvironment()), (String)"generateXMLMDQuerySpec");
        return strBuf.toString();
    }

    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        int bracketPos;
        StringBuilder buffer = new StringBuilder();
        String hun = hierarchy.getUniqueName();
        if (hun.substring(bracketPos = hun.length() - DEFAULT_HIERARCHY_BRACKETS.length()).equals(DEFAULT_HIERARCHY_BRACKETS)) {
            buffer.append(hun.substring(0, bracketPos));
        } else {
            buffer.append(hun);
        }
        buffer.append(".");
        buffer.append(cognosUN);
        return buffer.toString();
    }

    public String nativeUNToCognosUN(String providerType, String nativeUN) {
        if (nativeUN == null) {
            return null;
        }
        int memberStringPosition = nativeUN.indexOf(MEMBER);
        int doubleDotPosition = nativeUN.indexOf("..");
        if (memberStringPosition >= 0) {
            return nativeUN.substring(memberStringPosition, nativeUN.length());
        }
        if (doubleDotPosition >= 0) {
            return UniqueNameGenerator.join((String)nativeUN.substring(0, doubleDotPosition), (String)nativeUN.substring(doubleDotPosition + 2, nativeUN.length()));
        }
        return nativeUN;
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) throws LogonFailureException {
        ConnectionParameters params = MDDSDataProvider.createConnectionParams(theQueryArguments);
        MDDSMetadataProvider provider = new MDDSMetadataProvider(this, theQueryArguments, params);
        provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "MDDS");
        return provider;
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        if (MDDSLogger.CONN_POOL.isOn(LogLevel.TRACE)) {
            StringBuilder builder = new StringBuilder("Borrow MDDSConnection: Parameters[");
            builder.append(connectionParameters.toString()).append(BRACKET_COMMA);
            builder.append(REQUEST_ID_STR).append(executionEnvironment.getRequestID()).append(BRACKET_DOT);
            MDDSLogger.CONN_POOL.log(LogLevel.TRACE, builder.toString());
        }
        IPooledConnection pooledConn = null;
        pooledConn = executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.mPCConnectionSelector, this.mConnectionFactory);
        DefaultConnection mddsConn = (DefaultConnection)pooledConn.getConnection();
        mddsConn.setPooledConnection(pooledConn);
        return pooledConn;
    }

    public IConnectionSelector getConnectionSelector(String providerType, Object securityContext) {
        return this.mPCConnectionSelector;
    }

    public Object getSecurityContext(ConnectionParameters params) {
        return null;
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        return MDDSDataProvider.createConnectionParams(env, queryArgs);
    }

    public IExpirationPolicy getConnectionExpirationPolicy() {
        int connectionExpirationThreshold = Integer.valueOf(this.getProperty("connectionExpirationThreshold"));
        long connectionLifetimeThreshold = Long.valueOf(this.getProperty("connectionLifetimeThreshold"));
        long initialConnectionExpirationThreshold = Long.valueOf(this.getProperty(INITIAL_CONNECTION_EXPIRATION_THRESHOLD));
        return new MDDSConnectionExpirationPolicy(connectionLifetimeThreshold, connectionExpirationThreshold, initialConnectionExpirationThreshold);
    }

    public void releaseImpl() {
        try {
            QFWBridge.terminate();
        }
        catch (Throwable e) {
            throw new MDDSException(MDDSMessageKeys.INI_BRIDGE_TERM_ERROR, e);
        }
    }

    public static boolean isWindows() {
        return IS_OS_WINDOWS;
    }

    public Object getCubeUniqueId(ConnectionParameters params, MDXQueryArguments args) {
        return null;
    }

    protected final class MDDSConnectionFactory
    implements IConnectionFactory {
        protected MDDSConnectionFactory() {
        }

        public Object createConnection(ConnectionParameters connectionParameters) {
            MDDSConnection connection = new MDDSConnection((IOLAPDataProvider)MDDSDataProvider.this);
            if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                MDDSLogger.CONN_POOL.log(LogLevel.INFO, "Creating new MDDSConnection from MDDSConnectionFactory");
            }
            connection.connect(connectionParameters);
            return connection;
        }

        public void destroyConnection(IPooledConnection pooledConnection) {
            this.destroyConnection((MDDSConnection)((Object)pooledConnection.getConnection()));
        }

        private void destroyConnection(MDDSConnection connection) {
            if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                MDDSLogger.CONN_POOL.log(LogLevel.INFO, "Destroy MDDSConnection from MDDSConnectionFactory.");
            }
            connection.disconnect();
        }
    }
}

