/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds;

import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataProviderEnvironmentHelper;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.mdds.MDDSCancelListener;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSDataProvider;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1UserNameParameter;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MDDSMetadataQuery;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataAttributes;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataRecordFactory;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataResponse;
import com.cognos.xqe.data.providers.olap.mdds.metadata.cache.ParentChildLevelsCache;
import com.cognos.xqe.data.providers.olap.mdds.metadata.parser.MetadataResponseParser;
import com.cognos.xqe.data.providers.olap.mdds.query.GetHierarchyDepthQuery;
import com.cognos.xqe.data.providers.olap.mdds.query.ProviderDataQuery;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.data.providers.qfwbridge.QFWConnection;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.BooleanField;
import com.cognos.xqe.metadata.record.ByteField;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.DoubleField;
import com.cognos.xqe.metadata.record.FloatField;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.IDynamicField;
import com.cognos.xqe.metadata.record.IntegerField;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.LongField;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.StringField;
import com.cognos.xqe.metadata.record.ValueField;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQueryFactory;
import com.cognos.xqe.runtree.olap.querytemplates.MemberQueryTM1;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.io.ForwardingInputStream;
import com.cognos.xqebifw.adminconsole.qsat.server.OptionsXMLProcessor;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MDDSMetadataProvider
extends MetadataProviderEnvironmentHelper<MDDSConnection>
implements IOLAPMetadataProvider {
    private static final int SEC_MODE_PROF = 2;
    private static final int SEC_MODE_MIXED = 3;
    private static final String RUN_LOCALE = "runLocale";
    private static final String VALUE = "value";
    private static final String BRACE = "[";
    private static final String LOG_MSG_TO_LEVEL_NUMBER = " to level number ";
    private static final String LOG_MSG_CONVERTED_LUN = "Converted level unique name ";
    private static final String LEVEL_NAME_PREFIX = "ParentChildHierarchyLevel_";
    private static final String FAKED_LEVEL_PATTERN = "ParentChildHierarchyLevel_\\d+";
    private static final String MDDS_TREE_OPERATOR_OR = "|";
    private final MetadataQueryArguments mdQueryArgs;
    private final XQELogger logger = MDDSLogger.getLogger("Metadata", LogLevel.TRACE);
    private static final String ERR_MSG_MISSING_REQUIRED_RESTRICTION = "Required RestrictionType ";
    private volatile DateTimeValue schemaUpdateDate;
    private boolean genLevelsForPCHier = false;
    private static final String COMMA = ",";

    public MDDSMetadataProvider(MDDSDataProvider provider, MetadataQueryArguments theQueryArguments, ConnectionParameters theConnectionParams) {
        super((OLAPDataProviderBase)provider, theConnectionParams);
        this.mdQueryArgs = theQueryArguments;
        if ("PC".equals(theQueryArguments.getDataSource().getType())) {
            this.genLevelsForPCHier = true;
        }
        if (this.mdQueryArgs.getDesignLocale() == null) {
            throw new MDDSException(MDDSMessageKeys.MET_MISSING_RUN_LOCALE);
        }
    }

    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        return false;
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        IConnectionParameter param;
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String cubeName = (String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class);
        ConnectionParameters connParams = this.connectionParameters.duplicate();
        connParams.remove(CatalogParameter.class);
        connParams.remove(CubeParameter.class);
        CacheParameters cacheParams = new CacheParameters();
        cacheParams.put(connParams);
        if (null != catalogName) {
            cacheParams.put("catalog", (Object)catalogName);
        }
        if (null != cubeName) {
            cacheParams.put("cube", (Object)cubeName);
        }
        if ((param = connParams.get(RunLocaleParameter.class)) != null) {
            cacheParams.put(param);
        }
        return cacheParams;
    }

    public void invalidateCaches(IRestrictions restrictions) {
        super.invalidateCaches(restrictions);
    }

    public List<ActionRecord> getActions(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Actions are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    public List<AliasRecord> getAliases(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        if ("PC".toString().equals(this.mdQueryArgs.getDataSource().getType())) {
            if (this.logger.isOn(LogLevel.INFO)) {
                this.logger.log(LogLevel.INFO, "Aliases are not supported for PowerCube data source.");
            }
            return Collections.emptyList();
        }
        EnumSet missingTypes = restrictions.contains(EnumSet.of(RestrictionType.CUBE));
        if (missingTypes != null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, ERR_MSG_MISSING_REQUIRED_RESTRICTION + missingTypes.toString() + " are missing for Aliases metadata request.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missingTypes.toString());
        }
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.AliasTable);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, AliasRecord.class);
        return records;
    }

    public List<CatalogRecord> getCatalogs(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Catalog);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        this.setResultRange(restrictions, query);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, null);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, CatalogRecord.class);
        return records;
    }

    public List<CubeRecord> getCubes(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Cube);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        this.setResultRange(restrictions, query);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, CubeRecord.class);
        if (!records.isEmpty()) {
            CubeRecord record = (CubeRecord)records.get(0);
            this.schemaUpdateDate = record.getSchemaUpdateDate();
        }
        return records;
    }

    public String getCubeDefaultMeasure(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Cube);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, CubeRecord.class);
        if (records.isEmpty()) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        String defaultMeasure = ((CubeRecord)records.get(0)).getDynamicFieldAsString(MetadataAttributes.Default_Measure.name());
        if (defaultMeasure == null) {
            defaultMeasure = "";
        }
        return defaultMeasure;
    }

    public List<String> getDatasourceLocales(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "DatasourceLocales are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    public List<DimensionRecord> getDimensions(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        EnumSet missingTypes = restrictions.contains(EnumSet.of(RestrictionType.CUBE));
        if (missingTypes != null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, ERR_MSG_MISSING_REQUIRED_RESTRICTION + missingTypes.toString() + " are missing for Dimensions metadata request.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missingTypes.toString());
        }
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Dimensions);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        query.addRestriction(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        this.setResultRange(restrictions, query);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, DimensionRecord.class);
        return records;
    }

    public List<HierarchyRecord> getHierarchies(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        EnumSet missingTypes = restrictions.contains(EnumSet.of(RestrictionType.CUBE));
        if (missingTypes != null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, ERR_MSG_MISSING_REQUIRED_RESTRICTION + missingTypes.toString() + " are missing for Hierarchies metadata request.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missingTypes.toString());
        }
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Hierarchies);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        query.addRestriction(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        query.addRestriction(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
        this.setResultRange(restrictions, query);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, HierarchyRecord.class);
        return records;
    }

    public List<LevelRecord> getLevels(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        EnumSet missingTypes = restrictions.contains(EnumSet.of(RestrictionType.CUBE));
        if (missingTypes != null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, ERR_MSG_MISSING_REQUIRED_RESTRICTION + missingTypes.toString() + " are missing for Levels metadata request.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missingTypes.toString());
        }
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Levels);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        query.addRestriction(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        query.addRestriction(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        if (MDDSMetadataProvider.isCreatedLevel(lun)) {
            int levelNumber = MDDSMetadataProvider.levelUniqueNameToLevelNumber(lun);
            if (this.logger.isOn(LogLevel.TRACE)) {
                this.logger.log(LogLevel.TRACE, LOG_MSG_CONVERTED_LUN + lun + LOG_MSG_TO_LEVEL_NUMBER + levelNumber);
            }
            query.addRestriction(RestrictionType.LEVEL_NUMBER, String.valueOf(levelNumber));
        } else {
            query.addRestriction(RestrictionType.LEVEL_UNIQUE_NAME, lun);
        }
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        if (levelNumber != null) {
            query.addRestriction(RestrictionType.LEVEL_NUMBER, levelNumber.toString());
        }
        this.setResultRange(restrictions, query);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, LevelRecord.class);
        if (this.genLevelsForPCHier && dun != null) {
            List<LevelRecord> parentChildLevels;
            ParentChildLevelsCache pcLevelsCache = connection.getPCLevelsCache();
            DateTimeValue currentSchemaUpdateDate = this.getSchemaUpdateDate(cubeName);
            if (this.schemaUpdateDate == null || this.schemaUpdateDate.compareTo((Object)currentSchemaUpdateDate) != 0) {
                this.logger.log(LogLevel.INFO, "Cube schema updated. Reloading parent child hierarchy levels.");
                this.schemaUpdateDate = currentSchemaUpdateDate;
                pcLevelsCache.clear();
            }
            if (hun != null) {
                if (!pcLevelsCache.isHierarchyLoaded(hun)) {
                    this.populateParentChildLevelsForHierarchy(connection, catalogName, cubeName, dun, hun);
                }
            } else if (!pcLevelsCache.isDimensionLoaded(dun)) {
                this.populateParentChildLevelsForDimension(connection, catalogName, cubeName, dun);
            }
            if (!(parentChildLevels = pcLevelsCache.getLevels(restrictions)).isEmpty()) {
                this.logger.log(LogLevel.INFO, "Adding parent-child hierarchy levels to metadata response.");
                int totalSize = query.getResultCount();
                int sizeLeft = totalSize - records.size();
                if (totalSize > 0 && sizeLeft < parentChildLevels.size()) {
                    MDDSMetadataProvider.resizeCollection(parentChildLevels, sizeLeft);
                }
                records.addAll(parentChildLevels);
            }
        } else {
            for (LevelRecord lr : records) {
                if (!lr.isHidden()) continue;
                String levelName = LEVEL_NAME_PREFIX + lr.getLevelNumber();
                String originalName = MDDSMetadataProvider.getName(lr.getUniqueName());
                String levelUniqueName = lr.getUniqueName().replaceFirst(originalName, levelName);
                lr.setName(levelName);
                lr.setUniqueId(levelName);
                lr.setUniqueName(levelUniqueName);
                lr.setCaption(levelName);
                lr.setDescription(levelName);
                lr.setDynamicField(MetadataAttributes.PPDS_KEY.toString(), (Object)levelName);
            }
        }
        return records;
    }

    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Macros are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    public List<MeasureRecord> getMeasures(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        EnumSet missingTypes = restrictions.contains(EnumSet.of(RestrictionType.CUBE));
        if (missingTypes != null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, ERR_MSG_MISSING_REQUIRED_RESTRICTION + missingTypes.toString() + " are missing for Measures metadata request.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missingTypes.toString());
        }
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Measures);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        query.addRestriction(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        query.addRestriction(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        if (MDDSMetadataProvider.isCreatedLevel(lun)) {
            int levelNumber = MDDSMetadataProvider.levelUniqueNameToLevelNumber(lun);
            if (this.logger.isOn(LogLevel.TRACE)) {
                this.logger.log(LogLevel.TRACE, LOG_MSG_CONVERTED_LUN + lun + LOG_MSG_TO_LEVEL_NUMBER + levelNumber);
            }
            query.addRestriction(RestrictionType.LEVEL_NUMBER, String.valueOf(levelNumber));
        } else {
            query.addRestriction(RestrictionType.LEVEL_UNIQUE_NAME, lun);
        }
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        if (levelNumber != null) {
            query.addRestriction(RestrictionType.LEVEL_NUMBER, levelNumber.toString());
        }
        String measureUN = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        query.addRestriction(RestrictionType.MEASURE_UNIQUE_NAME, measureUN);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        if (treeOps != null) {
            query.addRestriction(RestrictionType.TREEOP, MDDSMetadataProvider.convertTreeOp(treeOps));
        }
        this.setResultRange(restrictions, query);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, MeasureRecord.class);
        return records;
    }

    private List<IAliasEntry> getAliasTableEntries(ICube modelCube, ExecutionEnvironment execEnv) {
        IAlias alias = modelCube.getModelDataSource().getAlias();
        List aliasentries = alias.getAliasEntries();
        return aliasentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getMembers(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        EnumSet missingTypes = restrictions.contains(EnumSet.of(RestrictionType.CUBE));
        if (missingTypes != null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, ERR_MSG_MISSING_REQUIRED_RESTRICTION + missingTypes.toString() + " are missing for Members metadata request.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missingTypes.toString());
        }
        if (restrictions.contains(RestrictionType.TREEOP) && !restrictions.contains(RestrictionType.MEMBER_UNIQUE_NAME)) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.MEMBER_UNIQUE_NAME.toString());
        }
        Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        Integer createdLevelNum = null;
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        String mun = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        if (MDDSMetadataProvider.isCreatedLevel(lun)) {
            createdLevelNum = MDDSMetadataProvider.levelUniqueNameToLevelNumber(lun);
            if (this.logger.isOn(LogLevel.TRACE)) {
                this.logger.log(LogLevel.TRACE, LOG_MSG_CONVERTED_LUN + lun + LOG_MSG_TO_LEVEL_NUMBER + createdLevelNum);
            }
        }
        ICube cube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        boolean useMDX = false;
        IDataSource dataSource = execEnv.getDataSource();
        if (dataSource != null) {
            boolean bl = useMDX = cube != null && dataSource.getCapabilities().isSupported("useMDXToFetchMembers") && !restrictions.contains(RestrictionType.MEMBERSEARCH) && !restrictions.contains(RestrictionType.PPDS_CODES) && !restrictions.contains(RestrictionType.FROM) && !restrictions.contains(RestrictionType.SIZE) && !cube.getDimension(dun).isMeasuresDimension();
        }
        if (!useMDX) {
            MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Members);
            query.addRestriction(RestrictionType.CATALOG, catalogName);
            query.addRestriction(RestrictionType.SCHEMA, schemaName);
            query.addRestriction(RestrictionType.CUBE, cubeName);
            query.addRestriction(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
            query.addRestriction(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
            if (aliases != null) {
                query.setAliases(aliases);
            }
            if (createdLevelNum != null) {
                query.addRestriction(RestrictionType.LEVEL_NUMBER, String.valueOf(createdLevelNum));
            } else {
                query.addRestriction(RestrictionType.LEVEL_UNIQUE_NAME, lun);
            }
            if (levelNumber != null) {
                query.addRestriction(RestrictionType.LEVEL_NUMBER, levelNumber.toString());
            }
            query.addRestriction(RestrictionType.MEMBER_UNIQUE_NAME, mun);
            if (treeOps != null) {
                query.addRestriction(RestrictionType.TREEOP, MDDSMetadataProvider.convertTreeOp(treeOps));
            }
            if (restrictions.contains(RestrictionType.PPDS_CODES)) {
                Collection ppdsCods = (Collection)restrictions.getValueOf(RestrictionType.PPDS_CODES);
                query.setPPDSCodeConstraints(ppdsCods);
            }
            if (restrictions.contains(RestrictionType.MEMBERSEARCH)) {
                MASearchCriteria searchCriteria = (MASearchCriteria)restrictions.getValueOf(RestrictionType.MEMBERSEARCH);
                query.setMAMemberSearchCriteria(searchCriteria);
            }
            this.setResultRange(restrictions, query);
            MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
            if (response == null) {
                throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
            }
            List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, MemberRecord.class);
            return records;
        }
        if (this.logger.isOn(LogLevel.TRACE)) {
            this.logger.log(LogLevel.TRACE, "Using MDX to process metadata request: " + restrictions.toString());
        }
        MemberQueryTM1 memberQuery = (MemberQueryTM1)CustomQueryFactory.createCustomQuery((String)"MemberQueryTM1", (ICube)cube);
        if (mun != null && mun.length() != 0) {
            memberQuery.setMemberUName(mun);
            if (treeOps != null) {
                memberQuery.setOperations((EnumSet)treeOps.clone());
            }
        } else if (createdLevelNum == null && lun != null && lun.length() != 0) {
            memberQuery.setLevelName(lun);
        } else if (createdLevelNum == null) {
            memberQuery.setHierarchyName(hun);
        } else {
            memberQuery.setHierarchyName(hun);
            memberQuery.setLevelNumber(createdLevelNum.toString());
        }
        if (restrictions.contains(RestrictionType.ROOT_MEMBERS)) {
            memberQuery.setIsRootMemberQuery();
            memberQuery.setHierarchyName(hun);
        }
        memberQuery.setAliasTable(this.getAliasTableEntries(cube, execEnv));
        memberQuery.setMeasuresHierarchy(cube.getMeasuresHierarchy().getUniqueName());
        String dimProperties = (String)restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES);
        if (dimProperties == null) {
            dimProperties = "";
        }
        List<String> filteredDimProperties = this.filterDefaultProperties(dimProperties);
        memberQuery.setDimensionProperties(this.buildDimensionProperties(filteredDimProperties));
        IHybridResultSet queryResult = null;
        XDataContext dataContext = execEnv.pushDataContext();
        try {
            List<MemberRecord> list;
            block33: {
                queryResult = memberQuery.execute(dataContext);
                XIterator membersIterator = null;
                try {
                    membersIterator = queryResult.getAxisIterator(0);
                    list = this.getMemberRecords(membersIterator, cube.getName(), dun, hun, filteredDimProperties);
                    if (null == membersIterator) break block33;
                }
                catch (Throwable throwable) {
                    if (null != membersIterator) {
                        membersIterator.release();
                    }
                    throw throwable;
                }
                membersIterator.release();
            }
            return list;
        }
        finally {
            execEnv.popDataContext(dataContext);
            if (null != queryResult) {
                queryResult.release();
            }
        }
    }

    private List<String> filterDefaultProperties(String dimProperties) {
        String[] tokens = dimProperties.split(COMMA);
        ArrayList<String> filteredProperties = new ArrayList<String>();
        for (String tempProp : tokens) {
            String prop = tempProp.trim();
            if (prop.equalsIgnoreCase("PARENT_LEVEL") || prop.equalsIgnoreCase("DESCRIPTION") || prop.equalsIgnoreCase("PARENT_UNIQUE_NAME") || prop.equalsIgnoreCase("MEMBER_UNIQUE_NAME") || prop.equalsIgnoreCase("CAPTION") || prop.equalsIgnoreCase("LEVEL_NUMBER") || prop.equalsIgnoreCase("MEMBER_CAPTION") || prop.equalsIgnoreCase("MEMBER_TYPE")) continue;
            filteredProperties.add(prop);
        }
        return filteredProperties;
    }

    private String buildDimensionProperties(List<String> dimProperties) {
        MDXDimensionProperties props = new MDXDimensionProperties();
        for (String prop : dimProperties) {
            if (prop.isEmpty()) continue;
            props.addMemberProperty(prop.trim());
        }
        props.addMemberProperty("DESCRIPTION");
        props.addMemberProperty("MEMBER_TYPE");
        return props.dumpFormattedXMLQueryString();
    }

    private List<MemberRecord> getMemberRecords(XIterator membersIterator, String cubeName, String dimensionName, String hierarchyName, List<String> requestedProperties) {
        ITuple aTuple = (ITuple)membersIterator.next();
        ArrayList<MemberRecord> result = new ArrayList<MemberRecord>();
        String intCubeName = MetadataRecord.internalizeString((String)cubeName);
        String intDimName = MetadataRecord.internalizeString((String)dimensionName);
        String intHierName = MetadataRecord.internalizeString((String)hierarchyName);
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        while (aTuple != null) {
            IMember member = aTuple.getMember(0);
            result.add(this.convertMetadataMember(member, intCubeName, intDimName, intHierName, requestedProperties, execEnv));
            aTuple = (ITuple)membersIterator.next();
        }
        return result;
    }

    private MemberRecord convertMetadataMember(IMember member, String cubeName, String dimensionName, String hierarchyName, List<String> requestedProperties, IExecutionEnvironment execEnv) {
        MemberRecord memberRecord = new MemberRecord();
        memberRecord.setInternalizedName(MetadataRecord.internalizeString((String)member.getName(), (IExecutionEnvironment)execEnv));
        memberRecord.setInternalizedCubeName(cubeName);
        memberRecord.setInternalizedUniqueName(MetadataRecord.internalizeString((String)member.getUniqueName(), (IExecutionEnvironment)execEnv));
        memberRecord.setCaption(member.getCaptionValue().toString());
        memberRecord.setChildCardinality(member.getChildrenCardinality());
        memberRecord.setDescription(member.getDescription());
        memberRecord.setInternalizedParentUniqueName(MetadataRecord.internalizeString((String)member.getParentUniqueName(), (IExecutionEnvironment)execEnv));
        memberRecord.setParentLevelNumber(member.getParentLevelNumber());
        memberRecord.setUniqueId(member.getUniqueName());
        memberRecord.setRollupType(member.getRollupType());
        memberRecord.setType(member.getType());
        ILevel level = member.getLevel();
        memberRecord.setLevelNumber(level.getIndex());
        memberRecord.setInternalizedLevelUniqueName(MetadataRecord.internalizeString((String)level.getUniqueName(), (IExecutionEnvironment)execEnv));
        if (memberRecord.getLevelNumber() == 0) {
            memberRecord.setParentLevelNumber(-1);
            memberRecord.setParentCount(0);
        } else {
            memberRecord.setParentCount(1);
        }
        if (dimensionName != null) {
            memberRecord.setInternalizedDimensionUniqueName(dimensionName);
        } else {
            String dimName = member.getDimension().getUniqueName();
            memberRecord.setDimensionUniqueName(dimName);
        }
        if (hierarchyName != null) {
            memberRecord.setInternalizedHierarchyUniqueName(hierarchyName);
        } else {
            memberRecord.setHierarchyUniqueName(member.getHierarchy().getUniqueName());
        }
        if (requestedProperties != null) {
            for (String propertyName : requestedProperties) {
                ValueField field;
                Object value = member.getProperty(propertyName);
                if (value == null) continue;
                Class<?> valueClazz = value.getClass();
                if (value instanceof Value) {
                    field = new ValueField(propertyName, (Value)value);
                } else if (valueClazz.equals(String.class)) {
                    field = new StringField(propertyName, (String)value);
                } else if (valueClazz.equals(Boolean.class)) {
                    field = new BooleanField(propertyName, ((Boolean)value).booleanValue());
                } else if (valueClazz.equals(Byte.class)) {
                    field = new ByteField(propertyName, ((Byte)value).byteValue());
                } else if (valueClazz.equals(Double.class)) {
                    field = new DoubleField(propertyName, ((Double)value).doubleValue());
                } else if (valueClazz.equals(Float.class)) {
                    field = new FloatField(propertyName, ((Float)value).floatValue());
                } else if (valueClazz.equals(Integer.class)) {
                    field = new IntegerField(propertyName, ((Integer)value).intValue());
                } else if (valueClazz.equals(Long.class)) {
                    field = new LongField(propertyName, ((Long)value).longValue());
                } else {
                    throw new IllegalArgumentException("Unsupported data type");
                }
                memberRecord.addDynamicField((IDynamicField)field);
            }
        }
        return memberRecord;
    }

    public List<NamedSetRecord> getNamedSets(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "NamedSets are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    public List<HierarchyNamedSetRecord> getHierarchyNamedSets(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Hierarchy named sets are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    public List<MemberRecord> getNamedSetMembers(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Named sets are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Named set LUNs are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    public List<PropertyRecord> getProperties(ExecutionEnvironment execEnv, MDDSConnection connection, IRestrictions restrictions) {
        EnumSet missingTypes = restrictions.contains(EnumSet.of(RestrictionType.CUBE));
        if (missingTypes != null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, ERR_MSG_MISSING_REQUIRED_RESTRICTION + missingTypes.toString() + " are missing for Properties metadata request.");
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missingTypes.toString());
        }
        MDDSMetadataQuery query = new MDDSMetadataQuery(execEnv, this.connectionParameters, MDDSMetadataQuery.QueryType.Attributes);
        if (restrictions.contains(RestrictionType.ALIASES)) {
            Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
            query.setAliases(aliases);
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        query.addRestriction(RestrictionType.CATALOG, catalogName);
        String schemaName = (String)restrictions.getValueOf(RestrictionType.SCHEMA);
        query.addRestriction(RestrictionType.SCHEMA, schemaName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        query.addRestriction(RestrictionType.CUBE, cubeName);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        query.addRestriction(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        query.addRestriction(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        if (MDDSMetadataProvider.isCreatedLevel(lun)) {
            if (this.logger.isOn(LogLevel.TRACE)) {
                this.logger.log(LogLevel.TRACE, "Level properties are not support for generated level " + lun);
            }
            LinkedList<PropertyRecord> records = new LinkedList<PropertyRecord>();
            return records;
        }
        query.addRestriction(RestrictionType.LEVEL_UNIQUE_NAME, lun);
        String aun = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        query.addRestriction(RestrictionType.PROPERTY, aun);
        this.setResultRange(restrictions, query);
        MetadataResponse response = this.execute(execEnv, connection, query, catalogName, cubeName);
        if (response == null) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
        }
        List records = CollectionCast.downcast(response.getRecords(), MetadataRecord.class, PropertyRecord.class);
        return records;
    }

    public List<VariableRecord> getVariables(IRestrictions restrictions) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Variables are not supported for PowerCube/TM1 data source.");
        }
        return Collections.emptyList();
    }

    private void populateParentChildLevelsForDimension(MDDSConnection connection, String catalogName, String cubeName, String dun) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Populating parent-child levels for dimension " + dun);
        }
        MetadataRestriction rest = new MetadataRestriction();
        if (catalogName != null && catalogName.length() > 0) {
            rest.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        rest.add(RestrictionType.CUBE, (Object)cubeName);
        rest.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dun);
        List mrs = this.getHierarchies((IRestrictions)rest);
        LinkedHashMap<String, List<LevelRecord>> allLevels = new LinkedHashMap<String, List<LevelRecord>>();
        ParentChildLevelsCache pcLevelsCache = connection.getPCLevelsCache();
        for (HierarchyRecord hr : mrs) {
            if (!hr.isParentChild()) continue;
            List<LevelRecord> levels = pcLevelsCache.getLevelsForHierarchy(hr.getUniqueName());
            if (levels == null) {
                levels = this.processParentChildHierarchy(connection, cubeName, hr);
            }
            allLevels.put(hr.getUniqueName(), levels);
        }
        pcLevelsCache.add(dun, allLevels);
    }

    private void populateParentChildLevelsForHierarchy(MDDSConnection connection, String catalogName, String cubeName, String dun, String hun) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Populating parent-child levels for hierarchy " + hun);
        }
        MetadataRestriction rest = new MetadataRestriction();
        if (catalogName != null && catalogName.length() > 0) {
            rest.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        rest.add(RestrictionType.CUBE, (Object)cubeName);
        rest.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dun);
        rest.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hun);
        List hrs = this.getHierarchies((IRestrictions)rest);
        HierarchyRecord hr = (HierarchyRecord)hrs.get(0);
        if (hr.isParentChild()) {
            List<LevelRecord> records = this.processParentChildHierarchy(connection, cubeName, hr);
            connection.getPCLevelsCache().add(hun, records);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LevelRecord> processParentChildHierarchy(MDDSConnection connection, String cubeName, HierarchyRecord record) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Processing parent child hierarchy " + record.getUniqueName());
        }
        ProviderDataQuery query = null;
        String sEncodedHUN = OptionsXMLProcessor.xmlEncode((String)record.getUniqueName());
        String sEncodedCubeName = OptionsXMLProcessor.xmlEncode((String)cubeName);
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Encoded Hierarchy " + sEncodedHUN);
        }
        try {
            query = new GetHierarchyDepthQuery(connection, sEncodedCubeName, sEncodedHUN);
            int maxLevelNumber = ((GetHierarchyDepthQuery)query).getDepth();
            List<LevelRecord> list = this.generateLevels(record, maxLevelNumber);
            return list;
        }
        finally {
            if (query != null) {
                query.release();
            }
        }
    }

    private List<LevelRecord> generateLevels(HierarchyRecord record, int maxLevelNumber) {
        LinkedList<LevelRecord> levels = new LinkedList<LevelRecord>();
        for (int i = 0; i <= maxLevelNumber; ++i) {
            LevelRecord lr = new LevelRecord();
            String name = LEVEL_NAME_PREFIX + i;
            String hun = record.getUniqueName();
            if ("".equals(MDDSMetadataProvider.getName(hun))) {
                hun = hun.substring(0, hun.length() - 2);
            }
            String uniqueName = UniqueNameGenerator.appendUniqueName((String)hun, (String)name);
            lr.setCaption(name);
            lr.setName(name);
            lr.setUniqueId(name);
            String catalogName = record.getCatalogName();
            if (catalogName != null && catalogName.length() > 0) {
                lr.setCatalogName(catalogName);
            }
            lr.setCubeName(record.getCubeName());
            lr.setDimensionUniqueName(record.getDimensionUniqueName());
            lr.setHidden(Boolean.valueOf(true));
            lr.setHierarchyUniqueName(record.getUniqueName());
            lr.setUniqueName(uniqueName);
            lr.setLevelNumber(i);
            lr.setUniqueMemberNames(false);
            levels.add(lr);
        }
        return levels;
    }

    public static String getName(String uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        int startIndex = uniqueName.lastIndexOf(BRACE);
        int endIndex = uniqueName.lastIndexOf("]");
        if (startIndex > 0 && endIndex > 0 && endIndex > startIndex) {
            if (endIndex == startIndex + 1) {
                return "";
            }
            String name = uniqueName.substring(startIndex + 1, endIndex);
            return name;
        }
        return null;
    }

    public static boolean isCreatedLevel(String lun) {
        String levelName = MDDSMetadataProvider.getName(lun);
        if (levelName == null) {
            return false;
        }
        return levelName.matches(FAKED_LEVEL_PATTERN);
    }

    public static int levelUniqueNameToLevelNumber(String lun) {
        String levelName = MDDSMetadataProvider.getName(lun);
        if (levelName == null) {
            return -1;
        }
        if (!MDDSMetadataProvider.isCreatedLevel(lun)) {
            return -1;
        }
        String levelNumber = levelName.substring(LEVEL_NAME_PREFIX.length());
        return Integer.valueOf(levelNumber);
    }

    private DateTimeValue getSchemaUpdateDate(String cubeName) {
        if (this.logger.isOn(LogLevel.INFO)) {
            this.logger.log(LogLevel.INFO, "Check cube schema updated date for cube " + cubeName);
        }
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CUBE, (Object)cubeName);
        List cubes = this.getCubes((IRestrictions)restrictions);
        CubeRecord record = (CubeRecord)cubes.get(0);
        return record.getSchemaUpdateDate();
    }

    private static void resizeCollection(Collection<?> collection, int size) {
        if (collection == null || collection.size() <= size) {
            return;
        }
        if (size == 0) {
            collection.clear();
        } else {
            int count = collection.size() - size;
            for (int i = 0; i < count; ++i) {
                collection.remove(collection.size() - 1);
            }
        }
    }

    private void setResultRange(IRestrictions restrictions, MDDSMetadataQuery query) {
        Integer from = 0;
        Integer count = 0;
        if (restrictions.contains(RestrictionType.FROM)) {
            from = (Integer)restrictions.getValueOf(RestrictionType.FROM);
        }
        if (restrictions.contains(RestrictionType.SIZE)) {
            count = (Integer)restrictions.getValueOf(RestrictionType.SIZE);
        }
        query.setResultRange(from, count);
    }

    public static String convertTreeOp(EnumSet<TreeOperatorEnum> ops) {
        String value = null;
        if (ops != null) {
            for (TreeOperatorEnum op : ops) {
                if (value == null) {
                    value = op.toString();
                    continue;
                }
                value = value + MDDS_TREE_OPERATOR_OR + op.toString();
            }
        }
        return value;
    }

    /*
     * Loose catch block
     */
    private MetadataResponse execute(ExecutionEnvironment execEnv, MDDSConnection connection, MDDSMetadataQuery mddsQuery, String catalogName, String cubeName) {
        String mddsQueryStr = mddsQuery.getQueryString(false);
        if (this.logger.isOn(LogLevel.TRACE)) {
            this.logger.log(LogLevel.TRACE, mddsQuery.getQueryString(true));
        }
        MetadataRecordFactory factory = new MetadataRecordFactory(mddsQuery.getRecordType(), catalogName, cubeName);
        MetadataResponseParser parser = new MetadataResponseParser(this.mdQueryArgs.getDesignLocale(), factory);
        QFWConnection qfwconn = connection.getConnection();
        MDDSCancelListener cancelListener = new MDDSCancelListener(qfwconn, execEnv, (QueryArguments)this.mdQueryArgs, this.connectionParameters);
        execEnv.getCancelManager().addCancelHandler((ICancelable)cancelListener);
        QFWQuery query = null;
        try {
            query = qfwconn.createQuery(((RequestEnvironment)execEnv.getRequestEnvironment()).getProductLocale());
            try {
                query.execute(mddsQueryStr);
            }
            catch (QFWException ex) {
                query.release();
                connection.checkForInvalidTM1Connection(ex);
                throw new MDDSException(MDDSMessageKeys.MET_MDDS_QUERY_ERROR, ex, ex.getLocalizedMessage());
            }
            catch (Throwable ex) {
                query.release();
                throw new MDDSException(MDDSMessageKeys.MET_MDDS_QUERY_ERROR, ex, ex.getLocalizedMessage());
            }
            connection.setCubeLoaded(true);
            ByteArrayOutputStream ostream = null;
            InputStream response = null;
            try {
                response = query.getResponse();
                if (this.logger.isOn(LogLevel.TRACE)) {
                    ostream = new ByteArrayOutputStream();
                    response = new ForwardingInputStream(response, (OutputStream)new BufferedOutputStream(ostream));
                }
                MetadataResponse metadataResponse = parser.parse(response);
                return metadataResponse;
            }
            catch (Throwable t) {
                MDDSLogger.getLogger("Metadata", LogLevel.ERROR).log(LogLevel.ERROR, "Unexpected response parsing failure: ", t);
                throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE, t);
            }
            finally {
                if (this.logger.isOn(LogLevel.TRACE) && ostream != null) {
                    this.logger.log(LogLevel.TRACE, ((Object)ostream).toString());
                    try {
                        ((OutputStream)ostream).close();
                    }
                    catch (IOException e) {
                        this.logger.log(LogLevel.WARN, "Failed to close output stream for logging.");
                    }
                }
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        this.logger.log(LogLevel.WARN, "Failed to close MDDS metadata response stream.");
                    }
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            execEnv.getCancelManager().removeCancelHandler((ICancelable)cancelListener);
            if (query != null) {
                query.release();
            }
            ((Object)((Object)this)).hashCode();
        }
    }

    public void releaseImpl() {
        if (this.logger.isOn()) {
            this.logger.log("Releasing XQE connection.");
        }
    }

    public List<MemberRecord> getHierarchyRootMembers(IRestrictions restrictions) {
        List levels = this.getLevels(restrictions);
        restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)((LevelRecord)levels.get(0)).getUniqueName());
        restrictions.add(RestrictionType.ROOT_MEMBERS, (Object)true);
        List rootMembers = this.getMembers(restrictions);
        return rootMembers;
    }

    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public SALContext getMetadataQueryContext(ExecutionEnvironment theEexecutionEnvironment, MDDSConnection connection, String userId, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        String securityContext = null;
        ConnectionParameters connParams = connection.getConnectionParameters();
        String dim = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        TM1UserNameParameter userNameParam = (TM1UserNameParameter)connParams.get(TM1UserNameParameter.class);
        String uId = null;
        if (userNameParam != null) {
            uId = (String)userNameParam.value();
        }
        if (uId == null) {
            CAMPassportParameter paramCamPassport = (CAMPassportParameter)connParams.get(CAMPassportParameter.class);
            uId = (String)paramCamPassport.value();
        }
        String userGroupList = uId;
        if (connection.serverHasUserGroups()) {
            userGroupList = (String)MDDSConnection.getTM1UserGroups(connParams, connection).value();
        }
        securityContext = securityContextMode == 3 ? (dim == null ? uId : (userGroupList != null ? userGroupList : uId)) : (securityContextMode == 2 ? (userGroupList != null ? userGroupList : uId) : uId);
        return new SALContext(securityContext, null, null);
    }
}

