/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.connection;

import com.cognos.xqe.data.model.ICAMCryptoSignon;
import com.cognos.xqe.data.model.ICombinedSignon;
import com.cognos.xqe.data.model.ICubePasswordSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUserClassIDSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.NamespaceParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProductLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.connection.CubePasswordParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.DataSourceTypeParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.ModelPathParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.ReadCacheSizeParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.RequestIdParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1AdminHostParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1PasswordParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1ServerNameParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1ServerSecurityModeEnum;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1UserNameParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.UnixPathParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.WinPathParameter;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Element;

public final class ConnectionParameterHelper {
    private static final String CS_WIN_PATH = "WIN_PATH";
    private static final String CS_UNIX_PATH = "UNIX_PATH";
    public static final String DOM_REQUEST_ID = "requestID";
    private static final String DOM_VALUE = "value";
    private static final String DOM_CONNECTION = "connection";
    private static final String DOM_CUBE_PASSWORD = "cubePassword";
    private static final String DOM_PASSWORD = "password";
    private static final String DOM_USERNAME = "username";
    private static final String DOM_DATA_SOURCE_TYPE = "dataSourceType";
    private static final String DOM_CATALOG = "catalog";
    private static final String DOM_CUBE = "cube";
    private static final String DOM_CAM_PASSPORT = "CAMPassport";
    private static final String DOM_SSO_DELEGATION_HANDLE = "SSODelegationHandle";
    private static final String DOM_PROD_LOCALE = "productLocale";
    private static final String DOM_RUN_LOCALE = "runLocale";
    private static final String DOM_WIN_DATA_SOURCE = "winDataSource";
    private static final String DOM_UNIX_DATA_SOURCE = "unixDataSource";
    private static final String DOM_READ_CACHE_SIZE = "readCacheSize";
    private static final String DOM_USERCLASSIDS = "userClassIds";
    private static final String DOM_TM1_ADMIN_HOST = "TM1AdminHost";
    private static final String DOM_TM1_SERVER_NAME = "TM1ServerName";
    private static final String DOM_NAMESPACE = "namespace";
    private static final String DOM_DATA_SOURCE = "dataSource";
    private static final String DOM_MODEL_PATH = "modelPath";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").indexOf("Windows") >= 0;

    public static ConnectionParameters constructConnectionParameters(IExecutionEnvironment env, Element connectionElement, IDataSource dataSource, Locale runLocale, boolean skipRequestId) {
        ConnectionParameters params = new ConnectionParameters();
        ConnectionParameterHelper.resolveMetadataProperties(dataSource, params);
        ConnectionParameterHelper.resolveConnectionString(dataSource, params);
        if (connectionElement != null) {
            ConnectionParameterHelper.resolveConnectionElement(dataSource, connectionElement, params);
        }
        ConnectionParameterHelper.resolveLocales(env, runLocale, params);
        CAMPassportParameter.resolveCAMPassport((IExecutionEnvironment)env, (ConnectionParameters)params, (boolean)false);
        if (!skipRequestId) {
            ConnectionParameterHelper.resolveRequestID(env, params);
        }
        ConnectionParameterHelper.resolveModelPath(dataSource, env, params);
        params.put((IConnectionParameter)new DataSourceParameter(dataSource));
        boolean bNeedToResolveSignon = true;
        if ("TM".equals(dataSource.getType())) {
            String namespace;
            String sServer;
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            String sAdmin = (String)params.valueOf(TM1AdminHostParameter.class, String.class);
            TM1ServerSecurityModeEnum serverMode = MDDSConnection.getStaticTM1ServerSecurityMode(sAdmin, sServer = (String)params.valueOf(TM1ServerNameParameter.class, String.class));
            if (serverMode.hasTM1Security() && !serverMode.mightRequireWIA()) {
                bNeedToResolveSignon = false;
                dsConnection.setConnectionParameter("SkipSignons", (Object)true);
            }
            if ((namespace = dsConnection.getNamespace()) != null && namespace.length() > 0) {
                params.put((IConnectionParameter)new NamespaceParameter(namespace));
            }
        }
        if (bNeedToResolveSignon) {
            ConnectionParameterHelper.resolveSignon(dataSource.getType(), dataSource.getDataSourceConnection().getSignon(), params, env);
        }
        return params;
    }

    private static void resolveMetadataProperties(IDataSource dataSource, ConnectionParameters params) {
        Object catalogName;
        Map properties = dataSource.getMetadataProperties();
        Object cubeName = properties.get(DOM_CUBE);
        if (cubeName != null) {
            if ("PC".equals(dataSource.getType())) {
                params.put((IConnectionParameter)new CubeParameter(String.valueOf(cubeName), false));
            } else {
                params.put((IConnectionParameter)new CubeParameter(String.valueOf(cubeName), true));
            }
        }
        if ((catalogName = properties.get(DOM_CATALOG)) != null) {
            params.put((IConnectionParameter)new CatalogParameter(String.valueOf(catalogName), false));
        }
    }

    private static void resolveRequestID(IExecutionEnvironment env, ConnectionParameters params) {
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        if (env.getMultiRequestContext() == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestIdMissing);
        }
        String requestId = env.getRequestID();
        params.put((IConnectionParameter)new RequestIdParameter(requestId));
    }

    private static void resolveLocales(IExecutionEnvironment env, Locale runLocale, ConnectionParameters params) {
        Locale productLocale;
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        if (runLocale != null) {
            params.put((IConnectionParameter)new RunLocaleParameter(runLocale, false));
        }
        if ((productLocale = env.getRequestEnvironment().getProductLocale()) != null) {
            params.put((IConnectionParameter)new ProductLocaleParameter(productLocale, false));
        }
    }

    private static void resolveSignon(String providerType, IDataSourceConnectionSignon signon, ConnectionParameters params, IExecutionEnvironment execEnv) {
        if (null != signon) {
            boolean isPowerCube = "PC".equals(providerType);
            if (signon.getType() == IDataSourceConnectionSignon.SignonType.COMBINED) {
                IDataSourceConnectionSignon[] signons;
                for (IDataSourceConnectionSignon aSignon : signons = ((ICombinedSignon)signon).getSignons()) {
                    ConnectionParameterHelper.resolveSignon(providerType, aSignon, params, execEnv);
                }
            } else if (!isPowerCube && signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                IUsernamePasswordSignon userPasswordSignon = (IUsernamePasswordSignon)signon;
                params.put((IConnectionParameter)new TM1UserNameParameter(userPasswordSignon.getUserName()));
                params.put((IConnectionParameter)new TM1PasswordParameter((IEncryptedObject<String>)userPasswordSignon.getPassword()));
            } else if (!isPowerCube && signon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                ICAMCryptoSignon camCryptoSignon = (ICAMCryptoSignon)signon;
                params.put((IConnectionParameter)new CAMCryptoHandleParameter(camCryptoSignon.getCryptoHandle()));
            } else if (isPowerCube && signon.getType() == IDataSourceConnectionSignon.SignonType.CUBE_PASSWORD) {
                ICubePasswordSignon cubePasswordSignon = (ICubePasswordSignon)signon;
                params.put((IConnectionParameter)new CubePasswordParameter((IEncryptedObject<String>)cubePasswordSignon.getPassword()));
            } else if (isPowerCube && signon.getType() == IDataSourceConnectionSignon.SignonType.USER_CLASSID) {
                IUserClassIDSignon userClassIDSignon = (IUserClassIDSignon)signon;
                String userClassIDs = userClassIDSignon.getUserClassIDS();
                params.put((IConnectionParameter)new UserClassIDsParameter(userClassIDs));
            } else {
                throw new MDDSException(MDDSMessageKeys.CON_CONNECT_FAILURE, "Unsupported signon type: " + signon.getType());
            }
        }
    }

    private static void resolveConnectionString(IDataSource dataSource, final ConnectionParameters params) {
        String connectionString = dataSource.getDataSourceConnection().getConnectionString(null);
        if (connectionString != null) {
            ConnectionStringParser.parse((String)connectionString, (ConnectionStringParser.TokenHandler)new ConnectionStringParser.TokenHandler(){
                private ProviderManager.ProviderInfo providerInfo = null;

                public void onSimpleToken(String value) {
                    if (value.length() == 2 && (value.equals("PC") || value.equals("TM"))) {
                        this.providerInfo = ProviderManager.getInstance().getProviderInfo(value);
                        if (this.providerInfo != null) {
                            params.put((IConnectionParameter)new DataSourceTypeParameter(this.providerInfo.getProviderName()));
                        }
                    }
                }

                public void onKeyValueToken(String key, String value) {
                    if (this.providerInfo != null) {
                        if (key.equals(ConnectionParameterHelper.CS_WIN_PATH) && IS_WINDOWS) {
                            params.put((IConnectionParameter)new WinPathParameter(value));
                        } else if (key.equals(ConnectionParameterHelper.CS_UNIX_PATH) && !IS_WINDOWS) {
                            params.put((IConnectionParameter)new UnixPathParameter(value));
                        } else if (key.equals(ConnectionParameterHelper.DOM_READ_CACHE_SIZE)) {
                            params.put((IConnectionParameter)new ReadCacheSizeParameter(value));
                        } else if (key.equals(ConnectionParameterHelper.DOM_TM1_ADMIN_HOST)) {
                            params.put((IConnectionParameter)new TM1AdminHostParameter(value));
                        } else if (key.equals(ConnectionParameterHelper.DOM_TM1_SERVER_NAME)) {
                            params.put((IConnectionParameter)new TM1ServerNameParameter(value));
                        }
                    }
                }
            });
        }
    }

    private static void resolveConnectionElement(IDataSource dataSource, Element connectionElement, ConnectionParameters params) {
        if (DOM_CONNECTION.equals(connectionElement.getName())) {
            Iterator itr = connectionElement.elementIterator();
            while (itr.hasNext()) {
                Element element = (Element)itr.next();
                String name = element.getName();
                String value = element.attributeValue(DOM_VALUE);
                if (name == null || value == null) continue;
                if (name.equals(DOM_DATA_SOURCE) && !params.contains(ModelPathParameter.class)) {
                    if ("TM".equals(dataSource.getType())) {
                        params.put((IConnectionParameter)new ModelPathParameter(value, true));
                        continue;
                    }
                    params.put((IConnectionParameter)new ModelPathParameter(value, false));
                    continue;
                }
                if (name.equals(DOM_CATALOG) && !params.contains(CatalogParameter.class)) {
                    params.put((IConnectionParameter)new CatalogParameter(value, false));
                    continue;
                }
                if (name.equals(DOM_CUBE) && !params.contains(CubeParameter.class)) {
                    if ("PC".equals(dataSource.getType())) {
                        params.put((IConnectionParameter)new CubeParameter(value, false));
                        continue;
                    }
                    params.put((IConnectionParameter)new CubeParameter(value, true));
                    continue;
                }
                if (name.equals(DOM_CAM_PASSPORT) && !params.contains(CAMPassportParameter.class)) {
                    params.put((IConnectionParameter)new CAMPassportParameter(value, false));
                    continue;
                }
                if (name.equals(DOM_DATA_SOURCE_TYPE) && !params.contains(DataSourceTypeParameter.class)) {
                    params.put((IConnectionParameter)new DataSourceTypeParameter(value));
                    continue;
                }
                if (name.equals(DOM_PROD_LOCALE) && !params.contains(ProductLocaleParameter.class)) {
                    params.put((IConnectionParameter)new ProductLocaleParameter(LocaleConverter.strToLocale((String)value), false));
                    continue;
                }
                if (name.equals(DOM_RUN_LOCALE) && !params.contains(RunLocaleParameter.class)) {
                    params.put((IConnectionParameter)new RunLocaleParameter(LocaleConverter.strToLocale((String)value), false));
                    continue;
                }
                if (name.equals(DOM_WIN_DATA_SOURCE) && !params.contains(WinPathParameter.class) && IS_WINDOWS) {
                    params.put((IConnectionParameter)new WinPathParameter(value));
                    continue;
                }
                if (name.equals(DOM_UNIX_DATA_SOURCE) && !params.contains(UnixPathParameter.class) && !IS_WINDOWS) {
                    params.put((IConnectionParameter)new UnixPathParameter(value));
                    continue;
                }
                if (name.equals(DOM_TM1_ADMIN_HOST) && !params.contains(TM1AdminHostParameter.class)) {
                    params.put((IConnectionParameter)new TM1AdminHostParameter(value));
                    continue;
                }
                if (!name.equals(DOM_TM1_SERVER_NAME) || params.contains(TM1ServerNameParameter.class)) continue;
                params.put((IConnectionParameter)new TM1ServerNameParameter(value));
            }
        }
    }

    private static void resolveModelPath(IDataSource dataSource, IExecutionEnvironment env, ConnectionParameters params) {
        if (!params.contains(ModelPathParameter.class)) {
            if (env == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            String modelPath = env.getRequestEnvironment().getModelPath();
            if (modelPath != null) {
                if ("TM".equals(dataSource.getType())) {
                    params.put((IConnectionParameter)new ModelPathParameter(modelPath, true));
                } else {
                    params.put((IConnectionParameter)new ModelPathParameter(modelPath, false));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(ConnectionParameters params, StringBuilder buffer, boolean forLogging) throws Exception {
        try (XMLStreamWriter writer = null;){
            StringWriter strWriter = new StringWriter();
            writer = StaxUtil.createXMLStreamWriter((Writer)strWriter);
            ConnectionParameterHelper.writeXML(params, writer, forLogging);
            writer.flush();
            buffer.append(strWriter.getBuffer());
        }
    }

    public static void writeXML(ConnectionParameters params, XMLStreamWriter writer, boolean forLogging) throws XMLStreamException {
        writer.writeStartElement(DOM_CONNECTION);
        for (IConnectionParameter param : params) {
            Class<?> paramType = param.getClass();
            Object value = param.value();
            if (null == value) continue;
            if (value instanceof IEncryptedObject) {
                value = ((IEncryptedObject)value).decrypt();
            }
            if (forLogging && !param.isLoggable()) {
                value = "*****";
            }
            if (ModelPathParameter.class == paramType) {
                writer.writeEmptyElement(DOM_MODEL_PATH);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (DataSourceTypeParameter.class == paramType) {
                writer.writeEmptyElement(DOM_DATA_SOURCE_TYPE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (WinPathParameter.class == paramType) {
                writer.writeEmptyElement(DOM_WIN_DATA_SOURCE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (UnixPathParameter.class == paramType) {
                writer.writeEmptyElement(DOM_UNIX_DATA_SOURCE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (TM1AdminHostParameter.class == paramType) {
                writer.writeEmptyElement(DOM_TM1_ADMIN_HOST);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (TM1ServerNameParameter.class == paramType) {
                writer.writeEmptyElement(DOM_TM1_SERVER_NAME);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (ReadCacheSizeParameter.class == paramType) {
                writer.writeEmptyElement(DOM_READ_CACHE_SIZE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CAMPassportParameter.class == paramType) {
                writer.writeEmptyElement(DOM_CAM_PASSPORT);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CAMCryptoHandleParameter.class == paramType) {
                writer.writeEmptyElement(DOM_SSO_DELEGATION_HANDLE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (UserClassIDsParameter.class == paramType) {
                writer.writeEmptyElement(DOM_USERCLASSIDS);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (RequestIdParameter.class == paramType) {
                writer.writeEmptyElement(DOM_REQUEST_ID);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (RunLocaleParameter.class == paramType) {
                writer.writeEmptyElement(DOM_RUN_LOCALE);
                writer.writeAttribute(DOM_VALUE, ConnectionParameterHelper.getNormalizedLocaleString((Locale)value));
                continue;
            }
            if (ProductLocaleParameter.class == paramType) {
                writer.writeEmptyElement(DOM_PROD_LOCALE);
                writer.writeAttribute(DOM_VALUE, ConnectionParameterHelper.getNormalizedLocaleString((Locale)value));
                continue;
            }
            if (TM1UserNameParameter.class == paramType) {
                writer.writeEmptyElement(DOM_USERNAME);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (TM1PasswordParameter.class == paramType) {
                writer.writeEmptyElement(DOM_PASSWORD);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CubePasswordParameter.class == paramType) {
                writer.writeEmptyElement(DOM_CUBE_PASSWORD);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CubeParameter.class == paramType) {
                writer.writeEmptyElement(DOM_CUBE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CatalogParameter.class == paramType) {
                writer.writeEmptyElement(DOM_CATALOG);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (NamespaceParameter.class != paramType) continue;
            writer.writeEmptyElement(DOM_NAMESPACE);
            writer.writeAttribute(DOM_VALUE, (String)value);
        }
        writer.writeEndElement();
    }

    private static String getNormalizedLocaleString(Locale locale) {
        if (locale != null) {
            return LocaleConverter.toString((Locale)locale).toLowerCase().replace("_", "-");
        }
        return null;
    }
}

