/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.connection;

import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.connection.PCSecurityContext;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.trace.LogLevel;

public class PCConnectionSelector
implements IConnectionSelector {
    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        boolean matches = false;
        DefaultConnection connection = (DefaultConnection)pooledConnection.getConnection();
        ConnectionParameters poolParameters = connection.getConnectionParameters();
        UserClassIDsParameter lhs = (UserClassIDsParameter)connectionParameters.get(UserClassIDsParameter.class);
        UserClassIDsParameter rhs = (UserClassIDsParameter)poolParameters.get(UserClassIDsParameter.class);
        if (lhs == null && rhs != null) {
            boolean partialMatch = poolParameters.matches(connectionParameters);
            if (partialMatch) {
                UserClassIDsParameter param = null;
                PCSecurityContext.PCSecurityModeEnum mode = PCSecurityContext.PCSecurityModeEnum.LDAP;
                Object[] ctx = connection.getContext();
                if (ctx != null) {
                    for (Object c : ctx) {
                        if (!(c instanceof PCSecurityContext)) continue;
                        mode = ((PCSecurityContext)c).getSecurityMode();
                    }
                }
                if ((param = MDDSConnection.getPCUserAccountAndUserClasses(connectionParameters, mode)).matches((IConnectionParameter)rhs)) {
                    matches = true;
                }
            }
        } else if (lhs != null) {
            matches = poolParameters.matches(connectionParameters);
            if (matches && null != rhs) {
                matches = lhs.matches((IConnectionParameter)rhs);
            }
        } else {
            matches = poolParameters.matches(connectionParameters);
        }
        if (!matches && MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
            StringBuilder builder = new StringBuilder("Cannot reuse PC connection due to connection parameters ");
            builder.append(connectionParameters);
            builder.append(" doesn't match with ");
            builder.append(connection.getConnectionParameters());
            MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder.toString());
        }
        if (matches) {
            return IConnectionSelector.ReturnCode.MATCH;
        }
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }
}

