/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata;

import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.connection.ConnectionParameterHelper;
import com.cognos.xqe.data.providers.olap.mdds.connection.RequestIdParameter;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataAttributes;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSUtils;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MDDSMetadataQuery {
    private static final String CONDITION_SUFFIX = "']";
    private static final String CONDITION_MIDDLE = "='";
    private static final String CONDITION_PREFIX = ".[@";
    private static final String PROPERTY_PREFIX = "./@";
    private static final String XML_ELEM_METADATA = "metadata";
    private static final String XML_ELEM_CONSTRAINTS = "constraints";
    private static final String XML_ELEM_CONSTRAINT = "constraint";
    private static final String XML_ELEM_PROVIDER_CONSTRAINTS = "providerConstraints";
    private static final String XML_ELEM_PROPERTY = "property";
    private static final String XML_ELEM_PROPERTIES = "properties";
    private static final String XML_ELEM_INCLUDE_CALC_MEMBERS = "includeCalculatedMembers";
    private static final String XML_ELEM_ALIASTABLEMAP = "aliasTableMap";
    private static final String XML_ELEM_ALIASTABLE = "aliasTable";
    private static final String XML_ATTR_NAME = "name";
    private static final String XML_ATTR_VALUE = "value";
    private static final String XML_ATTR_RETURN_SCHEMA = "returnSchema";
    private static final String XML_ATTR_RESULT_START = "resultStart";
    private static final String XML_ATTR_RESULT_COUNT = "resultCount";
    private static final String XML_ATTR_DEPTH = "depth";
    private static final String XML_ATTR_CLASS = "class";
    private static final String XML_ATTR_CONDITION = "condition";
    private static final String XML_ATTR_LANG = "lang";
    private static final String XML_ATTR_OPERATION = "Operation";
    private static final String XML_ATTR_OPERATION_OR = "OR";
    private static final String XML_ATTR_CASE_INSENSITIVE = "caseInsensitive";
    private static final String XML_ATTR_CONDITION_TYPE = "conditionType";
    private static final String XML_ATTR_OPERATION1 = "operation";
    private static EnumMap<RestrictionType, String> constraintsMap = new EnumMap(RestrictionType.class);
    private Map<Object, String> aliasMap = null;
    private final ConnectionParameters connectionParams;
    private final Map<String, String> constraints = new HashMap<String, String>();
    private List<MetadataAttributes> properties;
    private final QueryType queryType;
    private int depth = 0;
    private int resultStart = 0;
    private int resultCount = 0;
    private Boolean includeCalculatedMembers = null;
    private boolean returnSchema = false;
    private Collection<Object> ppdsCodes = null;
    private MASearchCriteria memberSearchCondition = null;
    private static final List<MetadataAttributes> PROP_ALIA = Arrays.asList(MetadataAttributes.Alias_Table_Name, MetadataAttributes.Dimension_Unique_Name);
    private static final List<MetadataAttributes> PROP_CATA = Arrays.asList(MetadataAttributes.Catalog_Name, MetadataAttributes.Description);
    private static final List<MetadataAttributes> PROP_CUBE = Arrays.asList(MetadataAttributes.Cube_Name, MetadataAttributes.Description, MetadataAttributes.Created_On, MetadataAttributes.Last_Data_Update, MetadataAttributes.Last_Schema_Update, MetadataAttributes.Is_Optimized, MetadataAttributes.Default_Measure, MetadataAttributes.Current_Period, MetadataAttributes.Suppression);
    private static final List<MetadataAttributes> PROP_DIME = Arrays.asList(MetadataAttributes.Dimension_Name, MetadataAttributes.Dimension_Unique_Name, MetadataAttributes.Dimension_Group_Name, MetadataAttributes.Caption, MetadataAttributes.Measure_Dimension, MetadataAttributes.Regular_Dimension, MetadataAttributes.Time_Dimension, MetadataAttributes.Description, MetadataAttributes.Default_Hierarchy, MetadataAttributes.Cardinality, MetadataAttributes.PPDS_CODE, MetadataAttributes.PPDS_KEY, MetadataAttributes.Type, MetadataAttributes.Is_Hidden);
    private static final List<MetadataAttributes> PROP_HIER = Arrays.asList(MetadataAttributes.Dimension_Unique_Name, MetadataAttributes.Hierarchy_Unique_Name, MetadataAttributes.Hierarchy_Name, MetadataAttributes.Caption, MetadataAttributes.Balanced_Hierarchy, MetadataAttributes.Ragged_Hierarchy, MetadataAttributes.Description, MetadataAttributes.PPDS_CODE, MetadataAttributes.PPDS_KEY, MetadataAttributes.Cardinality, MetadataAttributes.Is_Hidden, MetadataAttributes.Parent_Child_Hierarchy, MetadataAttributes.Default_Member);
    private static final List<MetadataAttributes> PROP_LEVE = Arrays.asList(MetadataAttributes.Dimension_Unique_Name, MetadataAttributes.Hierarchy_Unique_Name, MetadataAttributes.Level_Unique_Name, MetadataAttributes.Level_Name, MetadataAttributes.Caption, MetadataAttributes.Level_Number, MetadataAttributes.Is_Unique, MetadataAttributes.Description, MetadataAttributes.PPDS_CODE, MetadataAttributes.PPDS_KEY, MetadataAttributes.Is_Hidden, MetadataAttributes.Cardinality, MetadataAttributes.Base_Attribute_Hierarchy);
    private static final List<MetadataAttributes> PROP_MEAS = Arrays.asList(MetadataAttributes.Measure_Unique_Name, MetadataAttributes.Caption, MetadataAttributes.Measure_Name, MetadataAttributes.Aggregator, MetadataAttributes.Timestate_Aggregator, MetadataAttributes.Description, MetadataAttributes.Data_Type, MetadataAttributes.PPDS_CODE, MetadataAttributes.PPDS_KEY, MetadataAttributes.Precision, MetadataAttributes.Scale, MetadataAttributes.Units);
    private static final List<MetadataAttributes> PROP_MEMB = Arrays.asList(MetadataAttributes.Dimension_Unique_Name, MetadataAttributes.Hierarchy_Unique_Name, MetadataAttributes.Member_Name, MetadataAttributes.Member_Unique_Name, MetadataAttributes.Caption, MetadataAttributes.Level_Number, MetadataAttributes.Level_Unique_Name, MetadataAttributes.Parent_Level, MetadataAttributes.Parent_Unique_Name, MetadataAttributes.Description, MetadataAttributes.Number_Of_Parents, MetadataAttributes.Has_Children, MetadataAttributes.PPDS_CODE, MetadataAttributes.PPDS_KEY, MetadataAttributes.Type, MetadataAttributes._rollupType);
    private static final List<MetadataAttributes> PROP_PROP = Arrays.asList(MetadataAttributes.Attribute_Unique_Name, MetadataAttributes.Attribute_Name, MetadataAttributes.Caption, MetadataAttributes.Data_Type, MetadataAttributes.Role, MetadataAttributes.Description);

    public MDDSMetadataQuery(ExecutionEnvironment theExecEnv, ConnectionParameters connectionParameters, QueryType type) {
        this.connectionParams = connectionParameters;
        this.queryType = type;
        this.initializeProperties();
    }

    private void initializeProperties() {
        switch (this.queryType) {
            case AliasTable: {
                this.properties = PROP_ALIA;
                break;
            }
            case Catalog: {
                this.properties = PROP_CATA;
                break;
            }
            case Cube: {
                this.properties = PROP_CUBE;
                break;
            }
            case Dimensions: {
                this.properties = PROP_DIME;
                break;
            }
            case Hierarchies: {
                this.properties = PROP_HIER;
                break;
            }
            case Levels: {
                this.properties = PROP_LEVE;
                break;
            }
            case Measures: {
                this.properties = PROP_MEAS;
                break;
            }
            case Members: {
                this.properties = PROP_MEMB;
                break;
            }
            case Attributes: {
                this.properties = PROP_PROP;
                break;
            }
        }
    }

    public void addRestriction(RestrictionType restriction, String value) {
        if (restriction != null && value != null) {
            this.constraints.put(constraintsMap.get(restriction), value);
        }
    }

    public void setPPDSCodeConstraints(Collection<Object> thePPDSCodes) {
        this.ppdsCodes = thePPDSCodes;
    }

    public void setMAMemberSearchCriteria(MASearchCriteria criteria) {
        this.memberSearchCondition = criteria;
    }

    public void setAliases(Map<Object, String> aliases) {
        this.aliasMap = aliases;
    }

    public void setProperties(List<MetadataAttributes> theProperties) {
        this.properties = theProperties;
    }

    public void setResultRange(int from, int count) {
        if (from >= 0) {
            this.resultStart = from;
        }
        if (count >= 0) {
            this.resultCount = count;
        }
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public void setIncludeCalculatedMembers(boolean includeCalMembers) {
        this.includeCalculatedMembers = includeCalMembers;
    }

    public void setReturnSchema(boolean returnSchemaFlag) {
        this.returnSchema = returnSchemaFlag;
    }

    public String getQueryString(boolean forLogging) {
        StringWriter stringWriter = new StringWriter();
        XMLStreamWriter xmlWriter = null;
        try {
            xmlWriter = StaxUtil.createXMLStreamWriter((Writer)stringWriter);
            MDDSUtils.writeStartMDQuery(xmlWriter);
            ConnectionParameterHelper.writeXML(this.connectionParams, xmlWriter, forLogging);
            this.writeMetadataElement(xmlWriter);
            String requestID = (String)this.connectionParams.valueOf(RequestIdParameter.class, String.class);
            if (requestID != null) {
                xmlWriter.writeEmptyElement("requestID");
                xmlWriter.writeAttribute(XML_ATTR_VALUE, requestID);
            }
            MDDSUtils.writeEndMDQuery(xmlWriter);
            xmlWriter.close();
            xmlWriter = null;
        }
        catch (Exception e) {
            throw new MDDSException(MDDSMessageKeys.MET_UNEXPECTED_ERROR, e);
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (XMLStreamException e) {
                    MDDSLogger.getLogger("Metadata", LogLevel.WARN).log("Failed to close XMLStreamWriter when generating MDDS metadata query: " + e);
                }
            }
            if (stringWriter != null) {
                try {
                    stringWriter.close();
                }
                catch (IOException e) {
                    MDDSLogger.getLogger("Metadata", LogLevel.WARN).log("Failed to close StringWriter when generating MDDS metadata query.");
                }
            }
        }
        return stringWriter.toString();
    }

    public RecordType getRecordType() {
        return this.queryType.getRecordType();
    }

    private void writeMetadataElement(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement(XML_ELEM_METADATA);
        xmlWriter.writeAttribute(XML_ATTR_CLASS, this.queryType.toString());
        xmlWriter.writeAttribute(XML_ATTR_DEPTH, String.valueOf(this.depth));
        xmlWriter.writeAttribute(XML_ATTR_RESULT_COUNT, String.valueOf(this.resultCount));
        xmlWriter.writeAttribute(XML_ATTR_RESULT_START, String.valueOf(this.resultStart));
        xmlWriter.writeAttribute(XML_ATTR_RETURN_SCHEMA, String.valueOf(this.returnSchema));
        if (this.queryType.equals((Object)QueryType.Members)) {
            xmlWriter.writeEmptyElement(XML_ELEM_INCLUDE_CALC_MEMBERS);
            xmlWriter.writeAttribute(XML_ATTR_VALUE, String.valueOf(this.includeCalculatedMembers));
        }
        xmlWriter.writeStartElement(XML_ELEM_PROPERTIES);
        for (MetadataAttributes attr : this.properties) {
            xmlWriter.writeEmptyElement(XML_ELEM_PROPERTY);
            xmlWriter.writeAttribute(XML_ATTR_NAME, PROPERTY_PREFIX + attr.toString());
        }
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(XML_ELEM_CONSTRAINTS);
        for (String c : this.constraints.keySet()) {
            xmlWriter.writeEmptyElement(XML_ELEM_CONSTRAINT);
            xmlWriter.writeAttribute(XML_ATTR_CONDITION, CONDITION_PREFIX + c.toString() + CONDITION_MIDDLE + this.constraints.get(c) + CONDITION_SUFFIX);
        }
        if (this.ppdsCodes != null && !this.ppdsCodes.isEmpty() || this.memberSearchCondition != null) {
            xmlWriter.writeStartElement(XML_ELEM_PROVIDER_CONSTRAINTS);
            this.writeMemberSearchConstraint(xmlWriter);
            this.writePPDSCodeConstraints(xmlWriter);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        if (this.aliasMap != null && !this.aliasMap.isEmpty()) {
            xmlWriter.writeStartElement(XML_ELEM_ALIASTABLEMAP);
            for (Object key : this.aliasMap.keySet()) {
                String[] arr;
                if (key == null) continue;
                String lang = key.toString();
                String name = this.aliasMap.get(key);
                if (name == null) {
                    name = "";
                    xmlWriter.writeStartElement(XML_ELEM_ALIASTABLE);
                    xmlWriter.writeAttribute(XML_ATTR_NAME, name);
                    xmlWriter.writeAttribute(XML_ATTR_LANG, lang);
                    xmlWriter.writeEndElement();
                    continue;
                }
                for (String s : arr = name.split(";")) {
                    xmlWriter.writeStartElement(XML_ELEM_ALIASTABLE);
                    xmlWriter.writeAttribute(XML_ATTR_NAME, s);
                    xmlWriter.writeAttribute(XML_ATTR_LANG, lang);
                    xmlWriter.writeEndElement();
                }
            }
            xmlWriter.writeEndElement();
        }
    }

    private void writeMemberSearchConstraint(XMLStreamWriter xmlWriter) throws XMLStreamException {
        MASearchCriteria.SearchCondition condition;
        if (this.memberSearchCondition != null && (condition = this.memberSearchCondition.getSearchCondition()) != MASearchCriteria.SearchCondition.NOT_DEFINED) {
            xmlWriter.writeEmptyElement(XML_ELEM_CONSTRAINT);
            boolean caseInsensitive = this.memberSearchCondition.getCaseInsensitive();
            xmlWriter.writeAttribute(XML_ATTR_CASE_INSENSITIVE, Boolean.toString(caseInsensitive));
            switch (condition) {
                case STARTS_WITH: {
                    xmlWriter.writeAttribute(XML_ATTR_OPERATION1, "startsWith");
                    break;
                }
                case EQUALS: {
                    xmlWriter.writeAttribute(XML_ATTR_OPERATION1, "equals");
                    break;
                }
                case ENDS_WITH: {
                    xmlWriter.writeAttribute(XML_ATTR_OPERATION1, "endsWith");
                    break;
                }
                default: {
                    xmlWriter.writeAttribute(XML_ATTR_OPERATION1, "contains");
                }
            }
            List values = this.memberSearchCondition.getSearchValues();
            StringBuilder value = new StringBuilder();
            for (String s : values) {
                value.append(s).append(" ");
            }
            xmlWriter.writeAttribute(XML_ATTR_VALUE, value.toString().trim());
            if (values.size() > 1) {
                MABlockConstraint.Operation op = this.memberSearchCondition.getOperator();
                if (op == MABlockConstraint.Operation.AND) {
                    xmlWriter.writeAttribute(XML_ATTR_CONDITION_TYPE, "and");
                } else if (op == MABlockConstraint.Operation.OR) {
                    xmlWriter.writeAttribute(XML_ATTR_CONDITION_TYPE, "or");
                }
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(CONDITION_PREFIX).append("_memberCaption");
            buffer.append(CONDITION_MIDDLE).append("MEMBER").append(CONDITION_SUFFIX);
            xmlWriter.writeAttribute(XML_ATTR_CONDITION, buffer.toString());
        }
    }

    private void writePPDSCodeConstraints(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (this.ppdsCodes != null && !this.ppdsCodes.isEmpty()) {
            int size = this.ppdsCodes.size();
            int count = 0;
            for (Object o : this.ppdsCodes) {
                String conditionValue = o.toString();
                xmlWriter.writeEmptyElement(XML_ELEM_CONSTRAINT);
                xmlWriter.writeAttribute(XML_ATTR_CONDITION, CONDITION_PREFIX + constraintsMap.get(RestrictionType.PPDS_CODES) + CONDITION_MIDDLE + conditionValue + CONDITION_SUFFIX);
                if (++count >= size) continue;
                xmlWriter.writeAttribute(XML_ATTR_OPERATION, XML_ATTR_OPERATION_OR);
            }
        }
    }

    static {
        constraintsMap.put(RestrictionType.CATALOG, "Catalog_Name");
        constraintsMap.put(RestrictionType.SCHEMA, "Schema_Name");
        constraintsMap.put(RestrictionType.CUBE, "Cube_Name");
        constraintsMap.put(RestrictionType.DIMENSION_UNIQUE_NAME, "Dimension_Unique_Name");
        constraintsMap.put(RestrictionType.HIERARCHY_UNIQUE_NAME, "Hierarchy_Unique_Name");
        constraintsMap.put(RestrictionType.LEVEL_UNIQUE_NAME, "Level_Unique_Name");
        constraintsMap.put(RestrictionType.LEVEL_NUMBER, "Level_Number");
        constraintsMap.put(RestrictionType.MEASURE_UNIQUE_NAME, "Measure_Unique_Name");
        constraintsMap.put(RestrictionType.TREEOP, "Tree_Operator");
        constraintsMap.put(RestrictionType.MEMBER_UNIQUE_NAME, "Member_Unique_Name");
        constraintsMap.put(RestrictionType.PROPERTY, "Attribute_Unique_Name");
        constraintsMap.put(RestrictionType.PPDS_CODES, "PPDS_CODE");
    }

    public static enum QueryType {
        Catalog(RecordType.CATALOG),
        Cube(RecordType.CUBE),
        Dimensions(RecordType.DIMENSION),
        Hierarchies(RecordType.HIERARCHY),
        Levels(RecordType.LEVEL),
        Measures(RecordType.MEASURE),
        Members(RecordType.MEMBER),
        Attributes(RecordType.PROPERTY),
        AliasTable(RecordType.ALIAS);

        private RecordType recordType;

        private QueryType(RecordType type) {
            this.recordType = type;
        }

        public RecordType getRecordType() {
            return this.recordType;
        }
    }
}

