/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata;

import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataAttributes;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSUtils;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MetadataResponseEntity {
    private final Map<MetadataAttributes, String> attributes = new EnumMap<MetadataAttributes, String>(MetadataAttributes.class);
    private LocalizedString caption = null;
    private Locale defaultLocale;

    public MetadataResponseEntity(Locale theDefaultLocale) {
        this.defaultLocale = theDefaultLocale;
    }

    public void addAttribute(String attribute, String value) {
        if (attribute != null && value != null) {
            MetadataAttributes attr = MetadataAttributes.valueOf(attribute);
            this.attributes.put(attr, value);
            if (attr.equals((Object)MetadataAttributes.Caption)) {
                this.addCaption(this.defaultLocale, value);
            }
        }
    }

    public void addCaption(String aLocale, String aCaption) {
        if (!MDDSUtils.isValidLanguageString(aLocale)) {
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_LOCALE, aLocale);
        }
        this.addCaption(LocaleConverter.strToLocale((String)aLocale), aCaption);
    }

    public void addCaption(Locale aLocale, String aCaption) {
        if (aLocale != null && aCaption != null) {
            if (this.caption == null) {
                this.caption = new LocalizedString(aLocale, aCaption);
            } else {
                this.caption.put(aLocale, aCaption);
            }
        }
    }

    public String getString(MetadataAttributes attribute, String defaultValue) {
        String value = this.attributes.get((Object)attribute);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public LocalizedString getCaption() {
        return this.caption;
    }

    public Boolean getBoolean(MetadataAttributes attribute) {
        return this.getBoolean(attribute, null);
    }

    public Boolean getBoolean(MetadataAttributes attribute, Boolean defaultValue) {
        String value;
        if (this.getString(attribute, null) != null && (value = this.getString(attribute, null).toUpperCase()) != null) {
            if (value.equals("TRUE") || value.equals("FALSE")) {
                return Boolean.valueOf(value);
            }
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_ATTRIBUTE_VALUE, attribute.toString(), value);
        }
        return defaultValue;
    }

    public Integer getInteger(MetadataAttributes attribute, Integer defaultValue) {
        String value = this.getString(attribute, null);
        int returnValue = defaultValue;
        if (value != null) {
            try {
                returnValue = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new MDDSException(MDDSMessageKeys.MET_INVALID_ATTRIBUTE_VALUE, attribute.toString(), value);
            }
        }
        return returnValue;
    }

    public Long getLong(MetadataAttributes attribute, Long defaultValue) {
        String value = this.getString(attribute, null);
        long returnValue = defaultValue;
        if (value != null) {
            try {
                returnValue = Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new MDDSException(MDDSMessageKeys.MET_INVALID_ATTRIBUTE_VALUE, attribute.toString(), value);
            }
        }
        return returnValue;
    }

    public Double getDouble(MetadataAttributes attribute, Double defaultValue) {
        String value = this.getString(attribute, null);
        double returnValue = defaultValue;
        if (value != null) {
            try {
                returnValue = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new MDDSException(MDDSMessageKeys.MET_INVALID_ATTRIBUTE_VALUE, attribute.toString(), value);
            }
        }
        return returnValue;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        if (writer != null && !this.attributes.isEmpty()) {
            writer.writeStartElement("entity");
            for (MetadataAttributes name : this.attributes.keySet()) {
                writer.writeAttribute(name.toString(), this.attributes.get((Object)name));
            }
            if (this.caption != null) {
                String[] locales;
                for (String locale : locales = this.caption.getSupportedLocales()) {
                    writer.writeStartElement("alias");
                    writer.writeAttribute("Caption", this.caption.toString(locale));
                    writer.writeAttribute("locale", locale);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }
}

