/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata.parser;

import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataResponse;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataResponseEntity;
import com.cognos.xqe.data.providers.olap.mdds.metadata.parser.MetadataResponseHandler;
import com.cognos.xqe.data.providers.olap.mdds.metadata.parser.MetadataResponseHandlerBase;
import com.cognos.xqe.data.providers.olap.mdds.metadata.parser.MetadataResponseParser;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MetadataEntityHandler
extends MetadataResponseHandlerBase {
    private MetadataResponseEntity entity = null;
    private final MetadataResponseHandler responseHanlder;
    private Locale defaultLocale;

    protected MetadataEntityHandler(MetadataResponseHandler theResponseHandler) {
        this.responseHanlder = theResponseHandler;
        this.defaultLocale = null;
    }

    @Override
    protected void releaseImpl() {
        this.entity = null;
    }

    @Override
    protected void resetImpl() {
        this.entity = null;
    }

    @Override
    protected void consumeCurrent(XMLStreamReader reader) throws XMLStreamException {
        MetadataResponseEntity localEntity;
        MetadataEntityHandler.assertAtStartElement(reader, MetadataResponseParser.ENTITY);
        if (this.defaultLocale == null) {
            throw new MDDSException(MDDSMessageKeys.MET_MISSING_RUN_LOCALE);
        }
        this.entity = localEntity = new MetadataResponseEntity(this.defaultLocale);
        int numAttributes = reader.getAttributeCount();
        for (int i = 0; i < numAttributes; ++i) {
            String attribute = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (attribute == null || value == null || attribute.length() <= 0) continue;
            localEntity.addAttribute(attribute, value);
        }
        MetadataResponse response = this.responseHanlder.getMetadataResponse();
        if (response != null) {
            response.add(localEntity);
        }
        if (this.entity != localEntity) {
            throw new ConcurrentModificationException("Concurrent access to MetadataEntityHandler not supported");
        }
    }

    public void setDefaultLocale(Locale theDefaultLocale) {
        if (theDefaultLocale == null) {
            throw new MDDSException(MDDSMessageKeys.MET_MISSING_RUN_LOCALE);
        }
        this.defaultLocale = theDefaultLocale;
    }

    protected MetadataResponseEntity getMetadataEntity() {
        return this.entity;
    }
}

