/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata.parser;

import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class MetadataResponseHandlerBase
implements IStaxComponentHandler,
IReleasable {
    private final Map<QName, MetadataResponseHandlerBase> subHandlers = new HashMap<QName, MetadataResponseHandlerBase>();
    private boolean released = false;

    public void reset() {
        for (MetadataResponseHandlerBase handler : this.subHandlers.values()) {
            handler.reset();
        }
        this.resetImpl();
    }

    public void release() {
        if (this.released) {
            return;
        }
        for (MetadataResponseHandlerBase handler : this.subHandlers.values()) {
            handler.release();
        }
        this.releaseImpl();
        this.released = true;
    }

    protected void registerSubHandler(QName elementName, MetadataResponseHandlerBase subHandler) {
        this.subHandlers.put(elementName, subHandler);
    }

    protected void unregisterSubHandler(QName elementName) {
        this.subHandlers.remove(elementName);
    }

    protected abstract void resetImpl();

    protected abstract void releaseImpl();

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        this.consumeCurrent(reader);
        this.consumeSub(reader);
    }

    protected abstract void consumeCurrent(XMLStreamReader var1) throws XMLStreamException;

    protected void consumeSub(XMLStreamReader reader) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            QName name = reader.getName();
            IStaxComponentHandler handler = null;
            for (QName elementName : this.subHandlers.keySet()) {
                if (!elementName.equals(name)) continue;
                handler = this.subHandlers.get(elementName);
                break;
            }
            if (null != handler) {
                handler.consume(reader);
                continue;
            }
            StaxUtil.skipElement((XMLStreamReader)reader);
        }
    }

    protected static void assertAtStartElement(XMLStreamReader reader, QName qualifiedName) throws MDDSException {
        if (reader.getEventType() != 1) {
            MetadataResponseHandlerBase.throwUnexpectedXMLEventException(1, reader.getEventType());
        }
        if (null != qualifiedName && !qualifiedName.equals(reader.getName())) {
            MetadataResponseHandlerBase.throwUnexpectedElementException(qualifiedName, reader.getName());
        }
    }

    protected static void throwUnexpectedXMLEventException(int expectedEvent, int actualEvent) throws MDDSException {
        throw new MDDSException(MDDSMessageKeys.PAR_UNEXPECTED_XML_EVENT, StaxUtil.eventTypeToString((int)expectedEvent), StaxUtil.eventTypeToString((int)actualEvent));
    }

    protected static void throwUnexpectedElementException(QName expectedName, QName actualName) throws MDDSException {
        throw new MDDSException(MDDSMessageKeys.PAR_UNEXPECTED_XML_ELEMENT, expectedName.getNamespaceURI() + ':' + expectedName.getLocalPart(), actualName.getNamespaceURI() + ':' + actualName.getLocalPart());
    }
}

