/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.query;

import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.query.ProviderDataQuery;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultIterator;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultPart;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NumericValue;
import org.apache.velocity.VelocityContext;

public class GetHierarchyDepthQuery
extends ProviderDataQuery {
    private static final String DEPTH = "Depth";
    private static final String TEMPLATE_PATH = "com/cognos/xqe/data/providers/olap/mdds/query/GetHierarchyDepthQuery.template";
    private final String hierarchyName;

    public GetHierarchyDepthQuery(MDDSConnection conn, String cubeName, String hun) {
        super(conn, cubeName);
        this.hierarchyName = hun;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    @Override
    protected VelocityContext getContext() {
        VelocityContext context = new VelocityContext();
        context.put("HIERARCHY_NAME", (Object)this.hierarchyName);
        return context;
    }

    @Override
    protected String getTemplatePath() {
        return TEMPLATE_PATH;
    }

    @Override
    protected String getQueryName() {
        return "GetHierarchyDepth";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDepth() {
        QFWQuery qfwQuery = this.getQFWQuery();
        QFWResultPart part = null;
        QFWResultIterator itr = null;
        try {
            part = qfwQuery.getResultPart(0);
            if (part == null) {
                throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_NULL_PARAM, this.getQueryName(), "QFWResultPart");
            }
            itr = part.getCellIterator();
            if (itr == null) {
                throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_NULL_PARAM, this.getQueryName(), "QFWResultIterator");
            }
            IValue value = itr.getResultCell();
            if (!value.getDataType().isNumeric()) {
                throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_INVALID_PARAM, this.getQueryName(), DEPTH);
            }
            NumericValue numeric = (NumericValue)value;
            int depth = numeric.getInteger();
            if (depth < 0) {
                throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_INVALID_PARAM, this.getQueryName(), DEPTH);
            }
            int n = depth;
            return n;
        }
        finally {
            if (itr != null) {
                itr.release();
            }
            if (part != null) {
                part.release();
            }
        }
    }
}

