/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.query;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSDataProvider;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.qfwbridge.QFWConnection;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.LogSystem;

public abstract class ProviderDataQuery
implements IReleasable {
    private static final String MDDS_CONNECTION = "MDDSConnection";
    private String mdQuerySpec;
    private final ExecutionEnvironment execEnv;
    private final String reqId;
    private final MDDSConnection connection;
    private boolean executed;
    private QFWQuery qfwQuery;
    private final String cubeName;
    private static XQELogger logger;

    protected abstract String getTemplatePath();

    protected abstract VelocityContext getContext();

    protected abstract String getQueryName();

    public ProviderDataQuery(MDDSConnection conn, String aCubeName) {
        this.connection = conn;
        if (this.connection == null) {
            throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_NULL_PARAM, this.getQueryName(), MDDS_CONNECTION);
        }
        if (!this.connection.isConnected()) {
            throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_INVALID_PARAM, this.getQueryName(), MDDS_CONNECTION);
        }
        this.execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (this.execEnv == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        this.reqId = this.execEnv.getRequestID();
        this.executed = false;
        this.cubeName = aCubeName;
    }

    protected QFWQuery execute() {
        if (!this.executed) {
            String querySpec = this.compileTemplate();
            this.mdQuerySpec = MDDSDataProvider.generateMDQuerySpec(this.execEnv, this.connection.getConnectionParameters(), this.reqId, querySpec, false);
            if (MDDSLogger.DATA_MDX.isOn(LogLevel.TRACE)) {
                String msg = MDDSDataProvider.generateMDQuerySpec(this.execEnv, this.connection.getConnectionParameters(), this.reqId, querySpec, true);
                MDDSLogger.DATA_MDX.log(LogLevel.TRACE, OperationEnum.START, "Executing MDQuerySpec: \n" + msg);
            }
            QFWConnection qfwConn = this.connection.getConnection();
            this.qfwQuery = qfwConn.createQuery(((RequestEnvironment)this.execEnv.getRequestEnvironment()).getProductLocale());
            try {
                this.qfwQuery.execute(this.mdQuerySpec);
                this.executed = true;
            }
            catch (Throwable ex) {
                MDDSLogger.DATA_MDX.log(LogLevel.ERROR, ex);
                this.qfwQuery.release();
                throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_EXEC_ERROR, ex, ex.getLocalizedMessage());
            }
            finally {
                MDDSLogger.DATA_MDX.log(LogLevel.TRACE, OperationEnum.END, "Finished executing MDQuerySpec.");
            }
        }
        return this.qfwQuery;
    }

    private InputStream loadTemplate() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(this.getTemplatePath());
        return stream;
    }

    public String getMDQuerySpec() throws Exception {
        if (this.mdQuerySpec == null) {
            String query = this.compileTemplate();
            this.mdQuerySpec = MDDSDataProvider.generateMDQuerySpec(this.execEnv, this.connection.getConnectionParameters(), this.reqId, query, false);
        }
        return this.mdQuerySpec;
    }

    private String compileTemplate() {
        InputStream inStream = this.loadTemplate();
        try {
            InputStreamReader reader = new InputStreamReader(inStream, "UTF-8");
            StringWriter writer = new StringWriter();
            VelocityContext context = this.getContext();
            context.put("CUBE_NAME", (Object)this.cubeName);
            Velocity.evaluate((Context)context, (Writer)writer, (String)"MDQuerySpec Template", (Reader)reader);
            writer.flush();
            String string = StringSubstitutionEngine.removeCStyleComments((String)writer.toString());
            return string;
        }
        catch (Exception e) {
            throw new MDDSException(MDDSMessageKeys.ERR_PROVIDER_QUERY_TEMPLATE, this.getQueryName());
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ex) {
                logger.log("Failed to close input stream: " + ex);
            }
        }
    }

    protected QFWQuery getQFWQuery() {
        if (this.executed) {
            return this.qfwQuery;
        }
        return this.execute();
    }

    public void release() {
        if (this.qfwQuery != null) {
            this.qfwQuery.release();
        }
    }

    static {
        try {
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)new MyVelocityLogger());
            Velocity.init();
        }
        catch (Exception ex) {
            throw new XQERuntimeException();
        }
        logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"MDDS", (String)"Exception", (LogLevel)LogLevel.ERROR);
    }

    private static final class MyVelocityLogger
    implements LogSystem {
        private MyVelocityLogger() {
        }

        public void logVelocityMessage(int level, String message) {
            LogLevel logLevel = MyVelocityLogger.convertLevel(level);
            XQELogger xqeLogger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"XQEODP", (String)"3rdParty", (LogLevel)LogLevel.TRACE);
            if (xqeLogger.isOn(logLevel)) {
                xqeLogger.log(logLevel, message);
            }
        }

        private static LogLevel convertLevel(int level) {
            return LogLevel.valueOf((int)level);
        }
    }
}

