/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.resultset;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.IProviderContextContainer;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.mdds.MDDSCancelListener;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSDataProvider;
import com.cognos.xqe.data.providers.olap.mdds.resultset.QFWCellIteratorAdaptor;
import com.cognos.xqe.data.providers.olap.mdds.resultset.QFWEdgeIteratorAdaptor;
import com.cognos.xqe.data.providers.qfwbridge.DatasetInfo;
import com.cognos.xqe.data.providers.qfwbridge.QFWConnection;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultPart;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;

public class MDDSDimensionalResult
extends ProviderResultSetBase
implements ICubeResultSet,
IProviderContextContainer {
    private QFWQuery qfwQuery;
    static final long serialVersionUID = 1L;
    private DatasetInfo datasetInfo = null;
    private QFWResultPart resultPart = null;
    private int numAxes = 0;
    private ICube cube = null;
    private IDimension[][] dimensions = null;
    private boolean hasSlicerAxis = false;
    private final XIterator mEmptyIterator;
    private MDDSConnection mddsConnRef = null;
    private MDDSCancelListener cancelListener;
    private final CancelManager cancelManager;

    public MDDSDimensionalResult(MDDSDataProvider provider, MDDSConnection connref, QFWQuery mainQuery, XDataContext xDataContext, MDXQueryArguments queryArgs) {
        super((DataProviderBase)provider, xDataContext, queryArgs.getRunLocale());
        MDXQuery mdxQuery = queryArgs.getMDXQuery();
        this.mddsConnRef = connref;
        this.qfwQuery = mainQuery;
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)xDataContext.getEnvironment();
        this.cancelManager = executionEnvironment.getCancelManager();
        this.mEmptyIterator = new EmptyIterator(xDataContext);
        QFWConnection qfwconn = this.mddsConnRef.getConnection();
        this.cancelListener = new MDDSCancelListener(qfwconn, executionEnvironment, (QueryArguments)queryArgs, connref.getConnectionParameters());
        this.cancelManager.addCancelHandler((ICancelable)this.cancelListener);
        if (this.qfwQuery != null) {
            this.datasetInfo = this.qfwQuery.getDatasetInfo(0);
            this.resultPart = this.qfwQuery.getResultPart(0);
            this.numAxes = this.datasetInfo.getNumEdges();
            if (this.datasetInfo.getNumEdges() > mdxQuery.getNumberOfEdges()) {
                this.hasSlicerAxis = true;
                --this.numAxes;
            }
            this.dimensions = new IDimension[this.numAxes][];
        }
        this.cube = mdxQuery.getReferencedCube();
    }

    public XIterator getAxisIterator(int axisNumber) {
        if (axisNumber >= this.getNumAxes() || axisNumber < 0) {
            throw new IllegalArgumentException();
        }
        if (this.datasetInfo == null || this.resultPart == null) {
            return this.mEmptyIterator;
        }
        return new QFWEdgeIteratorAdaptor(this, this.getDataContext(), this.datasetInfo.getEdgeInfo(axisNumber), this.resultPart.getEdgeIterator(axisNumber), this.cube, this.nodeId, axisNumber);
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public XCellIterator getCellIterator() {
        if (null != this.resultPart) {
            return new QFWCellIteratorAdaptor(this, this.getDataContext(), this.resultPart.getCellIterator(), this.nodeId);
        }
        return new QFWCellIteratorAdaptor(this, this.getDataContext(), null, this.nodeId);
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        return new QFWCellIteratorAdaptor(this, this.getDataContext(), this.resultPart.getCellIterator(), this.nodeId);
    }

    public int getNumAxes() {
        return this.numAxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITuple getSlicer() {
        if (!this.hasSlicerAxis || this.datasetInfo == null || this.resultPart == null) {
            return null;
        }
        int axes = this.getNumAxes();
        QFWEdgeIteratorAdaptor adaptor = new QFWEdgeIteratorAdaptor(this, this.getDataContext(), this.datasetInfo.getEdgeInfo(axes), this.resultPart.getEdgeIterator(axes), this.cube, this.nodeId, -1);
        ITuple aTuple = null;
        try {
            aTuple = (ITuple)adaptor.next();
        }
        finally {
            adaptor.release();
        }
        return aTuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDimension[] getDimensions(int axisNumber) {
        if (null == this.dimensions[axisNumber]) {
            XIterator iter = this.getAxisIterator(axisNumber);
            try {
                ITuple t = (ITuple)iter.next();
                this.dimensions[axisNumber] = null != t ? t.getDimensions() : new IDimension[0];
            }
            finally {
                iter.release();
            }
        }
        return this.dimensions[axisNumber];
    }

    public long getAxisSize(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public int getNumTabularMeasures() {
        return 0;
    }

    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    protected void releaseImpl() {
        try {
            if (this.cancelListener != null) {
                this.cancelManager.removeCancelHandler((ICancelable)this.cancelListener);
                this.cancelListener = null;
            }
            this.datasetInfo = null;
            this.resultPart = null;
            if (this.qfwQuery != null) {
                this.qfwQuery.release();
                this.qfwQuery = null;
            }
            this.qfwQuery = null;
            this.cube = null;
            if (this.mddsConnRef != null) {
                this.mddsConnRef.returnToPool();
                this.mddsConnRef = null;
            }
        }
        finally {
            super.releaseImpl();
        }
    }

    public Object[] getContext() {
        if (this.mddsConnRef != null) {
            return this.mddsConnRef.getContext();
        }
        return null;
    }

    static final class EmptyIterator
    extends XIterator {
        private EmptyIterator(XDataContext theContext) {
            super(theContext);
        }

        public long getIndex() {
            return -1L;
        }

        public Object nextImpl() {
            return null;
        }

        public void release() {
        }
    }
}

