/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.resultset;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.ProviderScrollableCellIteratorBase;
import com.cognos.xqe.data.providers.olap.mdds.resultset.MDDSDimensionalResult;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultIterator;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;

public class QFWCellIteratorAdaptor
extends ProviderScrollableCellIteratorBase {
    private QFWResultIterator sourceIterator = null;
    private ICell nextCell = null;
    private ICell currentCell = null;
    private boolean bHasNextCalled = false;

    public QFWCellIteratorAdaptor(MDDSDimensionalResult resultSet, XDataContext xDataContext, QFWResultIterator qfwIterator, Integer theNodeId) {
        super((ProviderResultSetBase)resultSet, xDataContext, theNodeId);
        this.sourceIterator = qfwIterator;
    }

    public final boolean hasNext() {
        if (!this.bHasNextCalled) {
            this.nextCell = this.fetchNext();
            this.bHasNextCalled = true;
        }
        return this.nextCell != null;
    }

    public final ICell nextImpl() {
        if (this.bHasNextCalled) {
            this.bHasNextCalled = false;
            this.currentCell = this.nextCell;
            this.nextCell = null;
        } else {
            this.currentCell = this.fetchNext();
        }
        if (this.currentCell == null) {
            return null;
        }
        this.currentOrdinal = this.currentCell.getOrdinal();
        return this.currentCell;
    }

    private ICell fetchNext() {
        try {
            ICell aCell = null;
            long ordinal = this.currentOrdinal;
            if (null == this.sourceIterator) {
                return null;
            }
            do {
                if (this.sourceIterator.next()) continue;
                if (this.currentOrdinal < ordinal) {
                    this.sourceIterator.goTo(this.currentOrdinal);
                }
                return null;
            } while ((aCell = this.fetchCell(++ordinal)) == null);
            return aCell;
        }
        catch (QFWException e) {
            String msg = e.getLocalizedMessage();
            if (msg.indexOf("RSA-ERR-0007") > 0) {
                throw new OperationCanceledException();
            }
            throw e;
        }
    }

    private ICell fetchCell(long ordinal) {
        ProviderCellBase aCell = null;
        IValue aValue = this.sourceIterator.getResultCell();
        if (aValue != null) {
            aCell = new ProviderCellBase(ordinal, aValue);
        }
        return aCell;
    }

    public void releaseImpl() {
        this.nextCell = null;
        this.currentCell = null;
        if (this.sourceIterator != null) {
            this.sourceIterator.release();
            this.sourceIterator = null;
        }
    }

    public ICell current() {
        if (this.currentOrdinal < 0L) {
            return null;
        }
        if (this.currentCell != null) {
            return this.currentCell;
        }
        if (this.bHasNextCalled) {
            if (!this.sourceIterator.goTo(this.currentOrdinal)) {
                return null;
            }
            this.bHasNextCalled = false;
            this.nextCell = null;
        }
        this.currentCell = this.fetchCell(this.currentOrdinal);
        return this.currentCell;
    }

    public boolean absolute(long index) {
        if (this.bHasNextCalled) {
            if (!this.sourceIterator.goTo(index)) {
                return false;
            }
            this.bHasNextCalled = false;
            this.nextCell = null;
        } else {
            if (this.currentOrdinal == index) {
                return true;
            }
            if (!this.sourceIterator.goTo(index)) {
                return false;
            }
        }
        this.currentCell = null;
        this.currentOrdinal = index;
        return true;
    }

    public boolean reset() {
        return this.absolute(0L);
    }

    public ICell byOrdinal(long ordinal) {
        if (!this.absolute(ordinal)) {
            return null;
        }
        return this.current();
    }

    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    public ICell previous() {
        throw new UnsupportedOperationException();
    }
}

